define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'addition/group/index' + location.search,
                    add_url: 'addition/group/add',
                    edit_url: 'addition/group/edit',
                    del_url: 'addition/group/del',
                    multi_url: 'addition/group/multi',
                    import_url: 'addition/group/import',
                    table: 'addition_group',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'addition_group_id',
                sortName: 'addition_group_id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'addition_group_id', title: __('Addition Rate Group No.')},
                        {field: 'addition_group_name', title: __('Addition Price Name'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'addition_group_remark', title: __('Remark'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {
                            field: 'operate',
                            title: __('Operate'),
                            table: table,
                            events: Table.api.events.operate,
                            formatter: Table.api.formatter.operate,
                            buttons: [
                                {
                                    name: 'edit_addition_rate',
                                    text: __('Addition Rate'),
                                    title: __('Addition Rate'),
                                    classname: 'btn btn-xs btn-info btn-addtabs',
                                    icon: '',
                                    url: 'addition/rate?addition_group_id={addition_group_id}'
                                }
                            ],
                        }
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
