define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            let window_search = window.location.search;
            const searchParams = new URLSearchParams(window_search.replaceAll('?addtabs=1', ''));
            let addition_group_id = searchParams.get('addition_group_id');
            Table.api.init({
                extend: {
                    index_url: 'addition/rate/index' + location.search,
                    add_url: 'addition/rate/add?addition_group_id='+addition_group_id,
                    edit_url: 'addition/rate/edit?addition_group_id='+addition_group_id,
                    del_url: 'addition/rate/del',
                    multi_url: 'addition/rate/multi',
                    import_url: 'addition/rate/import',
                    table: 'addition_rate',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'addition_rate_id',
                sortName: 'addition_rate_id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'addition_rate_id', title: __('Addition Rate No.')},
                        {
                            field: 'addition_group_id',
                            title: __('Addition group id'),
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source="addition/group/index" data-field="addition_group_name" data-primary-key="addition_group_id"'
                        },
                        {field: 'addition_rate_name', title: __('Addition Rate Name'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'addition_rate_price', title: __('Price')},
                        {field: 'addition_rate_remark', title: __('Remark'), operate: 'LIKE'},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
