define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'binding/detail/index' + location.search,
                    add_url: 'binding/detail/add',
                    edit_url: 'binding/detail/edit',
                    del_url: 'binding/detail/del',
                    multi_url: 'binding/detail/multi',
                    import_url: 'binding/detail/import',
                    table: 'binding_detail',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'binding_detail_id',
                sortName: 'binding_detail_id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'binding_detail_id', title: __('Binding_detail_id')},
                        {field: 'booking_detail_id', title: __('Booking_detail_id')},
                        {field: 'orders_code', title: __('Orders_code'), operate: 'LIKE'},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
