define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'binding/main/index' + location.search,
                    add_url: 'binding/main/add',
                    edit_url: 'binding/main/edit',
                    del_url: 'binding/main/del',
                    multi_url: 'binding/main/multi',
                    import_url: 'binding/main/import',
                    table: 'binding_main',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'binding_main_id',
                sortName: 'binding_main_id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'binding_main_id', title: __('Binding_main_id')},
                        {field: 'booking_id', title: __('Booking_id')},
                        {field: 'module_code', title: __('Module_code'), operate: 'LIKE'},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
