define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'booking/index' + location.search,
                    add_url: 'booking/add',
                    edit_url: 'booking/edit',
                    del_url: 'booking/del',
                    multi_url: 'booking/multi',
                    import_url: 'booking/import',
                    table: 'booking',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'booking_id',
                sortName: 'booking_id',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'booking_id', title: __('Booking_id')},
                        {field: 'confirmation_no', title: __('Confirmation_no'), operate: 'LIKE'},
                        {field: 'memberid', title: __('Memberid')},
                        {field: 'hierarchyid', title: __('Hierarchyid')},
                        {field: 'booking_method', title: __('Booking_method'), operate: 'LIKE'},
                        {field: 'booking_date', title: __('Booking_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'checkin_date', title: __('Checkin_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'checkout_date', title: __('Checkout_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'booking_weekno', title: __('Booking_weekno')},
                        {field: 'booking_price', title: __('Booking_price'), operate:'BETWEEN'},
                        {field: 'booking_status', title: __('Booking_status')},
                        {field: 'used_date', title: __('Used_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'duplicated_date', title: __('Duplicated_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'cancel_date', title: __('Cancel_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'remark', title: __('Remark'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'note', title: __('Note'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'createby', title: __('Createby'), operate: 'LIKE'},
                        {field: 'createdate', title: __('Createdate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'updateby', title: __('Updateby'), operate: 'LIKE'},
                        {field: 'updatedate', title: __('Updatedate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            this.init_js();
            Controller.api.bindevent();
        },
        edit: function () {
            this.init_js();
            Controller.api.bindevent();
        },
        init_js:function (){
            let that = this;
            $(document).on("fa.event.appendfieldlist", '.btn-append', function(e, obj){
                Form.events.selectpage(obj);
                Form.events.datetimepicker(obj);
            });

            $(document).on("change", "#c-entitlement_year", function(){
                that.checkweek();
            });

            $(document).on("blur", "#c-msd_mid", function(){
                that.checkweek();
            });
            $(document).on("blur", "#c-msd_weekend", function(){
                that.checkweek();
            });
            $(document).on("blur", "#c-room", function(){
                that.checkweek();
            });
        },
        checkweek:function (){
            var ms_detail_id = $('#c-entitlement_year').val();
            var Fullweek = $('#c-msd_full').val();
            var Midweek = $('#c-msd_mid').val();
            var Weekend = $('#c-msd_weekend').val();
            var RoomAmount = $('#c-room').val();
            var used_FW = $('#c-hDefaultFW').val() || '';
            var used_MW = $('#c-hDefaultMW').val() || '';
            var used_WE = $('#c-hDefaultWE').val() || '';

            if(ms_detail_id=='') ms_detail_id=0;
            if(Fullweek=='') Fullweek=0;
            if(Midweek=='') Midweek=0;
            if(Weekend=='') Weekend=0;
            $.post('booking/check_available_week',{
                ms_detail_id,
                Fullweek,
                Midweek,
                Weekend,
                RoomAmount,
                used_FW,
                used_MW,
                used_WE,
            },function (msg){
                if (msg.error_msg){
                    Layer.msg(msg.error_msg);
                }
                if (msg.membership_type){
                    $('#c-membership_type').text(msg.membership_type);
                }
                if (msg.msd_full){
                    $('#c-msd_full').val(msg.msd_full);
                }
                if (msg.msd_mid){
                    $('#c-msd_mid').val(msg.msd_mid);
                }
                if (msg.msd_weekend){
                    $('#c-msd_weekend').val(msg.msd_weekend);
                }
                if (msg.ava_full){
                    $('#c-ava_full').text(msg.ava_full);
                }
                if (msg.ava_mid){
                    $('#c-ava_mid').text(msg.ava_mid);
                }
                if (msg.ava_weekend){
                    $('#c-ava_weekend').text(msg.ava_weekend);
                }
                if (msg.hStatusBooked){
                    $('#c-hStatusBooked').val(msg.hStatusBooked);
                }
            },'json');
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
