define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'booking.detail/index' + location.search,
                    add_url: 'booking.detail/add',
                    edit_url: 'booking.detail/edit',
                    del_url: 'booking.detail/del',
                    multi_url: 'booking.detail/multi',
                    import_url: 'booking.detail/import',
                    table: 'booking_detail',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'booking_detail_id',
                sortName: 'booking_detail_id',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'booking_detail_id', title: __('Booking_detail_id')},
                        {field: 'booking_id', title: __('Booking_id')},
                        {field: 'resort_id', title: __('Resort_id')},
                        {field: 'checkin_date', title: __('Checkin_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'checkout_date', title: __('Checkout_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'booking_detail_fullweek', title: __('Booking_detail_fullweek')},
                        {field: 'booking_detail_midweek', title: __('Booking_detail_midweek')},
                        {field: 'booking_detail_weekend', title: __('Booking_detail_weekend')},
                        {field: 'booking_detail_extranight', title: __('Booking_detail_extranight')},
                        {field: 'booking_detail_unittype', title: __('Booking_detail_unittype'), operate: 'LIKE'},
                        {field: 'room', title: __('Room')},
                        {field: 'booking_status', title: __('Booking_status')},
                        {field: 'status_date', title: __('Status_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'remark', title: __('Remark'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'createby', title: __('Createby'), operate: 'LIKE'},
                        {field: 'createdate', title: __('Createdate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'updateby', title: __('Updateby'), operate: 'LIKE'},
                        {field: 'updatedate', title: __('Updatedate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
