define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'booking.unittype/index' + location.search,
                    add_url: 'booking.unittype/add',
                    edit_url: 'booking.unittype/edit',
                    del_url: 'booking.unittype/del',
                    multi_url: 'booking.unittype/multi',
                    import_url: 'booking.unittype/import',
                    table: 'booking_unittype',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'booking_unittype_id',
                sortName: 'booking_unittype_id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'booking_unittype_id', title: __('Booking_unittype_id')},
                        {field: 'booking_id', title: __('Booking_id')},
                        {field: 'unittype', title: __('Unittype')},
                        {field: 'room_amount', title: __('Room_amount')},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
