define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'check/payment/online/index' + location.search,
                    add_url: 'check/payment/online/add',
                    edit_url: 'check/payment/online/edit',
                    del_url: 'check/payment/online/del',
                    multi_url: 'check/payment/online/multi',
                    import_url: 'check/payment/online/import',
                    table: 'check_payment_online',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'check_id',
                sortName: 'check_id',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'check_id', title: __('Check_id')},
                        {field: 'check_year', title: __('Check_year'), operate: 'LIKE'},
                        {field: 'no', title: __('No'), operate: 'LIKE'},
                        {field: 'contract', title: __('Contract'), operate: 'LIKE'},
                        {field: 'firstname1', title: __('Firstname1'), operate: 'LIKE'},
                        {field: 'FirstOccu', title: __('Firstoccu'), operate: 'LIKE'},
                        {field: 'no_of_week', title: __('No_of_week'), operate: 'LIKE'},
                        {field: 'unit', title: __('Unit'), operate: 'LIKE'},
                        {field: 'service_type', title: __('Service_type'), operate: 'LIKE'},
                        {field: 'received_date', title: __('Received_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'approval_code', title: __('Approval_code'), operate: 'LIKE'},
                        {field: 'payment_method', title: __('Payment_method'), operate: 'LIKE'},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
