define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'confirmation/type/index' + location.search,
                    add_url: 'confirmation/type/add',
                    edit_url: 'confirmation/type/edit',
                    del_url: 'confirmation/type/del',
                    multi_url: 'confirmation/type/multi',
                    import_url: 'confirmation/type/import',
                    table: 'confirmation_type',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'confirmation_type_id',
                sortName: 'confirmation_type_id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'confirmation_type_id', title: __('Confirmation_type_id')},
                        {field: 'confirmation_type', title: __('Confirmation_type')},
                        {field: 'confirmation_counter', title: __('Confirmation_counter')},
                        {field: 'confirmation_remark', title: __('Confirmation_remark'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
