define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'hierarchy/index' + location.search,
                    add_url: 'hierarchy/add',
                    edit_url: 'hierarchy/edit',
                    del_url: 'hierarchy/del',
                    multi_url: 'hierarchy/multi',
                    import_url: 'hierarchy/import',
                    table: 'hierarchy',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'hierarchyid',
                sortName: 'hierarchyid',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'hierarchyid', title: __('Hierarchyid')},
                        {field: 'memberid', title: __('Memberid')},
                        {field: 'partnerid', title: __('Partnerid')},
                        {field: 'packageid', title: __('Packageid')},
                        {field: 'membercode', title: __('Membercode'), operate: 'LIKE'},
                        {field: 'season_type', title: __('Season_type'), operate: 'LIKE'},
                        {field: 'FYO', title: __('Fyo')},
                        {field: 'LYO', title: __('Lyo')},
                        {field: 'hidden', title: __('Hidden')},
                        {field: 'contract_status', title: __('Contract_status'), operate: 'LIKE', formatter: Table.api.formatter.status},
                        {field: 'first_maintfee_due', title: __('First_maintfee_due'), operate: 'LIKE'},
                        {field: 'contact_date', title: __('Contact_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'servicetype', title: __('Servicetype'), operate: 'LIKE'},
                        {field: 'createby', title: __('Createby'), operate: 'LIKE'},
                        {field: 'createdate', title: __('Createdate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'updateby', title: __('Updateby'), operate: 'LIKE'},
                        {field: 'updatedate', title: __('Updatedate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'statused', title: __('Statused')},
                        {field: 'paid', title: __('Paid')},
                        {field: 'tweek', title: __('Tweek')},
                        {field: 'tday', title: __('Tday')},
                        {field: 'uweek', title: __('Uweek')},
                        {field: 'uday', title: __('Uday')},
                        {field: 'oweek', title: __('Oweek')},
                        {field: 'oday', title: __('Oday')},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
