define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'invoice/bank/order/index' + location.search,
                    add_url: 'invoice/bank/order/add',
                    edit_url: 'invoice/bank/order/edit',
                    del_url: 'invoice/bank/order/del',
                    multi_url: 'invoice/bank/order/multi',
                    import_url: 'invoice/bank/order/import',
                    table: 'invoice_bank_order',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'bank_orders_id',
                sortName: 'bank_orders_id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'bank_orders_id', title: __('Bank_orders_id')},
                        {field: 'bank_invoice_id', title: __('Bank_invoice_id')},
                        {field: 'orders_id', title: __('Orders_id')},
                        {field: 'orders_price', title: __('Orders_price')},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
