define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'invoice/bank/transaction/index' + location.search,
                    add_url: 'invoice/bank/transaction/add',
                    edit_url: 'invoice/bank/transaction/edit',
                    del_url: 'invoice/bank/transaction/del',
                    multi_url: 'invoice/bank/transaction/multi',
                    import_url: 'invoice/bank/transaction/import',
                    table: 'invoice_bank_transaction',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'transaction_id',
                sortName: 'transaction_id',
                columns: [
                    [
                        {
                            field: 'transaction_id',
                            title: __('transaction_id')
                        },
                        {
                            field: 'bank_invoice_no',
                            title: __('bank_invoice_no'),
                            operate: 'LIKE',
                            formatter: function (value, row) {
                                if (!value) {
                                    return '-';
                                }
                                let url = Config.moduleurl + '/invoice_response?invoice='+value;
                                return '<a href="'+url+'" class="btn-addtabs">'+value+'</a>';
                            },
                        },
                        {
                            field: 'ms_detail_paid_date',
                            title: __('paid_date'),
                            addclass: 'datetimerange',
                            autocomplete: false,
                            operate: 'RANGE',
                        },
                        {
                            field: 'entitlement_year',
                            title: __('entitlement_year'),
                        },
                        {
                            field: 'paid_amount',
                            title: __('paid_amount'),
                            operate: false,
                        },
                        {
                            field: 'bank_responce',
                            title: __('bank_responce'),
                            operate: false,
                        },
                        {
                            field: 'responce_code',
                            title: __('responce_code'),
                            operate: false,
                        },
                        {
                            field: 'responce_time',
                            title: __('responce_time'),
                            addclass: 'datetimerange',
                            autocomplete: false,
                            operate: 'RANGE',
                        },
                        {
                            field: 'ms_detail_id',
                            title: __('ms_detail_id'),
                        },
                        {
                            field: 'membership_id',
                            title: __('membership_id'),
                        },
                        {
                            field: 'membership_type_name',
                            title: __('membership_type (id)'),
                            operate: 'LIKE',
                            formatter: function (value, row) {
                               return value +'('+row.membership_type_id+')';
                            },
                        },
                        {
                            field: 'member_id',
                            title: __('member_id'),
                        },
                        {
                            field: 'member.username',
                            title: __('username'),
                            operate: 'LIKE',
                            formatter: function (value, row) {
                                return row.member.username || '';
                            },
                        },
                        {
                            field: 'member.login_name',
                            title: __('member_name'),
                            formatter: function (value, row) {
                                return row.member.login_name +' '+row.member.login_surname;
                            },
                            operate: 'LIKE',
                        },
                    ]
                ]
            });

            $(document).on("click", ".btn-responce", function () {
                layer.open({
                    type: 1,
                    area: ['80%', '90%'],
                    title: __('Response Code Remark'),
                    shade: 0.6, // 遮罩透明度
                    shadeClose: true,
                    maxmin: true,
                    anim: 0,
                    content: '<div style="text-align: center;"><img src="/images/responce-code.jpg" /></div>'
                });
            });


            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
