define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'invoice/history/index' + location.search,
                    add_url: 'invoice/history/add',
                    edit_url: 'invoice/history/edit',
                    del_url: 'invoice/history/del',
                    multi_url: 'invoice/history/multi',
                    import_url: 'invoice/history/import',
                    table: 'invoice_history',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'invoice_id',
                sortName: 'invoice_id',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'invoice_id', title: __('Invoice_id')},
                        {field: 'invoice_no', title: __('Invoice_no'), operate: 'LIKE'},
                        {field: 'invoice_year', title: __('Invoice_year')},
                        {field: 'member_id', title: __('Member_id')},
                        {field: 'hierarchyid', title: __('Hierarchyid')},
                        {field: 'ms_detail_id', title: __('Ms_detail_id')},
                        {field: 'dead_line', title: __('Dead_line'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'print_time', title: __('Print_time'), operate: 'LIKE'},
                        {field: 'entitlement_year', title: __('Entitlement_year')},
                        {field: 'advance_year', title: __('Advance_year')},
                        {field: 'contract_no', title: __('Contract_no'), operate: 'LIKE'},
                        {field: 'member_name', title: __('Member_name'), operate: 'LIKE'},
                        {field: 'full_name', title: __('Full_name'), operate: 'LIKE'},
                        {field: 'province', title: __('Province'), operate: 'LIKE'},
                        {field: 'postalcode', title: __('Postalcode'), operate: 'LIKE'},
                        {field: 'invoice_date', title: __('Invoice_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'debit_usd', title: __('Debit_usd')},
                        {field: 'invoice_sort', title: __('Invoice_sort')},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
