define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'invoice/response/index' + location.search,
                    add_url: 'invoice/response/add',
                    edit_url: 'invoice/response/edit',
                    del_url: 'invoice/response/del',
                    multi_url: 'invoice/response/multi',
                    import_url: 'invoice/response/import',
                    table: 'invoice_response',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'response_id',
                sortName: 'response_id',
                fixedColumns: true,
                fixedRightNumber:0,
                columns: [
                    [
                        {field: 'response_id', title: __('response id')},
                        {
                            field: 'invoice',
                            title: __('invoice'),
                            operate: 'LIKE'
                        },
                        {field: 'resp_code', title: __('response code')},
                        {field: 'payment_status', title: __('Payment_status'), operate: 'LIKE', formatter: Table.api.formatter.status},
                        {field: 'authorize', title: __('Authorize'), operate: 'LIKE'},
                        {field: 'uaid', title: __('Uaid'), operate: 'LIKE'},

                        {field: 'timestamp', title: __('Timestamp'), operate: 'LIKE'},
                        {field: 'amount', title: __('Amount'), operate:'BETWEEN'},
                        {field: 'checksum', title: __('Checksum'), operate: 'LIKE'},
                        {field: 'cardtype', title: __('Cardtype'), operate: 'LIKE'},
                        {field: 'checksumcard2', title: __('Checksumcard2'), operate: 'LIKE'},
                        {field: 'http_referer', title: __('Http_referer'), operate: 'LIKE'},
                        {field: 'remark', title: __('Remark'), operate: 'LIKE'},
                        {field: 'response_datetime', title: __('Response_datetime'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'reponse_type', title: __('Reponse_type'), operate: 'LIKE'},
                    ]
                ]
            });


            $(document).on("click", ".btn-responce", function () {
                layer.open({
                    type: 1,
                    area: ['80%', '90%'],
                    title: __('Response Code Remark'),
                    shade: 0.6, // 遮罩透明度
                    shadeClose: true,
                    maxmin: true,
                    anim: 0,
                    content: '<div style="text-align: center;"><img src="/images/responce-code.jpg" /></div>'
                });
            });
            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
