define(['jquery', 'bootstrap', 'backend', 'table', 'form', 'bootstrap-select', 'bootstrap-datetimepicker'], function ($, undefined, Backend, Table, Form, Bselect, Bdate) {
    const searchParams = new URLSearchParams(window.location.search.replaceAll('?addtabs=1', ''));
    let member_type = searchParams.get('member_type');
    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'member/index' + location.search,
                    add_url: 'member/add?member_type=' + member_type,
                    edit_url: 'member/edit',
                    del_url: 'member/del',
                    multi_url: 'member/multi',
                    import_url: 'member/import',
                    hidden_url: 'member/hidden',
                    unhidden_url: 'member/unhidden',
                    table: 'member',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'memberid',
                sortName: 'memberid',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'memberid', title: __('ID')},
                        // {field: 'login_name', title: __('Login_name'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {
                            field: 'username',
                            title: __('Login Name'),
                            operate: 'LIKE',
                            table: table,
                            class: 'autocontent',
                            formatter: Table.api.formatter.content
                        },
                        {
                            field: 'username',
                            title: __('Full Name # 1'),
                            operate: false,
                            formatter: function (value, row) {
                                return row.title + row.login_name + ' ' + row.login_surname;
                            },
                        },
                        // {field: 'username', title: __('Username'), operate: 'LIKE'},
                        // {field: 'passwords', title: __('Passwords'), operate: 'LIKE'},
                        // {field: 'title', title: __('Title'), operate: 'LIKE'},
                        {
                            field: 'birthday',
                            title: __('Birth Day # 1'),
                            operate: 'RANGE',
                            visible: member_type == 'M',
                            addclass: 'datetimerange',
                            formatter: function (value, row) {
                                if (!value || value == '0000-00-00') {
                                    return '-';
                                }
                                let tmp = value.split('-');
                                tmp = tmp.reverse();
                                return tmp.join('/');
                            },
                            autocomplete: false
                        },
                        {
                            field: 'fullname2',
                            title: __('Full Name # 2'),
                            visible: member_type == 'M',
                            operate: false,
                            formatter: function (value, row) {
                                return row.title2 + row.fullname2 + ' ' + row.fullsurname2;
                            },
                        },
                        {
                            field: 'birthday2',
                            title: __('Birth Day # 2'),
                            operate: 'RANGE',
                            visible: member_type == 'M',
                            addclass: 'datetimerange',
                            formatter: function (value, row) {
                                if (!value || value == '0000-00-00') {
                                    return '-';
                                }
                                let tmp = value.split('-');
                                tmp = tmp.reverse();
                                return tmp.join('/');
                            },
                            autocomplete: false
                        },
                        {
                            field: 'marketer.marketerid',
                            title: __('Marketer'),
                            visible: member_type == 'M',
                            formatter: function (value, row) {
                                let val = row.marketer.login_name || '';
                                if (!val || val == '-') {
                                    return '';
                                }
                                return val;
                            },
                            addclass: 'selectpage',
                            extend: 'data-source="marketer/index" data-field="login_name" data-primary-key="marketerid"'
                        },
                        {field: 'province', title: __('Province'), operate: 'LIKE'},
                        {field: 'postalcode', title: __('Postalcode'), operate: 'LIKE'},
                        {
                            field: 'country.countryid',
                            formatter: function (value, row) {
                                return row.country.country_name || '';
                            },
                            title: __('Country'),
                            addclass: 'selectpage',
                            extend: 'data-source="country/index" data-field="country_name" data-primary-key="countryid"'
                        },
                        {field: 'phone', title: __('Tel No.'), operate: 'LIKE'},
                        {field: 'office', title: __('Office'), operate: 'LIKE'},
                        {field: 'mobile', title: __('Mobile'), operate: 'LIKE'},
                        {field: 'fax', title: __('Fax'), operate: 'LIKE'},
                        {field: 'email', title: __('E-mail'), operate: 'LIKE'},
                        {
                            field: 'language.language_name',
                            title: __('Language'),
                            formatter: function (value, row) {
                                if (!value || value == '-') {
                                    return '';
                                }
                                return value;
                            }
                        },
                        {
                            field: 'updatedate',
                            title: __('Last Updated On'),
                            operate: 'RANGE',
                            addclass: 'datetimerange',
                            autocomplete: false,
                            formatter: function (value, row) {
                                return row.updatedate_text || '-';
                            }
                        },
                        {
                            field: 'updateby',
                            title: __('Last Updated By'),
                            operate: 'LIKE',
                            formatter: function (value, row) {
                                return row.updateby_text || '';
                            }
                        },
                        {
                            field: 'remark',
                            title: __('Remark'),
                            operate: 'LIKE',
                            table: table,
                            class: 'autocontent',
                            formatter: Table.api.formatter.content
                        },
                        {
                            field: 'hierarchy.partnerid',
                            title: __('Club Name'),
                            formatter: function (value, row) {
                                return row.clubname_text || '';
                            },
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source="partner/index" data-field="login_name" data-primary-key="partnerid"'
                        },
                        {
                            field: 'hierarchy.packageid',
                            title: __('Membership Type Name'),
                            formatter: function (value, row) {
                                return row.package_text || '';
                            },
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source="package/index" data-field="packagename" data-primary-key="packageid"'
                        },
                        {
                            field: 'package.unittype',
                            title: __('Unit Type'),
                            formatter: function (value, row) {
                                return row.package_unittype_text || '';
                            },
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source=\'[{"id":"T0","name":"T0"},{"id":"T1","name":"T1"},{"id":"T2","name":"T2"},{"id":"T4","name":"T4"},{"id":"T9","name":"T9"},{"id":"T0V","name":"T0V"},{"id":"T1V","name":"T1V"},{"id":"T2v","name":"T2v"},{"id":"T2L","name":"T2L"},{"id":"T1PPV","name":"T1PPV"},{"id":"T2PPV","name":"T2PPV"},{"id":"ELSE","name":"ELSE"},{"id":"Any","name":"Any"}]\''
                        },
                        {
                            field: 'hierarchy.servicetype',
                            title: __('Service Type'),
                            formatter: function (value, row) {
                                return row.servicetype_text || '';
                            },
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source=\'[{"id":"Full","name":"Full"},{"id":"Odd","name":"Odd"},{"id":"Even","name":"Even"},{"id":"Else","name":"Else"}]\''
                        },
                        {
                            field: 'hierarchy.season_type',
                            title: __('Season Type'),
                            formatter: function (value, row) {
                                return row.seasontype_text || '';
                            },
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source=\'[{"id":"Red","name":"Red"},{"id":"White","name":"White"},{"id":"Blue","name":"Blue"},{"id":"Green","name":"Green"},{"id":"Yellow","name":"Yellow"}]\''
                        },
                        {
                            field: 'hidden',
                            title: __('Hidden'),
                            defaultValue: "0",
                            formatter: Table.api.formatter.status,
                            custom: {"0": "green", "1": "black"},
                            searchList: {0: __('No'), 1: __('Yes')}
                        },
                        // {field: 'title2', title: __('Title2'), operate: 'LIKE'},
                        {
                            field: 'member_type',
                            // defaultValue: "M",
                            visible: false,
                            title: __('Member'),
                            formatter: Table.api.formatter.status,
                            custom: {"M": "green", "N": "black"},
                            searchList: {"M": __('Yes'), "N": __('No')}
                        },
                        // {field: 'createby', title: __('Createby'), operate: 'LIKE'},
                        // {
                        //     field: 'createdate',
                        //     title: __('Createdate'),
                        //     operate: 'RANGE',
                        //     addclass: 'datetimerange',
                        //     autocomplete: false
                        // },
                        // {field: 'updateby_member', title: __('Updateby_member')},
                        // {field: 'user_priv', title: __('User_priv'), operate: 'LIKE'},
                        // {field: 'deleted', title: __('Deleted')},
                        {
                            field: 'operate',
                            title: __('Operate'),
                            table: table,
                            events: Table.api.events.operate,
                            formatter: Table.api.formatter.operate
                        }
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);

            $(document).on("click", ".btn-hidden", function () {
                let ids = Table.api.selectedids(table);
                Fast.api.ajax({
                    url: 'member/hidden',
                    data: {
                        ids
                    }
                }, function (data, ret) {
                    table.bootstrapTable('refresh');
                }, function (data, ret) {
                    Layer.msg(__('Operation failed'));
                });
            });

            $(document).on("click", ".btn-unhidden", function () {
                let ids = Table.api.selectedids(table);
                Fast.api.ajax({
                    url: 'member/unhidden',
                    data: {
                        ids
                    }
                }, function (data, ret) {
                    table.bootstrapTable('refresh');
                }, function (data, ret) {
                    Layer.msg(__('Operation failed'));
                });
            });
        },
        add: function () {
            $(document).on('fa.event.appendfieldlist', '.btn-append', function () {
                Form.events.selectpage('#add-form');
                $('.membership-selectpicker').selectpicker('refresh');
                $('.membership-season_type').selectpicker('refresh');
                $('.membership-FYO').selectpicker('refresh');
                $('.membership-LYO').selectpicker('refresh');
                $('.membership-datetimepicker').datetimepicker();
            });
            $(document).on("change", ".membership-partnerid", function () {
                let index = $(this).attr('data-index');
                let val = $("#partnerid-" + index).val();
                $("#packageid-" + index).val('');
                $("#packageid-" + index + "_text").val('');
                $("#packageid-" + index + "_text").selectPageClear();

                $("#packageid-" + index + '_text').data('selectPageObject').option.params = function () {
                    return {"custom[partnerid]": val};
                }
            });
            Controller.api.bindevent();
        },
        edit: function () {
            $(document).on('fa.event.appendfieldlist', '.btn-append', function (e, obj) {
                Form.events.selectpage('#edit-form');
                Form.events.datetimepicker($("form"));

                $('.membership-selectpicker').selectpicker('refresh');
                $('.membership-season_type').selectpicker('refresh');
                $('.membership-FYO').selectpicker('refresh');
                $('.membership-LYO').selectpicker('refresh');

                $('.membership-datetimepicker').datetimepicker();

                $(".membership-datetimepicker").trigger("change");

                $(".membership-FYO").each(function(){
                    let isRender = $(this).attr('data-render');
                    if ('0' == isRender){
                        $(this).attr('data-render','1');
                        let val = $(this).attr('data-value');
                        if (val){
                            $(this).selectpicker('val', val);
                        }
                    }
                });

                $(".membership-selectpicker").each(function(){
                    let isRender = $(this).attr('data-render');
                    if ('0' == isRender){
                        $(this).attr('data-render','1');
                        let val = $(this).attr('data-value');
                        if (val){
                            $(this).selectpicker('val', val);
                        }
                    }
                });

                $(".membership-season_type").each(function(){
                    let isRender = $(this).attr('data-render');
                    if ('0' == isRender){
                        $(this).attr('data-render','1');
                        let val = $(this).attr('data-value');
                        if (val){
                            $(this).selectpicker('val', val);
                        }
                    }
                });

                $(".membership-LYO").each(function(){
                    let isRender = $(this).attr('data-render');
                    if ('0' == isRender){
                        $(this).attr('data-render','1');
                        let val = $(this).attr('data-value');
                        if (val){
                            $(this).selectpicker('val', val);
                        }
                    }
                });
            });
            $(document).on("change", ".membership-partnerid", function () {
                let index = $(this).attr('data-index');
                let val = $("#partnerid-" + index).val();
                $("#packageid-" + index).val('');
                $("#packageid-" + index + "_text").val('');
                $("#packageid-" + index + "_text").selectPageClear();

                $("#packageid-" + index + '_text').data('selectPageObject').option.params = function () {
                    return {"custom[partnerid]": val};
                }
            });
            Controller.api.bindevent();
        },
        hidden: function () {
            Controller.api.bindevent();
        },
        unhidden: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
