define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            const searchParams = new URLSearchParams(window.location.search.replaceAll('?addtabs=1', ''));
            let paid_status = searchParams.get('paid_status');
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'membership/detail/index' + location.search,
                    add_url: 'membership/detail/add',
                    edit_url: 'membership/detail/edit',
                    del_url: 'membership/detail/del',
                    multi_url: 'membership/detail/multi',
                    import_url: 'membership/detail/import',
                    table: 'membership_detail',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'ms_detail_id',
                sortName: 'MB.ms_detail_id',
                fixedColumns: true,
                fixedRightNumber: 0,
                columns: [
                    [
                        // {checkbox: true},
                        {field: 'ms_detail_id', title: __('#'), operate: false},
                        {
                            field: 'H.contract_no',
                            title: __('Contract No'),
                            formatter: function (value, row) {
                                return row.ContractNo || '-';
                            },
                            operate: 'LIKE'
                        },
                        {
                            field: 'M.login_name',
                            title: __('1st Full Name'),
                            formatter: function (value, row) {
                                let FirstCus = row.FirstCus || '-';
                                let url = Config.moduleurl + '/service_center/' + (paid_status === 'Y' ? 'view_paid' : 'view_unpaid') + '?ids=' + row.memberid;
                                return '<a href="' + url + '" class="btn-dialog">' + FirstCus + '</a>';
                            },
                            operate: 'LIKE'
                        },
                        {
                            field: 'M.fullname2',
                            title: __('2nd Full Name'),
                            formatter: function (value, row) {
                                return row.SecondCus || '-';
                            },
                            operate: 'LIKE'
                        },
                        {
                            field: 'MB.ms_detail_year',
                            title: __('Year'),
                            formatter: function (value, row) {
                                return row.Year || '-';
                            },
                        },
                        {
                            field: 'package_price',
                            title: Config.is_thb_system ? __('MF (THB)') : __('MF (USD)'),
                            operate: false
                        },
                        {
                            field: 'special_amount',
                            title: Config.is_thb_system ? __('Special (THB)') : __('Special (USD)'),
                            operate: false
                        },
                        {
                            field: 'paid_amount',
                            title: __('Paid Amount'),
                            visible: paid_status === 'Y',
                            operate: false
                        },
                        {
                            field: 'remarks',
                            title: __('Remark'),
                            visible: paid_status === 'Y',
                            operate: false
                        },
                        {
                            field: 'MB.ms_detail_paid_date',
                            title: __('Paid Date'),
                            formatter: function (value, row) {
                                return row.PaidDate || '-';
                            },
                            visible: paid_status === 'Y',
                            operate: 'RANGE',
                            addclass: 'datetimerange',
                            autocomplete: false
                        },
                        {
                            field: 'PaidMethod',
                            title: __('Paid Method'),
                            visible: paid_status === 'Y',
                            operate: false
                        },
                        {field: 'InvoiceNo', title: __('Invoice No'), operate: false},
                        {
                            field: 'MB.bank_invoice_no',
                            title: __('Payment No'),
                            visible: paid_status === 'Y',
                            formatter: function (value, row) {
                                return row.PaymentNo || '-';
                            },
                            operate: 'LIKE'
                        },
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
