define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'membership/upgrade/history/index' + location.search,
                    add_url: 'membership/upgrade/history/add',
                    edit_url: 'membership/upgrade/history/edit',
                    del_url: 'membership/upgrade/history/del',
                    multi_url: 'membership/upgrade/history/multi',
                    import_url: 'membership/upgrade/history/import',
                    table: 'membership_upgrade_history',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'history_id',
                sortName: 'history_id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'history_id', title: __('History_id')},
                        {field: 'memberid', title: __('Memberid')},
                        {field: 'hierarchyid', title: __('Hierarchyid')},
                        {field: 'upgrade_date', title: __('Upgrade_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'F_ms_type', title: __('F_ms_type')},
                        {field: 'T_ms_type', title: __('T_ms_type')},
                        {field: 'start_year', title: __('Start_year')},
                        {field: 'ms_status', title: __('Ms_status')},
                        {field: 'updated', title: __('Updated')},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
