define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'merchant/username/index' + location.search,
                    add_url: 'merchant/username/add',
                    edit_url: 'merchant/username/edit',
                    del_url: 'merchant/username/del',
                    multi_url: 'merchant/username/multi',
                    import_url: 'merchant/username/import',
                    table: 'merchant_username',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'merchant_username_id',
                sortName: 'merchant_username_id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'merchant_username_id', title: __('Merchant_username_id')},
                        {field: 'merchant_id', title: __('Merchant_id'), operate: 'LIKE'},
                        {field: 'username', title: __('Username'), operate: 'LIKE'},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
