define(['jquery', 'bootstrap', 'backend', 'table', 'form', 'bootstrap-select', 'bootstrap-datetimepicker'], function ($, undefined, Backend, Table, Form, Bselect, Bdate) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'orders/index' + location.search,
                    add_url: 'orders/add',
                    edit_url: 'orders/edit',
                    del_url: 'orders/del',
                    multi_url: 'orders/multi',
                    import_url: 'orders/import',
                    table: 'orders',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'orders_id',
                sortName: 'orders_id',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'orders_id', title: __('Orders_id')},
                        {field: 'memberid', title: __('Memberid')},
                        {field: 'paid_method_id', title: __('Paid_method_id')},
                        {field: 'paid_method_str', title: __('Paid_method_str'), operate: 'LIKE'},
                        {field: 'doc_no', title: __('Doc_no'), operate: 'LIKE'},
                        {field: 'orders_code', title: __('Orders_code'), operate: 'LIKE'},
                        {field: 'orders_no', title: __('Orders_no'), operate: 'LIKE'},
                        {field: 'orders_date', title: __('Orders_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'orders_price', title: __('Orders_price'), operate:'BETWEEN'},
                        {field: 'due_date', title: __('Due_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'checkin_date', title: __('Checkin_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'checkout_date', title: __('Checkout_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'status_new', title: __('Status_new')},
                        {field: 'status_paid', title: __('Status_paid')},
                        {field: 'paid_completed', title: __('Paid_completed')},
                        {field: 'paid_date', title: __('Paid_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'cancel_date', title: __('Cancel_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'orders_renounce', title: __('Orders_renounce')},
                        {field: 'status_booking', title: __('Status_booking')},
                        {field: 'booking_renounce', title: __('Booking_renounce')},
                        {field: 'status_used', title: __('Status_used')},
                        {field: 'completed', title: __('Completed')},
                        {field: 'completed_date', title: __('Completed_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'account_confirm', title: __('Account_confirm')},
                        {field: 'bank_invoice_no', title: __('Bank_invoice_no'), operate: 'LIKE'},
                        {field: 'invoice_no', title: __('Invoice_no'), operate: 'LIKE'},
                        {field: 'invoice_sn', title: __('Invoice_sn')},
                        {field: 'invoice_year', title: __('Invoice_year')},
                        {field: 'send_email', title: __('Send_email')},
                        {field: 'remark', title: __('Remark'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'createby', title: __('Createby'), operate: 'LIKE'},
                        {field: 'createdate', title: __('Createdate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'updateby', title: __('Updateby'), operate: 'LIKE'},
                        {field: 'updatedate', title: __('Updatedate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            this.init_add_edit_js();
            Controller.api.bindevent();
        },
        edit: function () {
            this.init_add_edit_js();
            Controller.api.bindevent();
        },
        init_add_edit_js(){
            $(document).on("fa.event.appendfieldlist", '.btn-append', function(e, obj){
                Form.events.selectpage(obj);
                Form.events.datetimepicker(obj);
            });

            $(document).on("change", ".from_contract", function(){
                let val = $(this).val();
                let index = parseInt($(this).data('index'));
                let memberid = parseInt($(this).data('memberid'));
                $.post('orders/set_session_var',{
                    name:'from_contract',
                    memberid,
                    index,
                    val
                },function (){
                    $('#from_year_'+index).selectPageClear();
                    $('#from_unittype_'+index).val('');
                });
            });

            $(document).on("change", ".from_year", function(){
                let val = $(this).val();
                let index = parseInt($(this).data('index'));
                if (!val){
                    $('#from_unittype_'+index).val('');
                    return;
                }
                let memberid = parseInt($(this).data('memberid'));
                $.post('orders/get_from_unittype',{
                    memberid,
                    ms_detail_year:val
                },function (obj){
                    $('#from_unittype_'+index).val(obj.unittype || '');
                },'json');
            });

            $(document).on("change", ".addi_rate_id", function(){
                let val = $(this).val();
                let index = parseInt($(this).data('index'));
                if (!val){
                    $('#addi_rate_price_'+index).val('');
                    return;
                }
                $.post('orders/get_addi_rate_price',{
                    addi_rate_id:$('#addi_rate_id_'+index).val()
                },function (obj){
                    $('#addi_rate_price_'+index).val(obj.addition_rate_price || '');
                },'json');
            });

            $(document).on("click", ".order-datetimepicker1", function () {
                $('.table-responsive1').addClass('table-show');
            });
            $(document).on("blur", ".order-datetimepicker1", function () {
                $('.table-responsive1').removeClass('table-show');
            });
            $(document).on("click", ".order-datetimepicker2", function () {
                $('.table-responsive2').addClass('table-show');
            });
            $(document).on("blur", ".order-datetimepicker2", function () {
                $('.table-responsive2').removeClass('table-show');
            });
            $(document).on("click", ".order-datetimepicker3", function () {
                $('.table-responsive3').addClass('table-show');
            });
            $(document).on("blur", ".order-datetimepicker3", function () {
                $('.table-responsive3').removeClass('table-show');
            });
            $(document).on("click", ".order-datetimepicker4", function () {
                $('.table-responsive4').addClass('table-show');
            });
            $(document).on("blur", ".order-datetimepicker4", function () {
                $('.table-responsive4').removeClass('table-show');
            });
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
