define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'orders.addi/index' + location.search,
                    add_url: 'orders.addi/add',
                    edit_url: 'orders.addi/edit',
                    del_url: 'orders.addi/del',
                    multi_url: 'orders.addi/multi',
                    import_url: 'orders.addi/import',
                    table: 'orders_addi',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'orders_addi_id',
                sortName: 'orders_addi_id',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'orders_addi_id', title: __('Orders_addi_id')},
                        {field: 'orders_id', title: __('Orders_id')},
                        {field: 'orders_code', title: __('Orders_code'), operate: 'LIKE'},
                        {field: 'addi_rate_id', title: __('Addi_rate_id')},
                        {field: 'addi_rate_name', title: __('Addi_rate_name'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'addi_rate_price', title: __('Addi_rate_price'), operate:'BETWEEN'},
                        {field: 'addi_unit', title: __('Addi_unit')},
                        {field: 'grand_total', title: __('Grand_total'), operate:'BETWEEN'},
                        {field: 'paid_method_id', title: __('Paid_method_id')},
                        {field: 'status_paid', title: __('Status_paid')},
                        {field: 'status_booking', title: __('Status_booking')},
                        {field: 'status_renounce', title: __('Status_renounce')},
                        {field: 'addi_paid', title: __('Addi_paid')},
                        {field: 'addi_paid_amount', title: __('Addi_paid_amount'), operate:'BETWEEN'},
                        {field: 'addi_paid_date', title: __('Addi_paid_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'addi_used_date', title: __('Addi_used_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'addi_renounce_date', title: __('Addi_renounce_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'addi_account_confirm', title: __('Addi_account_confirm')},
                        {field: 'addi_booking_date', title: __('Addi_booking_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'remark', title: __('Remark'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'createby', title: __('Createby'), operate: 'LIKE'},
                        {field: 'createdate', title: __('Createdate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'updateby', title: __('Updateby'), operate: 'LIKE'},
                        {field: 'updatedate', title: __('Updatedate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
