define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'orders.bonus/index' + location.search,
                    add_url: 'orders.bonus/add',
                    edit_url: 'orders.bonus/edit',
                    del_url: 'orders.bonus/del',
                    multi_url: 'orders.bonus/multi',
                    import_url: 'orders.bonus/import',
                    table: 'orders_bonus',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'orders_bonus_id',
                sortName: 'orders_bonus_id',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'orders_bonus_id', title: __('Orders_bonus_id')},
                        {field: 'orders_id', title: __('Orders_id')},
                        {field: 'orders_code', title: __('Orders_code'), operate: 'LIKE'},
                        {field: 'resortid', title: __('Resortid')},
                        {field: 'paid_method_id', title: __('Paid_method_id')},
                        {field: 'bonus_type', title: __('Bonus_type')},
                        {field: 'bonus_unittype', title: __('Bonus_unittype'), operate: 'LIKE'},
                        {field: 'checkin_date', title: __('Checkin_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'checkout_date', title: __('Checkout_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'room_amount', title: __('Room_amount')},
                        {field: 'status_paid', title: __('Status_paid')},
                        {field: 'status_booking', title: __('Status_booking')},
                        {field: 'status_renounce', title: __('Status_renounce')},
                        {field: 'bonus_weekend', title: __('Bonus_weekend')},
                        {field: 'bonus_midweek', title: __('Bonus_midweek')},
                        {field: 'bonus_fullweek', title: __('Bonus_fullweek')},
                        {field: 'bonus_extranight', title: __('Bonus_extranight')},
                        {field: 'bonus_price', title: __('Bonus_price'), operate:'BETWEEN'},
                        {field: 'grand_total', title: __('Grand_total'), operate:'BETWEEN'},
                        {field: 'bonus_paid', title: __('Bonus_paid')},
                        {field: 'bonus_paid_amount', title: __('Bonus_paid_amount'), operate:'BETWEEN'},
                        {field: 'bonus_paid_date', title: __('Bonus_paid_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'bonus_used_date', title: __('Bonus_used_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'bonus_renounce_date', title: __('Bonus_renounce_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'bonus_booking_date', title: __('Bonus_booking_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'account_confirm', title: __('Account_confirm')},
                        {field: 'remark', title: __('Remark'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'createby', title: __('Createby'), operate: 'LIKE'},
                        {field: 'createdate', title: __('Createdate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'updateby', title: __('Updateby'), operate: 'LIKE'},
                        {field: 'updatedate', title: __('Updatedate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
