define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'orders.extra/index' + location.search,
                    add_url: 'orders.extra/add',
                    edit_url: 'orders.extra/edit',
                    del_url: 'orders.extra/del',
                    multi_url: 'orders.extra/multi',
                    import_url: 'orders.extra/import',
                    table: 'orders_extra',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'orders_extra_id',
                sortName: 'orders_extra_id',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'orders_extra_id', title: __('Orders_extra_id')},
                        {field: 'orders_id', title: __('Orders_id')},
                        {field: 'orders_code', title: __('Orders_code'), operate: 'LIKE'},
                        {field: 'resortid', title: __('Resortid')},
                        {field: 'paid_method_id', title: __('Paid_method_id')},
                        {field: 'status_paid', title: __('Status_paid')},
                        {field: 'status_booking', title: __('Status_booking')},
                        {field: 'status_renounce', title: __('Status_renounce')},
                        {field: 'extranight', title: __('Extranight')},
                        {field: 'extra_unittype', title: __('Extra_unittype'), operate: 'LIKE'},
                        {field: 'checkin_date', title: __('Checkin_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'checkout_date', title: __('Checkout_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'room_amount', title: __('Room_amount')},
                        {field: 'extra_price', title: __('Extra_price'), operate:'BETWEEN'},
                        {field: 'grand_total', title: __('Grand_total'), operate:'BETWEEN'},
                        {field: 'extra_paid', title: __('Extra_paid')},
                        {field: 'extra_paid_amount', title: __('Extra_paid_amount'), operate:'BETWEEN'},
                        {field: 'extra_paid_date', title: __('Extra_paid_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'extra_used_date', title: __('Extra_used_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'extra_renounce_date', title: __('Extra_renounce_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'extra_booking_date', title: __('Extra_booking_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'account_confirm', title: __('Account_confirm')},
                        {field: 'remark', title: __('Remark'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'createby', title: __('Createby'), operate: 'LIKE'},
                        {field: 'createdate', title: __('Createdate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'updateby', title: __('Updateby'), operate: 'LIKE'},
                        {field: 'updatedate', title: __('Updatedate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
