define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'orders.van/index' + location.search,
                    add_url: 'orders.van/add',
                    edit_url: 'orders.van/edit',
                    del_url: 'orders.van/del',
                    multi_url: 'orders.van/multi',
                    import_url: 'orders.van/import',
                    table: 'orders_van',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'orders_van_id',
                sortName: 'orders_van_id',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'orders_van_id', title: __('Orders_van_id')},
                        {field: 'orders_id', title: __('Orders_id')},
                        {field: 'orders_code', title: __('Orders_code'), operate: 'LIKE'},
                        {field: 'resortid', title: __('Resortid')},
                        {field: 'paid_method_id', title: __('Paid_method_id')},
                        {field: 'status_paid', title: __('Status_paid')},
                        {field: 'status_booking', title: __('Status_booking')},
                        {field: 'status_renounce', title: __('Status_renounce')},
                        {field: 'from_contract', title: __('From_contract'), operate: 'LIKE'},
                        {field: 'from_year', title: __('From_year')},
                        {field: 'from_unittype', title: __('From_unittype'), operate: 'LIKE'},
                        {field: 'from_weekend', title: __('From_weekend')},
                        {field: 'from_midweek', title: __('From_midweek')},
                        {field: 'from_fullweek', title: __('From_fullweek')},
                        {field: 'to_unittype', title: __('To_unittype')},
                        {field: 'room_amount', title: __('Room_amount')},
                        {field: 'to_weekend', title: __('To_weekend')},
                        {field: 'to_midweek', title: __('To_midweek')},
                        {field: 'to_fullweek', title: __('To_fullweek')},
                        {field: 'checkin_date', title: __('Checkin_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'checkout_date', title: __('Checkout_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'van_fee', title: __('Van_fee'), operate:'BETWEEN'},
                        {field: 'grand_total', title: __('Grand_total'), operate:'BETWEEN'},
                        {field: 'van_paid', title: __('Van_paid')},
                        {field: 'van_paid_amount', title: __('Van_paid_amount'), operate:'BETWEEN'},
                        {field: 'van_paid_date', title: __('Van_paid_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'van_used_date', title: __('Van_used_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'van_renounce_date', title: __('Van_renounce_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'van_booking_date', title: __('Van_booking_date'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'account_confirm', title: __('Account_confirm')},
                        {field: 'createby', title: __('Createby'), operate: 'LIKE'},
                        {field: 'createdate', title: __('Createdate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'updateby', title: __('Updateby'), operate: 'LIKE'},
                        {field: 'updatedate', title: __('Updatedate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'remark', title: __('Remark'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
