define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'package/index' + location.search,
                    add_url: 'package/add',
                    edit_url: 'package/edit',
                    del_url: 'package/del',
                    multi_url: 'package/multi',
                    import_url: 'package/import',
                    hidden_url: 'package/hidden',
                    unhidden_url: 'package/unhidden',
                    edit_member_type_price_url: 'package/unhidden',
                    table: 'package',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'packageid',
                sortName: 'packageid',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'packageid', title: __('Membership Type ID')},
                        {field: 'packagename', title: __('Membership Type Name'), operate: 'LIKE'},
                        {field: 'partnerid',
                            title: __('Club Name'),
                            formatter: function (value, row) {
                                return row.partner.login_name || '';
                            },
                            addclass: 'selectpage',
                            extend: 'data-source="partner/index" data-field="login_name" data-primary-key="partnerid"'
                        },
                        {field: 'maxocc', title: __('Max Occupancy'), operate: false},
                        {
                            field: 'unittype',
                            title: __('Unit Type'),
                            addclass: 'selectpage',
                            extend: 'data-source=\'[{"id":"T0","name":"T0"},{"id":"T1","name":"T1"},{"id":"T2","name":"T2"},{"id":"T4","name":"T4"},{"id":"T9","name":"T9"},{"id":"T0V","name":"T0V"},{"id":"T1V","name":"T1V"},{"id":"T2v","name":"T2v"},{"id":"T2L","name":"T2L"},{"id":"T1PPV","name":"T1PPV"},{"id":"T2PPV","name":"T2PPV"},{"id":"ELSE","name":"ELSE"},{"id":"Any","name":"Any"}]\''
                        },
                        {field: 'weeks', title: __('Weeks/Year')},
                        {
                            field: 'distribution_number',
                            title: __('Distribution Number'),
                            operate: false,
                            formatter: function (value, row) {
                                return value || 0;
                            },
                        },
                        {field: 'cno_num_weeks', title: __('Cno Num Weeks'), operate: false},
                        {
                            field: 'description',
                            title: __('Description'),
                            operate: false,
                            table: table,
                            class: 'autocontent',
                            formatter: function (value, row) {
                                return value || '-';
                            },
                        },
                        {
                            field: 'remark',
                            title: __('Remark'),
                            operate: false,
                            formatter: function (value, row) {
                                return value || '-';
                            },
                        },
                        {
                            field: 'hidden',
                            title: __('Hidden'),
                            defaultValue: "0",
                            visible: false,
                            formatter: Table.api.formatter.status,
                            custom: {"0": "green", "1": "black"},
                            searchList: {0: __('No'), 1: __('Yes')}
                        },
                        {
                            field: 'operate',
                            title: __('Operate'),
                            table: table,
                            events: Table.api.events.operate,
                            formatter: Table.api.formatter.operate,
                            buttons: [
                                {
                                    name: 'edit_member_type_price',
                                    text: __('Membership Type Price'),
                                    title: __('Membership Type Price'),
                                    classname: 'btn btn-xs btn-info btn-addtabs',
                                    icon: '',
                                    url: 'packageprice/index?packageid={packageid}'
                                }
                            ],
                        }
                    ]
                ]
            });


            $(document).on("click", ".btn-hidden", function () {
                let ids = Table.api.selectedids(table);
                Fast.api.ajax({
                    url: 'package/hidden',
                    data: {
                        ids
                    }
                }, function (data, ret) {
                    table.bootstrapTable('refresh');
                }, function (data, ret) {
                    Layer.msg(__('Operation failed'));
                });
            });

            $(document).on("click", ".btn-unhidden", function () {
                let ids = Table.api.selectedids(table);
                Fast.api.ajax({
                    url: 'package/unhidden',
                    data: {
                        ids
                    }
                }, function (data, ret) {
                    table.bootstrapTable('refresh');
                }, function (data, ret) {
                    Layer.msg(__('Operation failed'));
                });
            });


            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        hidden: function () {
            Controller.api.bindevent();
        },
        unhidden: function () {
            Controller.api.bindevent();
        },
        edit_member_type_price: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
