define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            let window_search = window.location.search;
            const searchParams = new URLSearchParams(window_search.replaceAll('?addtabs=1', ''));
            let packageid = searchParams.get('packageid');
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'packageprice/index' + location.search,
                    add_url: 'packageprice/add?packageid='+packageid,
                    edit_url: 'packageprice/edit?packageid='+packageid,
                    del_url: 'packageprice/del',
                    multi_url: 'packageprice/multi',
                    import_url: 'packageprice/import',
                    table: 'packageprice',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'packagepriceid',
                sortName: 'packagepriceid',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'packagepriceid', title: __('Membership Type Price No')},
                        {
                            field: 'packageid',
                            title: __('Package id'),
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source="package/index" data-field="packagename" data-primary-key="packageid"'
                        },
                        {field: 'packageprice_years', title: __('Entitlement Year')},
                        {field: 'packageprice_prices', title: __('Price'), operate:'BETWEEN'},
                        {field: 'packageprice_amount1', title: __('Amount Year(s) to Pay (1)')},
                        {field: 'packageprice_prices1', title: __('Total Prices (1)'), operate:'BETWEEN'},
                        {field: 'packageprice_amount2', title: __('Amount Year(s) to Pay (2)')},
                        {field: 'packageprice_prices2', title: __('Total Prices (2)'), operate:'BETWEEN'},
                        {field: 'packageprice_amount3', title: __('Amount Year(s) to Pay (3)')},
                        {field: 'packageprice_prices3', title: __('Total Prices (3)'), operate:'BETWEEN'},
                        {field: 'packageprice_amount4', title: __('Amount Year(s) to Pay (4)')},
                        {field: 'packageprice_prices4', title: __('Total Prices (4)'), operate:'BETWEEN'},
                        {field: 'packageprice_amount5', title: __('Amount Year(s) to Pay (5)')},
                        {field: 'packageprice_prices5', title: __('Total Prices (5)'), operate:'BETWEEN'},
                        {field: 'packageprice_remark', title: __('Remark'), operate: 'LIKE'},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
