define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'packageprice.bck/index' + location.search,
                    add_url: 'packageprice.bck/add',
                    edit_url: 'packageprice.bck/edit',
                    del_url: 'packageprice.bck/del',
                    multi_url: 'packageprice.bck/multi',
                    import_url: 'packageprice.bck/import',
                    table: 'packageprice_bck',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'packagepriceid',
                sortName: 'packagepriceid',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'packagepriceid', title: __('Packagepriceid')},
                        {field: 'packageid', title: __('Packageid')},
                        {field: 'packageprice_years', title: __('Packageprice_years')},
                        {field: 'packageprice_prices', title: __('Packageprice_prices'), operate:'BETWEEN'},
                        {field: 'packageprice_amount1', title: __('Packageprice_amount1')},
                        {field: 'packageprice_prices1', title: __('Packageprice_prices1'), operate:'BETWEEN'},
                        {field: 'packageprice_amount2', title: __('Packageprice_amount2')},
                        {field: 'packageprice_prices2', title: __('Packageprice_prices2'), operate:'BETWEEN'},
                        {field: 'packageprice_amount3', title: __('Packageprice_amount3')},
                        {field: 'packageprice_prices3', title: __('Packageprice_prices3'), operate:'BETWEEN'},
                        {field: 'packageprice_amount4', title: __('Packageprice_amount4')},
                        {field: 'packageprice_prices4', title: __('Packageprice_prices4'), operate:'BETWEEN'},
                        {field: 'packageprice_amount5', title: __('Packageprice_amount5')},
                        {field: 'packageprice_prices5', title: __('Packageprice_prices5'), operate:'BETWEEN'},
                        {field: 'packageprice_createby', title: __('Packageprice_createby'), operate: 'LIKE'},
                        {field: 'packageprice_createdate', title: __('Packageprice_createdate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'packageprice_updateby', title: __('Packageprice_updateby'), operate: 'LIKE'},
                        {field: 'packageprice_updatedate', title: __('Packageprice_updatedate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'packageprice_used', title: __('Packageprice_used')},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
