define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'paid/method/index' + location.search,
                    add_url: 'paid/method/add',
                    edit_url: 'paid/method/edit',
                    del_url: 'paid/method/del',
                    multi_url: 'paid/method/multi',
                    import_url: 'paid/method/import',
                    table: 'paid_method',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'paid_method_id',
                sortName: 'paid_method_id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'paid_method_id', title: __('Paid_method_id')},
                        {field: 'paid_method_name', title: __('Paid_method_name'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
