define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'partner/index' + location.search,
                    add_url: 'partner/add',
                    edit_url: 'partner/edit',
                    del_url: 'partner/del',
                    multi_url: 'partner/multi',
                    import_url: 'partner/import',
                    hidden_url: 'partner/hidden',
                    unhidden_url: 'partner/unhidden',
                    table: 'partner',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'partnerid',
                sortName: 'partnerid',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'partnerid', title: __('Id')},
                        {field: 'login_name', title: __('Club Name'), operate: 'LIKE'},
                        // {field: 'username', title: __('Username'), operate: 'LIKE'},
                        // {field: 'passwords', title: __('Passwords'), operate: 'LIKE'},
                        {field: 'address', title: __('Address'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'province', title: __('Province'), operate: 'LIKE'},
                        {field: 'postalcode', title: __('Postalcode'), operate: 'LIKE'},
                        {
                            field: 'country.countryid',
                            formatter: function (value, row) {
                                return row.country.country_name || '-';
                            },
                            title: __('Country'),
                            addclass: 'selectpage',
                            extend: 'data-source="country/index" data-field="country_name" data-primary-key="countryid"'
                        },
                        {field: 'phone', title: __('Tel No.'), operate: 'LIKE'},
                        {field: 'fax', title: __('Fax'), operate: 'LIKE'},
                        {field: 'email', title: __('E-mail'), operate: 'LIKE'},
                        {field: 'remark', title: __('Remark'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {
                            field: 'hidden',
                            title: __('Hidden'),
                            visible: false,
                            defaultValue: "0",
                            formatter: Table.api.formatter.status,
                            custom: {"0": "green", "1": "black"},
                            searchList: {0: __('No'), 1: __('Yes')}
                        },
                        // {field: 'hcs', title: __('Hcs')},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            $(document).on("click", ".btn-hidden", function () {
                let ids = Table.api.selectedids(table);
                Fast.api.ajax({
                    url: 'partner/hidden',
                    data: {
                        ids
                    }
                }, function (data, ret) {
                    table.bootstrapTable('refresh');
                }, function (data, ret) {
                    Layer.msg(__('Operation failed'));
                });
            });

            $(document).on("click", ".btn-unhidden", function () {
                let ids = Table.api.selectedids(table);
                Fast.api.ajax({
                    url: 'partner/unhidden',
                    data: {
                        ids
                    }
                }, function (data, ret) {
                    table.bootstrapTable('refresh');
                }, function (data, ret) {
                    Layer.msg(__('Operation failed'));
                });
            });
            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        hidden: function () {
            Controller.api.bindevent();
        },
        unhidden: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
