define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'payment/record/index' + location.search,
                    add_url: 'payment/record/add',
                    edit_url: 'payment/record/edit',
                    del_url: 'payment/record/del',
                    multi_url: 'payment/record/multi',
                    import_url: 'payment/record/import',
                    table: 'payment_record',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'payment_id',
                sortName: 'payment_id',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'payment_id', title: __('Payment_id')},
                        {field: 'ms_detail_id', title: __('Ms_detail_id')},
                        {field: 'memberid', title: __('Memberid')},
                        {field: 'member_name', title: __('Member_name'), operate: 'LIKE'},
                        {field: 'member_surname', title: __('Member_surname'), operate: 'LIKE'},
                        {field: 'hierarchyid', title: __('Hierarchyid')},
                        {field: 'packageid', title: __('Packageid')},
                        {field: 'partnerid', title: __('Partnerid')},
                        {field: 'ms_detail_year', title: __('Ms_detail_year')},
                        {field: 'contract_no', title: __('Contract_no'), operate: 'LIKE'},
                        {field: 'servicetype', title: __('Servicetype'), operate: 'LIKE'},
                        {field: 'season_type', title: __('Season_type'), operate: 'LIKE'},
                        {field: 'FYO', title: __('Fyo')},
                        {field: 'LYO', title: __('Lyo')},
                        {field: 'packagename', title: __('Packagename'), operate: 'LIKE'},
                        {field: 'unittype', title: __('Unittype'), operate: 'LIKE'},
                        {field: 'weeks', title: __('Weeks')},
                        {field: 'packagepriceid', title: __('Packagepriceid')},
                        {field: 'packageprice_years', title: __('Packageprice_years')},
                        {field: 'packageprice_prices', title: __('Packageprice_prices'), operate:'BETWEEN'},
                        {field: 'special_prices', title: __('Special_prices'), operate:'BETWEEN'},
                        {field: 'paid_amount', title: __('Paid_amount'), operate:'BETWEEN'},
                        {field: 'paid_method', title: __('Paid_method')},
                        {field: 'paid_type', title: __('Paid_type'), operate: 'LIKE'},
                        {field: 'invoice_bank', title: __('Invoice_bank'), operate: 'LIKE'},
                        {field: 'paid_status', title: __('Paid_status')},
                        {field: 'created_on', title: __('Created_on'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
