define(['jquery', 'bootstrap', 'backend', 'table', 'form', 'bootstrap-select', 'bootstrap-datetimepicker'], function ($, undefined, Backend, Table, Form, Bselect, Bdate) {
    const searchParams = new URLSearchParams(window.location.search.replaceAll('?addtabs=1', ''));
    let member_type = searchParams.get('member_type');
    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'print_invoices/index' + location.search,
                    gen_invoice_url: 'print_invoices/hidden',
                    renounce_url: 'print_invoices/unhidden',
                    prinfpdf_url: 'print_invoices/prinfpdf',
                    table: 'member',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'ms_detail_id',
                sortName: 'ms_detail_id',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'memberid', title: __('No.')},
                        {
                            field: 'username',
                            title: __('Member name'),
                            operate: false,
                            formatter: function (value, row) {
                                return row.member.title + row.member.login_name + ' ' + row.member.login_surname;
                            },
                        },
                        {
                            field: 'hierarchy.contract_no',
                            title: __('Contract No.'),
                            operate: 'LIKE'
                        },
                        {
                            field: 'packageid',
                            title: __('Unit type'),
                            formatter: function (value, row) {
                                return (row.unittype || '') + '/' + row.ms_detail_id;
                            },
                            addclass: 'selectpage',
                            extend: 'data-source=\'[{"id":"T0","name":"T0"},{"id":"T1","name":"T1"},{"id":"T2","name":"T2"},{"id":"T4","name":"T4"},{"id":"T9","name":"T9"},{"id":"T0V","name":"T0V"},{"id":"T1V","name":"T1V"},{"id":"T2v","name":"T2v"},{"id":"T2L","name":"T2L"},{"id":"T1PPV","name":"T1PPV"},{"id":"T2PPV","name":"T2PPV"},{"id":"ELSE","name":"ELSE"},{"id":"Any","name":"Any"}]\''
                        },
                        {
                            field: 'special_amount',
                            title: __('Debit USD'),
                            operate: false,
                            formatter: function (value, row) {
                                return row.special_amount > 0?row.special_amount:row.packageprice_prices;
                            }
                        },
                        {
                            field: 'partnerid',
                            title: __('Club Name'),
                            formatter: function (value, row) {
                                return row.partner.login_name || '';
                            },
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source="partner/index" data-field="login_name" data-primary-key="partnerid"'
                        },
                        {
                            field: 'hierarchy.servicetype',
                            title: __('Service Type'),
                            formatter: function (value, row) {
                                return row.hierarchy.servicetype || '';
                            },
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source=\'[{"id":"Full","name":"Full"},{"id":"Odd","name":"Odd"},{"id":"Even","name":"Even"},{"id":"Else","name":"Else"}]\''
                        },
                        {
                            field: 'hierarchy.season_type',
                            title: __('Season Type'),
                            formatter: function (value, row) {
                                return row.hierarchy.season_type || '';
                            },
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source=\'[{"id":"Red","name":"Red"},{"id":"White","name":"White"},{"id":"Blue","name":"Blue"},{"id":"Green","name":"Green"},{"id":"Yellow","name":"Yellow"}]\''
                        },
                        {
                            field: 'country.countryid',
                            formatter: function (value, row) {
                                return row.country_name || '';
                            },
                            visible: false,
                            title: __('Country'),
                            addclass: 'selectpage',
                            extend: 'data-source="country/index" data-field="country_name" data-primary-key="countryid"'
                        },
                        {
                            field: 'ms_detail_year',
                            visible: false,
                            title: __('Year')
                        },
                    ]
                ]
            });

            Form.events.datetimepicker($("#prinfpdf-form"));
            // 为表格绑定事件
            Table.api.bindevent(table);

            $(document).on("click", ".btn-gen_invoice", function () {
                let ids = Table.api.selectedids(table);
                let deadline = $('#deadline').val();
                Fast.api.ajax({
                    url: 'print_invoices/gen_invoice',
                    data: {
                        ids,
                        deadline
                    }
                }, function (data, ret) {
                    table.bootstrapTable('refresh');
                }, function (data, ret) {
                    Layer.msg(__('Operation failed'));
                });
            });

            $(document).on("click", ".btn-renounce", function () {
                let ids = Table.api.selectedids(table);
                Fast.api.ajax({
                    url: 'print_invoices/renounce',
                    data: {
                        ids
                    }
                }, function (data, ret) {
                    table.bootstrapTable('refresh');
                }, function (data, ret) {
                    Layer.msg(__('Operation failed'));
                });
            });

            $(document).on("click", ".btn-prinfpdf", function () {
                let no1 = $('#no1').val();
                let no2 = $('#no2').val();
                let ptime = $('#ptime').val();
                let lastremind = $('#lastremind').prop("checked") ? 'Y':'';
                let deadline = $('#deadline').val();
                let chkImmediately = $('#chkImmediately').prop("checked") ? '1':'';
                let checkyear = $('#ms_detail_year').val();
                let checkservicetype = $('#hierarchy\\.servicetype').val();
                let cnum = $('#hierarchy\\.contract_no').val();
                let checkclub = $('#partnerid').val();
                let f_type = $('#f_type').val();
                let language = $("input[name='language']:checked").val();
                let chi_sam = '';
                let chi_trad = '';
                let tha = '';
                switch (language){
                    case 'chi_sam':
                        chi_sam = 1;
                        break;
                    case 'chi_trad':
                        chi_trad = 1;
                        break;
                    case 'tha':
                        tha = 1;
                        break;
                }
                if ( !no1) {
                    Layer.msg(__('Please input No. form'));
                    return false;
                }
                if ( !no2) {
                    Layer.msg(__('Please input No. to'));
                    return false;
                }
                if (parseInt(no2) < parseInt(no1)){
                    Layer.msg(__('(No. to) cannot lower than (No. from)'));
                    return false;
                }
                let url_param = 'no1='+no1+'&no2='+no2+'&no2_val='+no2+'&ptime='+ptime+'&lastremind='+lastremind+'&deadline='+deadline+'&chkImmediately='+chkImmediately+'&checkyear='+checkyear+'&checkservicetype='+checkservicetype+'&cnum='+cnum+'&cnum_val='+cnum+'&checkclub='+checkclub+'&chi_sam='+chi_sam+'&chi_trad='+chi_trad+'&tha='+tha+'&year_val='+checkyear;
                let url;
                if (f_type == 'hcs_form'){
                     url = Config.moduleurl + '/service_center/print_invoice?' + url_param;
                } else {
                    url = Config.moduleurl + '/service_center/formprint?' + url_param;
                }
                window.open(url, "_blank");
            });
        },
        hidden: function () {
            Controller.api.bindevent();
        },
        unhidden: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
