define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'resort/index' + location.search,
                    add_url: 'resort/add',
                    edit_url: 'resort/edit',
                    del_url: 'resort/del',
                    multi_url: 'resort/multi',
                    import_url: 'resort/import',
                    hidden_url: 'resort/hidden',
                    unhidden_url: 'resort/unhidden',
                    table: 'resort',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'resortid',
                sortName: 'resortid',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'resortid', title: __('Id')},
                        {field: 'resortcode', title: __('Resort Code'), operate: 'LIKE'},
                        {field: 'resortname', title: __('Resort Name'), operate: 'LIKE'},
                        {field: 'resortaddress', title: __('Address'), operate: 'LIKE'},
                        {field: 'resortprovince', title: __('Province'), operate: 'LIKE'},
                        {field: 'resortpostcode', title: __('Postalcode'), operate: 'LIKE'},
                        {
                            field: 'country.countryid',
                            formatter: function (value, row) {
                                return row.country.country_name || '-';
                            },
                            title: __('Country'),
                            addclass: 'selectpage',
                            extend: 'data-source="country/index" data-field="country_name" data-primary-key="countryid"'
                        },
                        {field: 'resortphone', title: __('Tel No.'), operate: 'LIKE'},
                        {field: 'resortfax', title: __('Fax'), operate: 'LIKE'},
                        {field: 'resortemail', title: __('E-mail'), operate: 'LIKE'},
                        {field: 'remark', title: __('Remark'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {
                            field: 'hidden',
                            title: __('Hidden'),
                            visible: false,
                            defaultValue: "0",
                            formatter: Table.api.formatter.status,
                            custom: {"0": "green", "1": "black"},
                            searchList: {0: __('No'), 1: __('Yes')}
                        },
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });
            $(document).on("click", ".btn-hidden", function () {
                let ids = Table.api.selectedids(table);
                Fast.api.ajax({
                    url: 'resort/hidden',
                    data: {
                        ids
                    }
                }, function (data, ret) {
                    table.bootstrapTable('refresh');
                }, function (data, ret) {
                    Layer.msg(__('Operation failed'));
                });
            });

            $(document).on("click", ".btn-unhidden", function () {
                let ids = Table.api.selectedids(table);
                Fast.api.ajax({
                    url: 'resort/unhidden',
                    data: {
                        ids
                    }
                }, function (data, ret) {
                    table.bootstrapTable('refresh');
                }, function (data, ret) {
                    Layer.msg(__('Operation failed'));
                });
            });
            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        hidden: function () {
            Controller.api.bindevent();
        },
        unhidden: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
