define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'send2bank/index' + location.search,
                    add_url: 'send2bank/add',
                    edit_url: 'send2bank/edit',
                    del_url: 'send2bank/del',
                    multi_url: 'send2bank/multi',
                    import_url: 'send2bank/import',
                    table: 'send2bank',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'send_id',
                sortName: 'send_id',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'send_id', title: __('Send_id')},
                        {field: 'merchant_id', title: __('Merchant_id'), operate: 'LIKE'},
                        {field: 'payment_method', title: __('Payment_method'), operate: 'LIKE'},
                        {field: 'charge_id', title: __('Charge_id'), operate: 'LIKE'},
                        {field: 'send_date', title: __('Send_date'), operate: 'LIKE'},
                        {field: 'send_invoice', title: __('Send_invoice'), operate: 'LIKE'},
                        {field: 'send_amount', title: __('Send_amount'), operate: 'LIKE'},
                        {field: 'currency', title: __('Currency'), operate: 'LIKE'},
                        {field: 'request_time', title: __('Request_time'), operate:'RANGE', addclass:'datetimerange', autocomplete:false, formatter: Table.api.formatter.datetime},
                        {field: 'request_last', title: __('Request_last'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'responce_time', title: __('Responce_time'), operate:'RANGE', addclass:'datetimerange', autocomplete:false, formatter: Table.api.formatter.datetime},
                        {field: 'responce_last', title: __('Responce_last'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'created_by', title: __('Created_by'), operate: 'LIKE'},
                        {field: 'created_on', title: __('Created_on'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
