define(['jquery', 'bootstrap', 'backend', 'table', 'form', 'bootstrap-select', 'bootstrap-datetimepicker'], function ($, undefined, Backend, Table, Form, Bselect, Bdate) {
    const searchParams = new URLSearchParams(window.location.search.replaceAll('?addtabs=1', ''));
    let member_type = searchParams.get('member_type');
    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'service_center/index' + location.search,
                    multi_url: 'service_center/multi',
                    view_invoice_url: 'service_center/view_invoice',
                    view_unpaid_url: 'service_center/view_unpaid',
                    view_paid_url: 'service_center/view_paid',
                    view_all_order_url: 'service_center/view_all_order',
                    view_new_order_url: 'service_center/view_new_order',
                    view_all_booking_url: 'service_center/view_all_booking',
                    view_new_booking_url: 'service_center/view_new_booking',
                    view_un_used_url: 'service_center/view_un_used',
                    view_used_url: 'service_center/view_used',
                    import_url: 'service_center/import',
                    table: 'member',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'memberid',
                sortName: member_type == 'M' ? 'invoice_bank.bank_invoice_no' : 'memberid',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        // {checkbox: true},
                        // {field: 'memberid', title: __('ID')},
                        // {field: 'username', title: __('Login_name'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {
                            field: 'hierarchy.membercode',
                            title: __('RCI No'),
                            formatter: function (value, row) {
                                if (!value || value == '-') {
                                    return '';
                                }
                                return value;
                            }
                        },
                        {
                            field: 'hierarchy.contract_no',
                            title: __('Contract No'),
                            formatter: function (value, row) {
                                if (!value || value == '-') {
                                    return '';
                                }
                                return value;
                            }
                        },
                        // {
                        //     field: 'login_surname',
                        //     title: __('Login Name'),
                        //     operate: 'LIKE',
                        //     table: table,
                        //     class: 'autocontent',
                        //     formatter: Table.api.formatter.content
                        // },
                        {
                            field: 'username',
                            title: __('1st Full Name'),
                            operate: false,
                            formatter: function (value, row) {
                                return row.title + row.login_name + ' ' + row.login_surname;
                            },
                        },
                        // {field: 'username', title: __('Username'), operate: 'LIKE'},
                        // {field: 'passwords', title: __('Passwords'), operate: 'LIKE'},
                        // {field: 'title', title: __('Title'), operate: 'LIKE'},
                        {
                            field: 'birthday',
                            title: __('Birth Day # 1'),
                            operate: 'RANGE',
                            visible: member_type == 'M',
                            addclass: 'datetimerange',
                            formatter: function (value, row) {
                                if (!value || value == '0000-00-00') {
                                    return '-';
                                }
                                let tmp = value.split('-');
                                tmp = tmp.reverse();
                                return tmp.join('/');
                            },
                            autocomplete: false
                        },
                        // {
                        //     field: 'fullname2',
                        //     title: __('Full Name # 2'),
                        //     visible: member_type == 'M',
                        //     operate: 'LIKE'
                        // },
                        {
                            field: 'fullname2',
                            title: __('2nd Full Name'),
                            operate: false,
                            formatter: function (value, row) {
                                return row.title2 + row.fullname2 + ' ' + row.fullsurname2;
                            },
                        },
                        {
                            field: 'birthday2',
                            title: __('Birth Day # 2'),
                            operate: 'RANGE',
                            visible: member_type == 'M',
                            addclass: 'datetimerange',
                            formatter: function (value, row) {
                                if (!value || value == '0000-00-00') {
                                    return '-';
                                }
                                let tmp = value.split('-');
                                tmp = tmp.reverse();
                                return tmp.join('/');
                            },
                            autocomplete: false
                        },
                        {
                            field: 'marketer.marketerid',
                            title: __('Marketer'),
                            visible: member_type == 'M',
                            formatter: function (value, row) {
                                let val = row.marketer.login_name || '';
                                if (!val || val == '-') {
                                    return '';
                                }
                                return val;
                            },
                            addclass: 'selectpage',
                            extend: 'data-source="marketer/index" data-field="login_name" data-primary-key="marketerid"'
                        },
                        {field: 'province', title: __('Province'), operate: 'LIKE'},
                        {field: 'postalcode', title: __('Postalcode'), operate: 'LIKE'},
                        {
                            field: 'country.countryid',
                            formatter: function (value, row) {
                                return row.country.country_name || '';
                            },
                            title: __('Country'),
                            addclass: 'selectpage',
                            extend: 'data-source="country/index" data-field="country_name" data-primary-key="countryid"'
                        },
                        {field: 'phone', title: __('Tel'), operate: 'LIKE'},
                        {field: 'office', title: __('Office'), operate: 'LIKE'},
                        {field: 'mobile', title: __('Mobile Phone'), operate: 'LIKE'},
                        {field: 'fax', title: __('Fax Phone'), operate: 'LIKE'},
                        {field: 'email', title: __('Email'), operate: 'LIKE'},
                        {
                            field: 'language.language_name',
                            title: __('Language'),
                            formatter: function (value, row) {
                                if (!value || value == '-') {
                                    return '';
                                }
                                return value;
                            }
                        },
                        // {
                        //     field: 'updatedate',
                        //     title: __('Last Updated On'),
                        //     operate: 'RANGE',
                        //     addclass: 'datetimerange',
                        //     autocomplete: false,
                        //     formatter: function (value, row) {
                        //         return row.updatedate_text || '-';
                        //     }
                        // },
                        // {
                        //     field: 'updateby',
                        //     title: __('Last Updated By'),
                        //     operate: 'LIKE',
                        //     formatter: function (value, row) {
                        //         return row.updateby_text || '';
                        //     }
                        // },
                        // {
                        //     field: 'remark',
                        //     title: __('Remark'),
                        //     operate: 'LIKE',
                        //     table: table,
                        //     class: 'autocontent',
                        //     formatter: Table.api.formatter.content
                        // },
                        {
                            field: 'hierarchy.partnerid',
                            title: __('Club Name'),
                            formatter: function (value, row) {
                                return row.clubname_text || '';
                            },
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source="partner/index" data-field="login_name" data-primary-key="partnerid"'
                        },
                        {
                            field: 'hierarchy.packageid',
                            title: __('Membership Type Name'),
                            formatter: function (value, row) {
                                return row.package_text || '';
                            },
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source="package/index" data-field="packagename" data-primary-key="packageid"'
                        },
                        {
                            field: 'package.unittype',
                            title: __('Unit Type'),
                            formatter: function (value, row) {
                                return row.package_unittype_text || '';
                            },
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source=\'[{"id":"T0","name":"T0"},{"id":"T1","name":"T1"},{"id":"T2","name":"T2"},{"id":"T4","name":"T4"},{"id":"T9","name":"T9"},{"id":"T0V","name":"T0V"},{"id":"T1V","name":"T1V"},{"id":"T2v","name":"T2v"},{"id":"T2L","name":"T2L"},{"id":"T1PPV","name":"T1PPV"},{"id":"T2PPV","name":"T2PPV"},{"id":"ELSE","name":"ELSE"},{"id":"Any","name":"Any"}]\''
                        },
                        {
                            field: 'hierarchy.servicetype',
                            title: __('Service Type'),
                            formatter: function (value, row) {
                                return row.servicetype_text || '';
                            },
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source=\'[{"id":"Full","name":"Full"},{"id":"Odd","name":"Odd"},{"id":"Even","name":"Even"},{"id":"Else","name":"Else"}]\''
                        },
                        {
                            field: 'hierarchy.season_type',
                            title: __('Season Type'),
                            formatter: function (value, row) {
                                return row.seasontype_text || '';
                            },
                            visible: false,
                            addclass: 'selectpage',
                            extend: 'data-source=\'[{"id":"Red","name":"Red"},{"id":"White","name":"White"},{"id":"Blue","name":"Blue"},{"id":"Green","name":"Green"},{"id":"Yellow","name":"Yellow"}]\''
                        },
                        {
                            field: 'hidden',
                            title: __('Hidden'),
                            defaultValue: "0",
                            visible: false,
                            formatter: Table.api.formatter.status,
                            custom: {"0": "green", "1": "black"},
                            searchList: {0: __('No'), 1: __('Yes')}
                        },
                        // {field: 'title2', title: __('Title2'), operate: 'LIKE'},
                        {
                            field: 'member_type',
                            // defaultValue: "M",
                            visible: false,
                            title: __('Member'),
                            formatter: Table.api.formatter.status,
                            custom: {"M": "green", "N": "black"},
                            searchList: {"M": __('Yes'), "N": __('No')}
                        },
                        // {field: 'createby', title: __('Createby'), operate: 'LIKE'},
                        // {
                        //     field: 'createdate',
                        //     title: __('Createdate'),
                        //     operate: 'RANGE',
                        //     addclass: 'datetimerange',
                        //     autocomplete: false
                        // },
                        // {field: 'updateby_member', title: __('Updateby_member')},
                        // {field: 'user_priv', title: __('User_priv'), operate: 'LIKE'},
                        // {field: 'deleted', title: __('Deleted')},
                        {
                            field: 'operate',
                            title: __('Operate'),
                            table: table,
                            events: Table.api.events.operate,
                            formatter: Table.api.formatter.operate,
                            buttons: [
                                {
                                    name: 'view_invoice',
                                    text: __('View invoice'),
                                    title: __('View invoice'),
                                    classname: 'btn btn-xs btn-info btn-addtabs',
                                    icon: '',
                                    url: 'service_center/view_invoice'
                                }
                            ]
                        }
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        view_all_order(){
            $(document).on("click", ".preview_order", function () {
                let ids = $(this).data('orders_id');
                Fast.api.open('orders/preview_order?ids=' + ids, __('Preview order'), {
                    callback: function (value) {
                        console.log(value)
                    }
                });
            });

            $(document).on("click", ".update-booking-remark", function () {
                let ids = $(this).data('booking_id');
                let remark = $(this).data('remark');
                let that = $(this);
                Layer.prompt({
                    title: __('Please enter remark'),
                    formType: 2,
                    btn: [__('OK'), __('Cancel')],
                    value: remark
                }, function (value, index, elem) {
                    Fast.api.ajax({
                        url: 'booking/edit?ids=' + ids,
                        data: {
                            'row[remark]': value
                        }
                    }, function (data, ret) {
                        if (ret.code == 1) {
                            that.data('remark', value);
                            that.text(value);
                        } else {
                            Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (value, index, elem) {
                    Layer.close(index);
                });
            });

            $(document).on("click", ".update-doc_no", function () {
                let ids = $(this).data('orders_id');
                let doc_no = $(this).data('doc_no');
                let that = $(this);
                Layer.prompt({
                    title: __('Please enter Document No.'),
                    btn: [__('OK'), __('Cancel')],
                    value: doc_no
                }, function (value, index, elem) {
                    Fast.api.ajax({
                        url: 'orders/edit?ids=' + ids,
                        data: {
                            'row[doc_no]': value
                        }
                    }, function (data, ret) {
                        if (ret.code == 1) {
                            that.data('doc_no', value);
                            that.text(value);
                        } else {
                            Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (value, index, elem) {
                    Layer.close(index);
                });
            });


            $(document).on("click", ".update-orders-remark", function () {
                let ids = $(this).data('orders_id');
                let remark = $(this).data('remark');
                let that = $(this);
                Layer.prompt({
                    title: __('Please enter remark'),
                    formType: 2,
                    btn: [__('OK'), __('Cancel')],
                    value: remark
                }, function (value, index, elem) {
                    Fast.api.ajax({
                        url: 'orders/edit?ids=' + ids,
                        data: {
                            'row[remark]': value
                        }
                    }, function (data, ret) {
                        if (ret.code == 1) {
                            that.data('remark', value);
                            that.text(value);
                        } else {
                            Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (value, index, elem) {
                    Layer.close(index);
                });
            });

            Controller.api.bindevent();
        },
        view_invoice: function () {
            $(document).on("click", ".preview_order", function () {
                let ids = $(this).data('orders_id');
                Fast.api.open('orders/preview_order?ids=' + ids, __('Preview order'), {
                    callback: function (value) {
                        console.log(value)
                    }
                });
            });

            $(document).on("click", ".update-booking-remark", function () {
                let ids = $(this).data('booking_id');
                let remark = $(this).data('remark');
                let that = $(this);
                Layer.prompt({
                    title: __('Please enter remark'),
                    formType: 2,
                    btn: [__('OK'), __('Cancel')],
                    value: remark
                }, function (value, index, elem) {
                    Fast.api.ajax({
                        url: 'booking/edit?ids=' + ids,
                        data: {
                            'row[remark]': value
                        }
                    }, function (data, ret) {
                        if (ret.code == 1) {
                            that.data('remark', value);
                            that.text(value);
                        } else {
                            Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (value, index, elem) {
                    Layer.close(index);
                });
            });

            $(document).on("click", ".update-doc_no", function () {
                let ids = $(this).data('orders_id');
                let doc_no = $(this).data('doc_no');
                let that = $(this);
                Layer.prompt({
                    title: __('Please enter Document No.'),
                    btn: [__('OK'), __('Cancel')],
                    value: doc_no
                }, function (value, index, elem) {
                    Fast.api.ajax({
                        url: 'orders/edit?ids=' + ids,
                        data: {
                            'row[doc_no]': value
                        }
                    }, function (data, ret) {
                        if (ret.code == 1) {
                            that.data('doc_no', value);
                            that.text(value);
                        } else {
                            Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (value, index, elem) {
                    Layer.close(index);
                });
            });


            $(document).on("click", ".update-orders-remark", function () {
                let ids = $(this).data('orders_id');
                let remark = $(this).data('remark');
                let that = $(this);
                Layer.prompt({
                    title: __('Please enter remark'),
                    formType: 2,
                    btn: [__('OK'), __('Cancel')],
                    value: remark
                }, function (value, index, elem) {
                    Fast.api.ajax({
                        url: 'orders/edit?ids=' + ids,
                        data: {
                            'row[remark]': value
                        }
                    }, function (data, ret) {
                        if (ret.code == 1) {
                            that.data('remark', value);
                            that.text(value);
                        } else {
                            Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (value, index, elem) {
                    Layer.close(index);
                });
            });

            Controller.api.bindevent();
        },
        view_unpaid() {
            Form.events.datetimepicker($("#unpaid-form"));
            $(document).on("click", ".paid_date", function () {
                $('.table-responsive').addClass('table-show');
            });
            $(document).on("blur", ".paid_date", function () {
                $('.table-responsive').removeClass('table-show');
            });

            $(document).on("click", ".btn-save", function () {
                $('#unpaid_action').val('save');
                Fast.api.ajax({
                    url: 'service_center/view_unpaid',
                    data: $('#unpaid-form').serialize()
                }, function (data, ret) {
                    if (ret.code == 1) {

                    } else {
                        Layer.msg(ret.msg || 'Error');
                    }
                }, function (data, ret) {
                    // Layer.msg(__('Error'));
                });
            });

            $(document).on("click", ".btn-payment", function () {
                $('#unpaid_action').val('payment');
                Fast.api.ajax({
                    url: 'service_center/view_unpaid',
                    data: $('#unpaid-form').serialize()
                }, function (data, ret) {
                    if (ret.code == 1) {
                        setTimeout(function () {
                            location.reload();
                        }, 2000);
                    } else {
                        // Layer.msg(ret.msg || 'Error');
                    }
                }, function (data, ret) {
                    // Layer.msg(__('Error'));
                });
            });

            $(document).on("click", ".update-doc_no", function () {
                let ids = $(this).data('orders_id');
                let doc_no = $(this).data('doc_no');
                let that = $(this);
                Layer.prompt({
                    title: __('Please enter Document No.'),
                    btn: [__('OK'), __('Cancel')],
                    value: doc_no
                }, function (value, index, elem) {
                    Fast.api.ajax({
                        url: 'orders/edit?ids=' + ids,
                        data: {
                            'row[doc_no]': value
                        }
                    }, function (data, ret) {
                        if (ret.code == 1) {
                            that.data('doc_no', value);
                            that.text(value);
                        } else {
                            Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (value, index, elem) {
                    Layer.close(index);
                });
            });


            $(document).on("click", ".update-orders-remark", function () {
                let ids = $(this).data('orders_id');
                let remark = $(this).data('remark');
                let that = $(this);
                Layer.prompt({
                    title: __('Please enter remark'),
                    formType: 2,
                    btn: [__('OK'), __('Cancel')],
                    value: remark
                }, function (value, index, elem) {
                    Fast.api.ajax({
                        url: 'orders/edit?ids=' + ids,
                        data: {
                            'row[remark]': value
                        }
                    }, function (data, ret) {
                        if (ret.code == 1) {
                            that.data('remark', value);
                            that.text(value);
                        } else {
                            Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (value, index, elem) {
                    Layer.close(index);
                });
            });


            $(document).on("click", ".send-email", function () {
                let ids = $(this).data('orders_id');
                let that = $(this);
                Layer.confirm(__('Send email?'), {
                    title: __('Tips'),
                    btn: [__('OK'), __('Cancel')],
                }, function (index) {
                    Fast.api.ajax({
                        url: 'service_center/send_email?ids=' + ids,
                        data: {}
                    }, function (data, ret) {
                        if (ret.code == 1) {

                        } else {
                            // Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        // Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (index) {
                    Layer.close(index);
                });
            });

            $(document).on("click", ".btn-send", function () {
                $('#unpaid_action').val('send');
                let obj = document.getElementsByName("orders_id");
                let checkList = [];
                for (let k in obj) {
                    if (obj[k].checked) {
                        checkList.push(obj[k].value);
                    }
                }
                let len = checkList.length;
                if (len == 1) {
                    Layer.prompt({
                        title: __("Please input seller's name : "),
                        btn: [__('OK'), __('Cancel')]
                    }, function (value, index, elem) {
                        let url = Config.moduleurl + '/service_center/orderform?orders_id=' + checkList[0] + '&attn_name=' + value;
                        window.open(url, "_blank");
                        Layer.close(index);
                    }, function (value, index, elem) {
                        Layer.close(index);
                    });
                } else {
                    Layer.msg(__('Please select only one order to view an order form!!!'));
                }
            });

            $(document).on("click", ".btn-duplicate", function () {
                $('#unpaid_action').val('duplicate');
                let obj = document.getElementsByName("orders_id");
                let checkList = [];
                for (let k in obj) {
                    if (obj[k].checked) {
                        checkList.push(obj[k].value);
                    }
                }
                let len = checkList.length;
                if (len == 1) {
                    Layer.confirm(__('Duplicate order?'), {
                        title: __('Tips'),
                        btn: [__('OK'), __('Cancel')],
                    }, function (index) {
                        Fast.api.ajax({
                            url: 'service_center/view_unpaid',
                            data: {
                                orders_id: checkList[0],
                                unpaid_action: 'duplicate'
                            }
                        }, function (data, ret) {
                            if (ret.code == 1) {
                                setTimeout(function () {
                                    location.reload();
                                }, 2000);
                            } else {
                                // Layer.msg(ret.msg || 'Error');
                            }
                        }, function (data, ret) {
                            // Layer.msg(__('Error'));
                        });
                        Layer.close(index);
                    }, function (index) {
                        Layer.close(index);
                    });
                } else {
                    Layer.msg(__('Please select only one order to duplicate !!!'));
                }
            });

            $(document).on("click", ".btn-delete", function () {
                $('#unpaid_action').val('delete');
                let obj = document.getElementsByName("orders_id");
                let checkList = [];
                for (let k in obj) {
                    if (obj[k].checked) {
                        checkList.push(obj[k].value);
                    }
                }
                let len = checkList.length;
                if (len >= 1) {
                    Layer.confirm(__("Are you sure to delete?<br>This action will delete the target record(s) forever!!!"), {
                        title: __('Tips'),
                        btn: [__('OK'), __('Cancel')],
                    }, function (index) {
                        Fast.api.ajax({
                            url: 'service_center/view_unpaid',
                            data: {
                                orders_ids: checkList.join(','),
                                unpaid_action: 'delete'
                            }
                        }, function (data, ret) {
                            if (ret.code == 1) {
                                setTimeout(function () {
                                    location.reload();
                                }, 2000);
                            } else {
                                // Layer.msg(ret.msg || 'Error');
                            }
                        }, function (data, ret) {
                            // Layer.msg(__('Error'));
                        });
                        Layer.close(index);
                    }, function (index) {
                        Layer.close(index);
                    });
                } else {
                    Layer.msg(__('Please choose one or more records!!!'));
                }
            });


            $(document).on("click", ".btn-cancel", function () {
                $('#unpaid_action').val('cancel');
                let obj = document.getElementsByName("orders_id");
                let checkList = [];
                for (let k in obj) {
                    if (obj[k].checked) {
                        checkList.push(obj[k].value);
                    }
                }
                let len = checkList.length;
                if (len >= 1) {
                    Layer.confirm(__('Are you sure to cancel?'), {
                        title: __('Tips'),
                        btn: [__('OK'), __('Cancel')],
                    }, function (index) {
                        Fast.api.ajax({
                            url: 'service_center/view_unpaid',
                            data: {
                                orders_ids: checkList.join(','),
                                unpaid_action: 'cancel'
                            }
                        }, function (data, ret) {
                            if (ret.code == 1) {
                                setTimeout(function () {
                                    location.reload();
                                }, 2000);
                            } else {
                                // Layer.msg(ret.msg || 'Error');
                            }
                        }, function (data, ret) {
                            // Layer.msg(__('Error'));
                        });
                        Layer.close(index);
                    }, function (index) {
                        Layer.close(index);
                    });
                } else {
                    Layer.msg(__('Please choose one or more records!!!'));
                }
            });

            $(document).on("click", ".preview_order", function () {
                let ids = $(this).data('orders_id');
                Fast.api.open('orders/preview_order?ids=' + ids, __('Preview order'), {
                    callback: function (value) {
                        console.log(value)
                    }
                });
            });

            $(document).on("click", ".btn-edit", function () {
                $('#unpaid_action').val('edit');
                let obj = document.getElementsByName("orders_id");
                let checkList = [];
                for (let k in obj) {
                    if (obj[k].checked) {
                        checkList.push(obj[k].value);
                    }
                }
                let len = checkList.length;
                if (len == 1) {
                    let is_reload = true;
                    Fast.api.open('orders/edit?ids=' + checkList[0], __('Edit order'), {
                        cancel:function (){
                            is_reload = false;
                        },
                        end: function () {
                            if (is_reload){
                                setTimeout(function (){
                                    location.reload();
                                },1500);
                            }
                        }
                    });
                } else {
                    Layer.msg(__('Please choose a prefered record !!!'));
                }
            });

            Controller.api.bindevent();
        },
        view_paid() {
            $(document).on("click", ".btn-save", function () {
                $('#paid_action').val('save');
                Fast.api.ajax({
                    url: 'service_center/view_paid',
                    data: $('#paid-form').serialize()
                }, function (data, ret) {
                    if (ret.code == 1) {
                        setTimeout(function (){
                            location.reload();
                        },1500);
                    } else {
                        Layer.msg(ret.msg || 'Error');
                    }
                }, function (data, ret) {
                    // Layer.msg(__('Error'));
                });
            });
            $(document).on("click", ".btn-renounce", function () {
                $('#paid_action').val('renounce');
                Fast.api.ajax({
                    url: 'service_center/view_paid',
                    data: $('#paid-form').serialize()
                }, function (data, ret) {
                    if (ret.code == 1) {
                        setTimeout(function (){
                            location.reload();
                        },1500);
                    } else {
                        Layer.msg(ret.msg || 'Error');
                    }
                }, function (data, ret) {
                    // Layer.msg(__('Error'));
                });
            });

            $(document).on("click", ".preview_order", function () {
                let ids = $(this).data('orders_id');
                Fast.api.open('orders/preview_order?ids=' + ids, __('Preview order'), {
                    callback: function (value) {
                        console.log(value)
                    }
                });
            });

            $(document).on("click", ".update-doc_no", function () {
                let ids = $(this).data('orders_id');
                let doc_no = $(this).data('doc_no');
                let that = $(this);
                Layer.prompt({
                    title: __('Please enter Document No.'),
                    btn: [__('OK'), __('Cancel')],
                    value: doc_no
                }, function (value, index, elem) {
                    Fast.api.ajax({
                        url: 'orders/edit?ids=' + ids,
                        data: {
                            'row[doc_no]': value
                        }
                    }, function (data, ret) {
                        if (ret.code == 1) {
                            that.data('doc_no', value);
                            that.text(value);
                        } else {
                            Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (value, index, elem) {
                    Layer.close(index);
                });
            });


            $(document).on("click", ".update-orders-remark", function () {
                let ids = $(this).data('orders_id');
                let remark = $(this).data('remark');
                let that = $(this);
                Layer.prompt({
                    title: __('Please enter remark'),
                    formType: 2,
                    btn: [__('OK'), __('Cancel')],
                    value: remark
                }, function (value, index, elem) {
                    Fast.api.ajax({
                        url: 'orders/edit?ids=' + ids,
                        data: {
                            'row[remark]': value
                        }
                    }, function (data, ret) {
                        if (ret.code == 1) {
                            that.data('remark', value);
                            that.text(value);
                        } else {
                            Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (value, index, elem) {
                    Layer.close(index);
                });
            });

            $(document).on("click", ".btn-ac_approve", function () {
                $('#paid_action').val('ac_approve');
                let obj = document.getElementsByName("orders_id");
                let checkList = [];
                for (let k in obj) {
                    if (obj[k].checked) {
                        checkList.push(obj[k].value);
                    }
                }
                let len = checkList.length;
                if (len >= 1) {
                    Layer.confirm(__('Are you sure you want to do this?'), {
                        title: __('Tips'),
                        btn: [__('OK'), __('Cancel')],
                    }, function (index) {
                        Fast.api.ajax({
                            url: 'service_center/view_paid',
                            data: {
                                orders_ids: checkList.join(','),
                                paid_action: 'ac_approve'
                            }
                        }, function (data, ret) {
                            if (ret.code == 1) {
                                setTimeout(function () {
                                    location.reload();
                                }, 2000);
                            } else {
                                // Layer.msg(ret.msg || 'Error');
                            }
                        }, function (data, ret) {
                            // Layer.msg(__('Error'));
                        });
                        Layer.close(index);
                    }, function (index) {
                        Layer.close(index);
                    });
                } else {
                    Layer.msg(__('Please choose one or more orders you want to confirm account.'));
                }
            });

            $(document).on("click", ".btn-ac_renounce", function () {
                $('#paid_action').val('ac_renounce');
                let obj = document.getElementsByName("orders_id");
                let checkList = [];
                for (let k in obj) {
                    if (obj[k].checked) {
                        checkList.push(obj[k].value);
                    }
                }
                let len = checkList.length;
                if (len >= 1) {
                    Layer.confirm(__('Are you sure you want to do this?'), {
                        title: __('Tips'),
                        btn: [__('OK'), __('Cancel')],
                    }, function (index) {
                        Fast.api.ajax({
                            url: 'service_center/view_paid',
                            data: {
                                orders_ids: checkList.join(','),
                                paid_action: 'ac_renounce'
                            }
                        }, function (data, ret) {
                            if (ret.code == 1) {
                                setTimeout(function () {
                                    location.reload();
                                }, 2000);
                            } else {
                                // Layer.msg(ret.msg || 'Error');
                            }
                        }, function (data, ret) {
                            // Layer.msg(__('Error'));
                        });
                        Layer.close(index);
                    }, function (index) {
                        Layer.close(index);
                    });
                } else {
                    Layer.msg(__('Please choose an order you want to renounce.'));
                }
            });

            Controller.api.bindevent();
        },
        view_new_order(){
            $(document).on("click", "#new-order-services", function () {
                let is_reload = true;
                let memberid = $(this).data('memberid');
                Fast.api.open('orders/add?memberid='+memberid, __('New order services'), {
                    cancel:function (){
                        is_reload = false;
                    },
                    end: function () {
                        if (is_reload){
                            // setTimeout(function (){
                            //     location.reload();
                            // },1500);
                        }
                    }
                });
            });
            Controller.api.bindevent();
        },
        view_all_booking(){
            $(document).on("click", ".update-booking_status", function () {
                let booking_id = $(this).data('booking_id');
                let booking_status = $(this).data('booking_status');
                let that = $(this);
                Layer.confirm(booking_status != 'U'?__('Checking this box will change the status from Unused to Used. Click OK to confirm the action.'):__('Checking this box will change the status from Used to Unused. Click OK to confirm the action.'),{
                    title: __('Tips'),
                    btn: [__('OK'), __('Cancel')]
                }, function (index) {
                    Fast.api.ajax({
                        url: 'service_center/edit_booking_status',
                        data: {
                            booking_status,
                            booking_id
                        }
                    }, function (data, ret) {
                        if (ret.code == 1) {
                            that.prop("checked", booking_status != 'U');
                            setTimeout(function () {
                                location.reload();
                            }, 2000);
                        } else {
                            // Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        // Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (index) {
                    that.prop("checked", booking_status == 'U');
                    Layer.close(index);
                });
            });

            $(document).on("click", ".update-booking-remark", function () {
                let ids = $(this).data('booking_id');
                let remark = $(this).data('remark');
                let that = $(this);
                Layer.prompt({
                    title: __('Please enter remark'),
                    formType: 2,
                    btn: [__('OK'), __('Cancel')],
                    value: remark
                }, function (value, index, elem) {
                    Fast.api.ajax({
                        url: 'booking/edit?ids=' + ids,
                        data: {
                            'row[remark]': value
                        }
                    }, function (data, ret) {
                        if (ret.code == 1) {
                            that.data('remark', value);
                            that.text(value);
                        } else {
                            Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (value, index, elem) {
                    Layer.close(index);
                });
            });

            $(document).on("click", ".btn-delete", function () {
                $('#booking_action').val('delete');
                let obj = document.getElementsByName("booking_id");
                let checkList = [];
                for (let k in obj) {
                    if (obj[k].checked) {
                        checkList.push(obj[k].value);
                    }
                }
                let len = checkList.length;
                if (len >= 1) {
                    Layer.confirm(__("Are you sure to delete?<br>This action will delete the target record(s) forever!!!"), {
                        title: __('Tips'),
                        btn: [__('OK'), __('Cancel')],
                    }, function (index) {
                        Fast.api.ajax({
                            url: 'service_center/view_all_booking',
                            data: {
                                booking_ids: checkList.join(','),
                                booking_action: 'delete'
                            }
                        }, function (data, ret) {
                            if (ret.code == 1) {
                                setTimeout(function () {
                                    location.reload();
                                }, 2000);
                            } else {
                                // Layer.msg(ret.msg || 'Error');
                            }
                        }, function (data, ret) {
                            // Layer.msg(__('Error'));
                        });
                        Layer.close(index);
                    }, function (index) {
                        Layer.close(index);
                    });
                } else {
                    Layer.msg(__('Please choose one or more records!!!'));
                }
            });


            $(document).on("click", ".btn-edit", function () {
                $('#booking_action').val('edit');
                let obj = document.getElementsByName("booking_id");
                let checkList = [];
                for (let k in obj) {
                    if (obj[k].checked) {
                        checkList.push(obj[k].value);
                    }
                }
                let len = checkList.length;
                if (len == 1) {
                    let is_reload = true;
                    Fast.api.open('booking/edit?ids=' + checkList[0], __('Edit booking'), {
                        cancel:function (){
                            is_reload = false;
                        },
                        end: function () {
                            if (is_reload){
                                setTimeout(function (){
                                    location.reload();
                                },1500);
                            }
                        }
                    });
                } else {
                    Layer.msg(__('Please choose a prefered record !!!'));
                }
            });


            $(document).on("click", ".btn-cancel", function () {
                $('#booking_action').val('cancel');
                let obj = document.getElementsByName("booking_id");
                let checkList = [];
                for (let k in obj) {
                    if (obj[k].checked) {
                        checkList.push(obj[k].value);
                    }
                }
                let len = checkList.length;
                if (len >= 1) {
                    Layer.confirm(__('Are you sure to cancel?'), {
                        title: __('Tips'),
                        btn: [__('OK'), __('Cancel')],
                    }, function (index) {
                        Fast.api.ajax({
                            url: 'service_center/view_all_booking',
                            data: {
                                booking_ids: checkList.join(','),
                                booking_action: 'cancel'
                            }
                        }, function (data, ret) {
                            if (ret.code == 1) {
                                setTimeout(function () {
                                    location.reload();
                                }, 2000);
                            } else {
                                // Layer.msg(ret.msg || 'Error');
                            }
                        }, function (data, ret) {
                            // Layer.msg(__('Error'));
                        });
                        Layer.close(index);
                    }, function (index) {
                        Layer.close(index);
                    });
                } else {
                    Layer.msg(__('Please choose one or more records!!!'));
                }
            });

            $(document).on("click", ".btn-duplicate", function () {
                $('#booking_action').val('duplicate');
                let obj = document.getElementsByName("booking_id");
                let checkList = [];
                for (let k in obj) {
                    if (obj[k].checked) {
                        checkList.push(obj[k].value);
                    }
                }
                let len = checkList.length;
                if (len == 1) {
                    Layer.confirm(__('Duplicate booking?'), {
                        title: __('Tips'),
                        btn: [__('OK'), __('Cancel')],
                    }, function (index) {
                        Fast.api.ajax({
                            url: 'service_center/view_all_booking',
                            data: {
                                booking_id: checkList[0],
                                booking_action: 'duplicate'
                            }
                        }, function (data, ret) {
                            if (ret.code == 1) {
                                setTimeout(function () {
                                    location.reload();
                                }, 2000);
                            } else {
                                // Layer.msg(ret.msg || 'Error');
                            }
                        }, function (data, ret) {
                            // Layer.msg(__('Error'));
                        });
                        Layer.close(index);
                    }, function (index) {
                        Layer.close(index);
                    });
                } else {
                    Layer.msg(__('Please select only one booking to duplicate !!!'));
                }
            });

            $(document).on("click", ".btn-renounce", function () {
                $('#booking_action').val('renounce');
                let obj = document.getElementsByName("booking_id");
                let checkList = [];
                for (let k in obj) {
                    if (obj[k].checked) {
                        checkList.push(obj[k].value);
                    }
                }
                let len = checkList.length;
                if (len >= 1) {
                    Layer.confirm(__('Renounce booking?'), {
                        title: __('Tips'),
                        btn: [__('OK'), __('Cancel')],
                    }, function (index) {
                        Fast.api.ajax({
                            url: 'service_center/view_all_booking',
                            data: {
                                booking_ids: checkList.join(','),
                                booking_action: 'renounce'
                            }
                        }, function (data, ret) {
                            if (ret.code == 1) {
                                setTimeout(function () {
                                    location.reload();
                                }, 2000);
                            } else {
                                // Layer.msg(ret.msg || 'Error');
                            }
                        }, function (data, ret) {
                            // Layer.msg(__('Error'));
                        });
                        Layer.close(index);
                    }, function (index) {
                        Layer.close(index);
                    });
                } else {
                    Layer.msg(__('Please select only one booking to renounce !!!'));
                }
            });


            $(document).on("click", ".btn-print_confirmation", function () {
                $('#booking_action').val('print_confirmation');
                let obj = document.getElementsByName("booking_id");
                let checkList = [];
                for (let k in obj) {
                    if (obj[k].checked) {
                        checkList.push(obj[k].value);
                    }
                }
                let len = checkList.length;
                if (len == 1) {
                    let url = Config.moduleurl + '/service_center/print_confirmation?booking_id=' + checkList[0];
                    window.open(url, "_blank");
                } else {
                    Layer.msg(__('Please select only one order to print confirmation!!!'));
                }
            });

            Controller.api.bindevent();
        },
        view_new_booking(){
            $(document).on("click", "#new-booking", function () {
                if (!$('#confirmation_no').val().trim() || !$('#confirmation_year').val().trim()){
                    Layer.msg(__('Please input Confirmation No.!!!'));
                    return;
                }
                if (!$('#Resort').val().trim()){
                    Layer.msg(__('Please select Resort!!!'));
                    return;
                }
                let is_reload = true;
                Fast.api.open('booking/add?'+$('#bookin-form').serialize(), __('New Booking'), {
                    cancel:function (){
                        is_reload = false;
                    },
                    end: function () {
                        if (is_reload){
                            setTimeout(function (){
                                location.reload();
                            },1500);
                        }
                    }
                });
            });
            Form.events.selectpage($('#bookin-form'));
            Form.events.datetimepicker($('#bookin-form'));
            Controller.api.bindevent();
        },
        view_un_used(){
            this.view_all_booking();
        },
        view_used(){
            $(document).on("click", ".preview_order", function () {
                let ids = $(this).data('orders_id');
                Fast.api.open('orders/preview_order?ids=' + ids, __('Preview order'), {
                    callback: function (value) {
                        console.log(value)
                    }
                });
            });
            $(document).on("click", ".update-doc_no", function () {
                let ids = $(this).data('orders_id');
                let doc_no = $(this).data('doc_no');
                let that = $(this);
                Layer.prompt({
                    title: __('Please enter Document No.'),
                    btn: [__('OK'), __('Cancel')],
                    value: doc_no
                }, function (value, index, elem) {
                    Fast.api.ajax({
                        url: 'orders/edit?ids=' + ids,
                        data: {
                            'row[doc_no]': value
                        }
                    }, function (data, ret) {
                        if (ret.code == 1) {
                            that.data('doc_no', value);
                            that.text(value);
                        } else {
                            Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (value, index, elem) {
                    Layer.close(index);
                });
            });


            $(document).on("click", ".update-orders-remark", function () {
                let ids = $(this).data('orders_id');
                let remark = $(this).data('remark');
                let that = $(this);
                Layer.prompt({
                    title: __('Please enter remark'),
                    formType: 2,
                    btn: [__('OK'), __('Cancel')],
                    value: remark
                }, function (value, index, elem) {
                    Fast.api.ajax({
                        url: 'orders/edit?ids=' + ids,
                        data: {
                            'row[remark]': value
                        }
                    }, function (data, ret) {
                        if (ret.code == 1) {
                            that.data('remark', value);
                            that.text(value);
                        } else {
                            Layer.msg(ret.msg || 'Error');
                        }
                    }, function (data, ret) {
                        Layer.msg(__('Error'));
                    });
                    Layer.close(index);
                }, function (value, index, elem) {
                    Layer.close(index);
                });
            });
            this.view_all_booking();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
