define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'staff/index' + location.search,
                    add_url: 'staff/add',
                    edit_url: 'staff/edit',
                    del_url: 'staff/del',
                    multi_url: 'staff/multi',
                    import_url: 'staff/import',
                    table: 'staff',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'Staff_ID',
                sortName: 'Staff_ID',
                fixedColumns: true,
                fixedRightNumber: 1,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'Staff_ID', title: __('Staff_id')},
                        {field: 'Staff_UserName', title: __('Staff_username'), operate: 'LIKE'},
                        {field: 'Staff_Password', title: __('Staff_password'), operate: 'LIKE'},
                        {field: 'Staff_Title', title: __('Staff_title'), operate: 'LIKE'},
                        {field: 'Staff_FName', title: __('Staff_fname'), operate: 'LIKE'},
                        {field: 'Staff_SName', title: __('Staff_sname'), operate: 'LIKE'},
                        {field: 'Staff_UserCode', title: __('Staff_usercode'), operate: 'LIKE'},
                        {field: 'Staff_Birthday', title: __('Staff_birthday'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'Staff_Address', title: __('Staff_address'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'Staff_Phone', title: __('Staff_phone'), operate: 'LIKE'},
                        {field: 'Staff_Mobile', title: __('Staff_mobile'), operate: 'LIKE'},
                        {field: 'Staff_Email', title: __('Staff_email'), operate: 'LIKE'},
                        {field: 'Staff_Remark', title: __('Staff_remark'), operate: 'LIKE', table: table, class: 'autocontent', formatter: Table.api.formatter.content},
                        {field: 'Staff_UserPriv', title: __('Staff_userpriv'), operate: 'LIKE'},
                        {field: 'Staff_Hidden', title: __('Staff_hidden')},
                        {field: 'Staff_CreateBy', title: __('Staff_createby'), operate: 'LIKE'},
                        {field: 'Staff_CreateDate', title: __('Staff_createdate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'Staff_UpdateBy', title: __('Staff_updateby'), operate: 'LIKE'},
                        {field: 'Staff_UpdateDate', title: __('Staff_updatedate'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
