define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'temp/session/index' + location.search,
                    add_url: 'temp/session/add',
                    edit_url: 'temp/session/edit',
                    del_url: 'temp/session/del',
                    multi_url: 'temp/session/multi',
                    import_url: 'temp/session/import',
                    table: 'temp_session',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'id',
                sortName: 'id',
                columns: [
                    [
                                                {field: 'sMemberID', title: __('Smemberid')},
                        {field: 'sLoginName', title: __('Sloginname'), operate: 'LIKE'},
                        {field: 'sEmail', title: __('Semail'), operate: 'LIKE'},
                        {field: 'sLoginSurName', title: __('Sloginsurname'), operate: 'LIKE'},
                        {field: 'sLogonTime', title: __('Slogontime'), operate:'RANGE', addclass:'datetimerange', autocomplete:false, formatter: Table.api.formatter.datetime},
{checkbox: true},
                        {field: 'id', title: __('Id')},
                        {field: 'sUsername', title: __('Susername'), operate: 'LIKE'},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
