define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {

    var Controller = {
        index: function () {
            // 初始化表格参数配置
            Table.api.init({
                extend: {
                    index_url: 'userslogon/index' + location.search,
                    add_url: 'userslogon/add',
                    edit_url: 'userslogon/edit',
                    del_url: 'userslogon/del',
                    multi_url: 'userslogon/multi',
                    import_url: 'userslogon/import',
                    table: 'userslogon',
                }
            });

            var table = $("#table");

            // 初始化表格
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                pk: 'userslogon_id',
                sortName: 'userslogon_id',
                columns: [
                    [
                        {checkbox: true},
                        {field: 'userslogon_id', title: __('Userslogon_id')},
                        {field: 'userid', title: __('Userid')},
                        {field: 'userslogon_sid', title: __('Userslogon_sid'), operate: 'LIKE'},
                        {field: 'userslogon_logon', title: __('Userslogon_logon'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'userslogon_logout', title: __('Userslogon_logout'), operate:'RANGE', addclass:'datetimerange', autocomplete:false},
                        {field: 'userslogon_usetime', title: __('Userslogon_usetime'), operate: 'LIKE'},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]
            });

            // 为表格绑定事件
            Table.api.bindevent(table);
        },
        add: function () {
            Controller.api.bindevent();
        },
        edit: function () {
            Controller.api.bindevent();
        },
        api: {
            bindevent: function () {
                Form.api.bindevent($("form[role=form]"));
            }
        }
    };
    return Controller;
});
