<?php

namespace app\admin\command;

use app\admin\model\AuthRule;
use think\Config;
use think\console\Command;
use think\console\Input;
use think\console\Output;
use think\Loader;

class MyMenu extends Command
{
    protected $model = null;
    // 已经处理过的控制器
    protected $update_controller = [];

    protected function configure()
    {
        $this->setName('mymenu')->setDescription('创建我的菜单权限规则');
    }

    protected function execute(Input $input, Output $output)
    {
        $this->model = new AuthRule();

        // 查询大于54的权限菜单，这些菜单是去掉框架生成的系统菜单，系统菜单不需要处理
        $auth_rule_data = $this->model->where('id', '>', 54)
            ->where('ismenu', 1)
            ->select();
        if (empty($auth_rule_data)) {
            $output->writeln('暂无菜单需要生成权限规则');
            exit();
        }
        $controllers = [];
        foreach ($auth_rule_data as $v) {
            $num = $this->model->where('pid', $v['id'])->count();
            if ($num > 0) {
                $output->writeln('非子集菜单，无需处理');
                continue;
            }
            if (!empty($v['url'])) {
                $path = parse_url(trim($v['url'], '/'), PHP_URL_PATH);
                if (!empty($path)) {
                    $output->writeln('子集菜单：' . $path);
                    $controllers[] = [
                        'id' => $v['id'],
                        'controller' => $path
                    ];
                    continue;
                }
            }
            if (!empty($v['name'])) {
                $output->writeln('子集菜单：' . $v['name']);
                $controllers[] = [
                    'id' => $v['id'],
                    'controller' => $v['name']
                ];
            }
        }
        if (empty($controllers)) {
            $output->writeln('暂无菜单需要处理');
            exit();
        }
        foreach ($controllers as $v) {
            $item = $v['controller'];
            $pid = $v['id'];
            if (stripos($item, '_') !== false) {
                $item = Loader::parseName($item, 1);
            }
            if (stripos($item, '/') !== false) {
                $controllerArr = explode('/', $item);
                end($controllerArr);
                $key = key($controllerArr);
                $controllerArr[$key] = ucfirst($controllerArr[$key]);
            } else {
                $controllerArr = [ucfirst($item)];
            }
            $adminPath = dirname(__DIR__) . DS . 'controller' . DS . implode(DS, $controllerArr) . '.php';
            if (!is_file($adminPath)) {
                $output->error('[' . $item . ']控制器文件不存在：' . $adminPath);
                continue;
            }
            $this->importRule($item, $pid);
        }

        // 查询非框架菜单，以及非创建的菜单，生成规则
        $adminPath = dirname(__DIR__) . DS;
        $controllerDir = $adminPath . 'controller' . DS;
        // 扫描新的节点信息并导入
        $this->import($this->scandir($controllerDir));
    }

    /**
     * 导入规则
     * @param $controller
     * @param int $pid 父菜单id
     * @param int $ismenu 是否显示菜单
     * @return void
     * @throws \ReflectionException
     */
    protected function importRule($controller, $pid = 0, $ismenu = 1)
    {
        $system_controllers = explode(',', "Addon.php,Ajax.php,Category.php,Dashboard.php,Index.php,Addon.php,Ajax.php,Category.php,Dashboard.php,Index.php,auth/Admin.php,auth/Adminlog.php,auth/Group.php,auth/Rule.php,Addon.php,Ajax.php,Category.php,Dashboard.php,Index.php,Addon.php,Ajax.php,Category.php,Dashboard.php,Index.php,auth/Admin.php,auth/Adminlog.php,auth/Group.php,auth/Rule.php,general/Attachment.php,general/Config.php,general/Profile.php,Addon.php,Ajax.php,Category.php,Dashboard.php,Index.php,Addon.php,Ajax.php,Category.php,Dashboard.php,Index.php,auth/Admin.php,auth/Adminlog.php,auth/Group.php,auth/Rule.php,Addon.php,Ajax.php,Category.php,Dashboard.php,Index.php,Addon.php,Ajax.php,Category.php,Dashboard.php,Index.php,auth/Admin.php,auth/Adminlog.php,auth/Group.php,auth/Rule.php,general/Attachment.php,general/Config.php,general/Profile.php,user/Group.php,user/Rule.php,user/User.php");
        $controller = str_replace('\\', '/', $controller);
        if (stripos($controller, '/') !== false) {
            $controllerArr = explode('/', $controller);
            end($controllerArr);
            $key = key($controllerArr);
            $controllerArr[$key] = ucfirst($controllerArr[$key]);
        } else {
            $key = 0;
            $controllerArr = [ucfirst($controller)];
        }
        $controller_file = implode('/', $controllerArr) . '.php';
        // 框架自带控制器，无需处理
        if (in_array($controller_file, $system_controllers)) {
            return;
        }
        // 已经处理过的控制器，无需处理
        if (in_array($controller_file, $this->update_controller)) {
            return;
        }
        $this->update_controller[] = $controller_file;
        $classSuffix = Config::get('controller_suffix') ? ucfirst(Config::get('url_controller_layer')) : '';
        $className = "\\app\\admin\\controller\\" . implode("\\", $controllerArr) . $classSuffix;

        $pathArr = $controllerArr;
        array_unshift($pathArr, '', 'application', 'admin', 'controller');
        $classFile = ROOT_PATH . implode(DS, $pathArr) . $classSuffix . ".php";
        $classContent = file_get_contents($classFile);
        $uniqueName = uniqid("FastAdmin") . $classSuffix;
        $classContent = str_replace("class " . $controllerArr[$key] . $classSuffix . " ", 'class ' . $uniqueName . ' ', $classContent);
        $classContent = preg_replace("/namespace\s(.*);/", 'namespace ' . __NAMESPACE__ . ";", $classContent);

        //临时的类文件
        $tempClassFile = __DIR__ . DS . $uniqueName . ".php";
        file_put_contents($tempClassFile, $classContent);
        $className = "\\app\\admin\\command\\" . $uniqueName;

        //删除临时文件
        register_shutdown_function(function () use ($tempClassFile) {
            if ($tempClassFile) {
                //删除临时文件
                @unlink($tempClassFile);
            }
        });

        //反射机制调用类的注释和方法名
        $reflector = new \ReflectionClass($className);

        //只匹配公共的方法
        $methods = $reflector->getMethods(\ReflectionMethod::IS_PUBLIC);
        $classComment = $reflector->getDocComment();
        //判断是否有启用软删除
        $softDeleteMethods = ['destroy', 'restore', 'recyclebin'];
        $withSofeDelete = false;
        $modelRegexArr = ["/\\\$this\->model\s*=\s*model\(['|\"](\w+)['|\"]\);/", "/\\\$this\->model\s*=\s*new\s+([a-zA-Z\\\]+);/"];
        $modelRegex = preg_match($modelRegexArr[0], $classContent) ? $modelRegexArr[0] : $modelRegexArr[1];
        preg_match_all($modelRegex, $classContent, $matches);
        if (isset($matches[1]) && isset($matches[1][0]) && $matches[1][0]) {
            \think\Request::instance()->module('admin');
            $model = model($matches[1][0]);
            if (in_array('trashed', get_class_methods($model))) {
                $withSofeDelete = true;
            }
        }
        //忽略的类
        if (stripos($classComment, "@internal") !== false) {
            return;
        }
        preg_match_all('#(@.*?)\n#s', $classComment, $annotations);
        $controllerIcon = 'fa fa-circle-o';
        $controllerRemark = '';
        //判断注释中是否设置了icon值
        if (isset($annotations[1])) {
            foreach ($annotations[1] as $tag) {
                if (stripos($tag, '@icon') !== false) {
                    $controllerIcon = substr($tag, stripos($tag, ' ') + 1);
                }
                if (stripos($tag, '@remark') !== false) {
                    $controllerRemark = substr($tag, stripos($tag, ' ') + 1);
                }
            }
        }
        //过滤掉其它字符
        $controllerTitle = trim(preg_replace(array('/^\/\*\*(.*)[\n\r\t]/u', '/[\s]+\*\//u', '/\*\s@(.*)/u', '/[\s|\*]+/u'), '', $classComment));

        //导入中文语言包
        \think\Lang::load(dirname(__DIR__) . DS . 'lang/zh-cn.php');

        //先导入菜单的数据
//        $pid = 0;
        foreach ($controllerArr as $k => $v) {
            $key = $k + 1;
            //驼峰转下划线
            $controllerNameArr = array_slice($controllerArr, 0, $key);
            foreach ($controllerNameArr as &$val) {
                $val = strtolower(trim(preg_replace("/[A-Z]/", "_\\0", $val), "_"));
            }
            unset($val);
            $name = implode('/', $controllerNameArr);
            $title = (!isset($controllerArr[$key]) ? $controllerTitle : '');
            $icon = (!isset($controllerArr[$key]) ? $controllerIcon : 'fa fa-list');
            $remark = (!isset($controllerArr[$key]) ? $controllerRemark : '');
            $title = $title ? $title : $v;
            $rulemodel = $this->model->get(['name' => $name]);
            if (empty($pid)) {
                if (!$rulemodel) {
                    $this->model
                        ->data(['pid' => $pid, 'name' => $name, 'title' => $title, 'icon' => $icon, 'remark' => $remark, 'ismenu' => $ismenu, 'status' => 'normal'])
                        ->isUpdate(false)
                        ->save();
                    $pid = $this->model->id;
                } else {
                    $pid = $rulemodel->id;
                }
            }
        }
        $ruleArr = [];
        foreach ($methods as $m => $n) {
            //过滤特殊的类
            if (substr($n->name, 0, 2) == '__' || $n->name == '_initialize') {
                continue;
            }
            //未启用软删除时过滤相关方法
            if (!$withSofeDelete && in_array($n->name, $softDeleteMethods)) {
                continue;
            }
            //只匹配符合的方法
            if (!preg_match('/^(\w+)' . Config::get('action_suffix') . '/', $n->name, $matchtwo)) {
                unset($methods[$m]);
                continue;
            }
            $comment = $reflector->getMethod($n->name)->getDocComment();
            //忽略的方法
            if (stripos($comment, "@internal") !== false) {
                continue;
            }
            //过滤掉其它字符
            $comment = preg_replace(array('/^\/\*\*(.*)[\n\r\t]/u', '/[\s]+\*\//u', '/\*\s@(.*)/u', '/[\s|\*]+/u'), '', $comment);

            $title = $comment ? $comment : ucfirst($n->name);

            //获取主键，作为AuthRule更新依据
            $id = $this->getAuthRulePK($name . "/" . strtolower($n->name));

            $ruleArr[] = array('id' => $id, 'pid' => $pid, 'name' => $name . "/" . strtolower($n->name), 'icon' => 'fa fa-circle-o', 'title' => $title, 'ismenu' => 0, 'status' => 'normal');
        }
        $this->model->isUpdate(false)->saveAll($ruleArr);
    }

    //获取主键
    protected function getAuthRulePK($name)
    {
        if (!empty($name)) {
            $id = $this->model
                ->where('name', $name)
                ->value('id');
            return $id ? $id : null;
        }
    }

    /**
     * 递归扫描文件夹
     * @param string $dir
     * @return array
     */
    public function scandir($dir)
    {
        $result = [];
        $cdir = scandir($dir);
        foreach ($cdir as $value) {
            if (!in_array($value, array(".", ".."))) {
                if (is_dir($dir . DS . $value)) {
                    $result[$value] = $this->scandir($dir . DS . $value);
                } else {
                    $result[] = $value;
                }
            }
        }
        return $result;
    }

    /**
     * 导入规则节点
     * @param array $dirarr
     * @param array $parentdir
     * @return array
     * @throws \ReflectionException
     */
    public function import($dirarr, $parentdir = [])
    {
        $menuarr = [];
        foreach ($dirarr as $k => $v) {
            if (is_array($v)) {
                //当前是文件夹
                $nowparentdir = array_merge($parentdir, [$k]);
                $this->import($v, $nowparentdir);
            } else {
                //只匹配PHP文件
                if (!preg_match('/^(\w+)\.php$/', $v, $matchone)) {
                    continue;
                }
                //导入文件
                $controller = ($parentdir ? implode('/', $parentdir) . '/' : '') . $matchone[1];
                $this->importRule($controller, 0, 0);
            }
        }

        return $menuarr;
    }
}