<?php

namespace app\admin\command;

use think\console\Command;
use think\console\Input;
use think\console\Output;
use think\Db;

class Zhuan extends Command
{
    protected function configure()
    {
        $this->setName('zhuan')->setDescription('转移旧表数据至新表');
    }

    protected function execute(Input $input, Output $output)
    {
        // 将原数据库中的表转移至新表
        // 新表
        $fast_db = 'hcs_new';
        // 原表
        $src_db = 'hutweb_hcsasia_thb';


        $src_db_obj = Db::connect([
            // 数据库类型
            'type' => 'mysql',
            // 数据库连接DSN配置
            'dsn' => '',
            // 服务器地址
            'hostname' => '127.0.0.1',
            // 数据库名
            'database' => $src_db,
            // 数据库用户名
            'username' => 'root',
            // 数据库密码
            'password' => '123456',
            // 数据库连接端口
            'hostport' => 3306,
            // 数据库连接参数
            'params' => [],
            // 数据库编码默认采用utf8
            'charset' => 'utf8',
            // 数据库表前缀
            'prefix' => '',
        ]);

        $system_tables = ['admin','admin_log','area','attachment','auth_group','auth_group_access','auth_rule','category','config','ems','sms','test','user','user_group','user_money_log','user_rule','user_score_log','user_token','version'];

        $tmp = $src_db_obj->query('show tables');
        $tables = $this->getTables($tmp);

        foreach ($tables as $table){
            if (in_array($table,$system_tables)){
                continue;
            }
            $output->writeln('C:\dev\php\php-7.3.0\php.exe think crud -t '.$table);
        }



    }

    /**
     * 获取表
     * @param $data
     * @return array
     */
    public function getTables($data)
    {
        $tables = [];
        foreach ($data as $v) {
            $tables[] = array_values($v)[0];
        }
        return $tables;
    }
}