<?php

namespace app\admin\controller;

use app\admin\model\binding\Main;
use app\admin\model\booking\Detail;
use app\admin\model\booking\Unittype;
use app\admin\model\confirmation\Type;
use app\admin\model\orders\Addi;
use app\admin\model\orders\Bonus;
use app\admin\model\orders\Extra;
use app\admin\model\orders\Van;
use app\common\controller\Backend;
use think\Db;
use think\exception\DbException;
use think\exception\PDOException;
use think\exception\ValidateException;
use think\response\Json;

/**
 *
 *
 * @icon fa fa-circle-o
 */
class Booking extends Backend
{

    /**
     * Booking模型对象
     * @var \app\admin\model\Booking
     */
    protected $model = null;
    protected $searchFields = ['booking_id', 'memberid', 'confirmation_no'];
    protected $relationSearch = true;

    public function _initialize()
    {
        parent::_initialize();
        $this->model = new \app\admin\model\Booking;

    }


    /**
     * 查看
     *
     * @return string|Json
     * @throws \think\Exception
     * @throws DbException
     */
    public function index()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            return $this->view->fetch();
        }
        //如果发送的来源是 Selectpage，则转发到 Selectpage
        if ($this->request->request('keyField')) {
            return $this->selectpage();
        }
        [$where, $sort, $order, $offset, $limit] = $this->buildparams();


        $list = $this->model
            ->where($where)
            ->with([
                'member' => function ($query) {
                    $query->withField('title,login_name,login_surname');
                }
            ])
            ->order($sort, $order)
            ->paginate($limit);
        $rows = $list->items();
        if (!empty($rows)){
            foreach ($rows as &$row) {
                $row->booking_date = format_date($row->booking_date,'d/m/Y H:i:s');
                $checkin_date = $row->checkin_date;
                $row->checkin_date = format_date($checkin_date);
                $row->checkin_date_time = format_date($checkin_date,'H:i:s');
                $checkout_date = $row->checkout_date;
                $row->checkout_date = format_date($checkout_date);
                $row->checkout_date_time = format_date($checkout_date,'H:i:s');
            }
        }
        $result = ['total' => $list->total(), 'rows' => $rows];
        return json($result);
    }

    /**
     * 添加
     *
     * @return string
     * @throws \think\Exception
     */
    public function add()
    {
        if (false === $this->request->isPost()) {
            $get_data = input('get.');
            $this->view->assign('checkin_date', $get_data['ci_date'] . ' ' . $get_data['ci_hour'] . ':' . $get_data['ci_min'] . ':00');
            $this->view->assign('checkout_date', $get_data['co_date'] . ' ' . $get_data['co_hour'] . ':' . $get_data['co_min'] . ':00');
            $this->view->assign('confirmation_no', $get_data['Resort_Code'] . '/' . $get_data['confirm_type'] . '/' . $get_data['confirmation_year']);
            $this->view->assign('confirm_type', $get_data['confirm_type']);
            $this->view->assign('memberid', $get_data['memberid']);
            $this->view->assign('Resort', $get_data['Resort']);
            $this->view->assign('Resort_Name', $get_data['Resort_text']);

            if (!empty($get_data['mbs'])) {
                $this->view->assign('mbs', $get_data['mbs']);
                $sql = "SELECT MD.ms_detail_id, MD.ms_detail_year, P.unittype FROM membership_detail MD INNER JOIN package P ON P.packageid=MD.packageid WHERE MD.paid_status='Y' AND MD.ms_detail_used!='Y' AND MD.memberid='" . $get_data['memberid'] . "' AND MD.hierarchyid='" . $get_data['mbs'] . "' ORDER BY MD.ms_detail_year";
                $this->view->assign('mbs_list', Db::query($sql));
            } else {
                $this->view->assign('mbs', '');
            }

            if (!empty($get_data['extra'])) {
                $sql = "
			SELECT
				ODE.orders_extra_id		AS	Orders_Extra_ID,
				OD.orders_id				AS	Orders_ID,
				OD.orders_code			AS	Orders_Code,
				ODE.extra_unittype		AS	Unit_Type,
				ODE.extranight			AS	Extra_Night,
				ODE.room_amount			AS	RoomAmount
			FROM orders_extra ODE
				LEFT OUTER JOIN orders OD ON OD.orders_id=ODE.orders_id
			WHERE orders_extra_id in (" . implode(',', $get_data['extra']) . ")
			";
                $this->view->assign('extra_data', Db::query($sql));
            }

            if (!empty($get_data['bonus'])) {
                $sql = "SELECT
			ODB.orders_bonus_id		AS	Orders_Bonus_ID,
			OD.orders_id				AS	Orders_ID,
			OD.orders_code			AS	Orders_Code,
			ODB.bonus_type			AS	Bonus_Type,
			ODB.bonus_unittype		AS	Unit_Type,
			ODB.bonus_fullweek		AS	Full_Week,
			ODB.bonus_midweek		AS	Mid_Week,
			ODB.bonus_weekend		AS	Weekend,
			ODB.bonus_extranight		AS	Extra_Night,
			ODB.room_amount			AS	RoomAmount
			FROM orders_bonus ODB
			LEFT OUTER JOIN orders OD ON OD.orders_id=ODB.orders_id
			WHERE ODB.orders_bonus_id in(" . implode(',', $get_data['bonus']) . ")";
                $this->view->assign('bonus_data', Db::query($sql));
            }

            if (!empty($get_data['exchange'])) {
                $sql = "SELECT
			ODX.orders_van_id		AS	Orders_Exchange_ID,
			OD.orders_id			AS	Orders_ID,
			OD.orders_code		AS	Orders_Code,
			ODX.from_contract		AS	Contract_No,
			ODX.from_year		AS	Entitlement_Year,
			ODX.from_unittype		AS	F_Unit_Type,
			ODX.from_fullweek		AS	F_Full_Week,
			ODX.from_midweek		AS	F_Mid_Week,
			ODX.from_weekend	AS	F_Weekend,
			ODX.resortid			AS	T_Resort,
			ODX.to_unittype		AS	T_Unit_Type,
			ODX.to_fullweek		AS	T_Full_Week,
			ODX.to_midweek		AS	T_Mid_Week,
			ODX.to_weekend		AS	T_Weekend,
			ODX.room_amount		AS	T_RoomAmount
			FROM orders_van ODX
			LEFT OUTER JOIN orders OD ON OD.orders_id=ODX.orders_id
			WHERE ODX.orders_van_id in (" . implode(',', $get_data['exchange']) . ")";
                $this->view->assign('exchange_data', Db::query($sql));
            }

            if (!empty($get_data['addition'])) {
                $sql = "
			SELECT
			ODA.orders_addi_id		AS	Orders_Addition_ID,
			OD.orders_id				AS	Orders_ID,
			OD.orders_code			AS	Orders_Code,
			ODA.addi_rate_name		AS	Addition_Name,
			ODA.addi_unit				AS	Unit
			FROM orders_addi ODA
			LEFT OUTER JOIN orders OD ON OD.orders_id=ODA.orders_id
			WHERE ODA.orders_addi_id in (" . implode(',', $get_data['addition']) . ")
			";
                $this->view->assign('addition_data', Db::query($sql));
            }

            return $this->view->fetch();
        }
        $params = $this->request->post('row/a');
        if (empty($params)) {
            $this->error(__('Parameter %s can not be empty', ''));
        }
        $params = $this->preExcludeFields($params);

        if ($this->dataLimit && $this->dataLimitFieldAutoFill) {
            $params[$this->dataLimitField] = $this->auth->id;
        }
        $result = false;
        Db::startTrans();
        try {
            //是否采用模型验证
            if ($this->modelValidate) {
                $name = str_replace("\\model\\", "\\validate\\", get_class($this->model));
                $validate = is_bool($this->modelValidate) ? ($this->modelSceneValidate ? $name . '.add' : $name) : $this->modelValidate;
                $this->model->validateFailException()->validate($validate);
            }

            $params['booking_date'] = date('Y-m-d H:i:s');
            if (isset($params['checkin_date'])) {
                $params['checkin_date'] = format_sqldate($params['checkin_date'], 'Y-m-d H:i:s', '0000-00-00 00:00:00');
            }
            if (isset($params['checkout_date'])) {
                $params['checkout_date'] = format_sqldate($params['checkout_date'], 'Y-m-d H:i:s', '0000-00-00 00:00:00');
            }
            $params['createby'] = $this->auth->username;
            $params['createdate'] = date('Y-m-d H:i:s');
            $post_data = input('post.');
            $result = $this->model->allowField(true)->save($params);
            if ($result) {
                $booking_id = $this->model->getLastInsID();
                $booking_unittype = new Unittype();
                $confirmation_type = new Type();
                $binding_main = new Main();
                $binding_detail = new \app\admin\model\binding\Detail();
                $booking_detail = new Detail();
                $membership_detail = new \app\admin\model\membership\Detail();
                $hierarchy = new \app\admin\model\Hierarchy();
                $orders_extra = new Extra();
                $orders_bonus = new Bonus();
                $orders_van = new Van();
                $orders_addi = new Addi();
                $orders = new \app\admin\model\Orders();
                if (!empty($params['entitlement_year'])) {
                    if (!empty($params['room_detail'])) {
                        $room_details = json_decode($params['room_detail'], true);
                        $tmp = [];
                        foreach ($room_details as $room_detail) {
                            if (isset($tmp[$room_detail['unittype']])) {
                                $tmp[$room_detail['unittype']] += $room_detail['room_amount'];
                            } else {
                                $tmp[$room_detail['unittype']] = $room_detail['room_amount'];
                            }
                        }
                        foreach ($tmp as $u => $n) {
                            $booking_unittype->insert([
                                'booking_id' => $booking_id,
                                'unittype' => $u,
                                'room_amount' => $n
                            ]);
                        }
                    }
                }

                if (!empty($params['confirm_type'])) {
                    $confirmation_type->where('confirmation_type', $params['confirm_type'])
                        ->setInc('confirmation_counter');
                }

                if (!empty($params['mbs'])) {
                    $contract_no = $hierarchy->where('hierarchyid', $params['mbs'])->value('contract_no');
                    $binding_main->insert([
                        'booking_id' => $booking_id,
                        'module_code' => $contract_no
                    ]);
                    $booking_detail->insert([
                        'booking_id' => $booking_id,
                        'resort_id' => $params['Resort'],
                        'booking_detail_fullweek' => $params['msd_full'],
                        'booking_detail_midweek' => $params['msd_mid'],
                        'booking_detail_weekend' => $params['msd_weekend'],
                        'room' => $params['room'],
                        'createby' => $this->auth->username,
                        'createdate' => date('Y-m-d H:i:s'),
                    ]);
                    $booking_detail_id = $booking_detail->getLastInsID();
                    $orders_code = $membership_detail->where('ms_detail_id', $params['entitlement_year'])->value('orders_code');
                    $binding_detail->insert([
                        'booking_detail_id' => $booking_detail_id,
                        'orders_code' => $orders_code,
                    ]);
                    $membership_detail->where('ms_detail_id', $params['entitlement_year'])->update([
                        'status_booking' => $post_data['hStatusBooked'],
                        'updateby' => $this->auth->username,
                        'updatedate' => date('Y-m-d H:i:s'),
                    ]);
                }

                if (!empty($post_data['Extra_ID'])) {
                    foreach ($post_data['Extra_ID'] as $k => $val) {
                        $booking_detail->insert([
                            'booking_id' => $booking_id,
                            'resort_id' => $params['Resort'],
                            'booking_detail_extranight' => $post_data['Extra_Night'][$k],
                            'booking_detail_unittype' => $post_data['Extra_UnitType'][$k],
                            'room' => $post_data['Extra_RoomAmount'][$k],
                            'createby' => $this->auth->username,
                            'createdate' => date('Y-m-d H:i:s'),
                        ]);
                        $booking_detail_id = $booking_detail->getLastInsID();
                        $orders_code = $orders_extra->where('orders_extra_id', $val)->value('orders_code');
                        $binding_detail->insert([
                            'booking_detail_id' => $booking_detail_id,
                            'orders_code' => $orders_code,
                        ]);
                        $orders_extra->where('orders_extra_id', $val)->update([
                            'status_booking' => 'F',
                            'updateby' => $this->auth->username,
                            'updatedate' => date('Y-m-d H:i:s'),
                        ]);
                    }
                }

                if (!empty($post_data['Bonus_ID'])) {
                    foreach ($post_data['Bonus_ID'] as $k => $val) {
                        $booking_detail->insert([
                            'booking_id' => $booking_id,
                            'resort_id' => $params['Resort'],
                            'booking_detail_fullweek' => $post_data['Bonus_Full'][$k],
                            'booking_detail_midweek' => $post_data['Bonus_Mid'][$k],
                            'booking_detail_weekend' => $post_data['Bonus_Weekend'][$k],
                            'booking_detail_extranight' => $post_data['Bonus_Night'][$k],
                            'booking_detail_unittype' => $post_data['Bonus_UnitType'][$k],
                            'room' => $post_data['Bonus_RoomAmount'][$k],
                            'createby' => $this->auth->username,
                            'createdate' => date('Y-m-d H:i:s'),
                        ]);
                        $booking_detail_id = $booking_detail->getLastInsID();
                        $orders_code = $orders_bonus->where('orders_bonus_id', $val)->value('orders_code');
                        $binding_detail->insert([
                            'booking_detail_id' => $booking_detail_id,
                            'orders_code' => $orders_code,
                        ]);
                        $orders_bonus->where('orders_bonus_id', $val)->update([
                            'status_booking' => 'F',
                            'updateby' => $this->auth->username,
                            'updatedate' => date('Y-m-d H:i:s'),
                        ]);
                    }
                }

                if (!empty($post_data['Exchange_ID'])) {
                    foreach ($post_data['Exchange_ID'] as $k => $val) {
                        $booking_detail->insert([
                            'booking_id' => $booking_id,
                            'resort_id' => $params['Resort'],
                            'booking_detail_fullweek' => $post_data['To_Full'][$k],
                            'booking_detail_midweek' => $post_data['To_Mid'][$k],
                            'booking_detail_weekend' => $post_data['To_Weekend'][$k],
                            'booking_detail_unittype' => $post_data['To_UnitType'][$k],
                            'room' => $post_data['To_RoomAmount'][$k],
                            'createby' => $this->auth->username,
                            'createdate' => date('Y-m-d H:i:s'),
                        ]);
                        $booking_detail_id = $booking_detail->getLastInsID();
                        $orders_code = $orders_van->where('orders_van_id', $val)->value('orders_code');
                        $binding_detail->insert([
                            'booking_detail_id' => $booking_detail_id,
                            'orders_code' => $orders_code,
                        ]);
                        $orders_van->where('orders_van_id', $val)->update([
                            'status_booking' => 'F',
                            'updateby' => $this->auth->username,
                            'updatedate' => date('Y-m-d H:i:s'),
                        ]);
                    }
                }

                if (!empty($post_data['Addition_ID'])) {
                    foreach ($post_data['Addition_ID'] as $k => $val) {
                        $booking_detail->insert([
                            'booking_id' => $booking_id,
                            'resort_id' => $params['Resort'],
                            'createby' => $this->auth->username,
                            'createdate' => date('Y-m-d H:i:s'),
                        ]);
                        $booking_detail_id = $booking_detail->getLastInsID();
                        $orders_code = $orders_addi->where('orders_addi_id', $val)->value('orders_code');
                        $binding_detail->insert([
                            'booking_detail_id' => $booking_detail_id,
                            'orders_code' => $orders_code,
                        ]);
                        $orders_addi->where('orders_addi_id', $val)->update([
                            'status_booking' => 'F',
                            'updateby' => $this->auth->username,
                            'updatedate' => date('Y-m-d H:i:s'),
                        ]);
                    }
                }

                if (!empty($post_data['Orders_Code']) && !empty($post_data['Orders_ID'])) {
                    $Orders_Codes = array_unique($post_data['Orders_Code']);
                    $Orders_IDs = array_unique($post_data['Orders_ID']);
                    foreach ($Orders_Codes as $k => $orders_Code) {
                        $binding_main->insert([
                            'booking_id' => $booking_id,
                            'module_code' => $orders_Code
                        ]);
                        $order_count = CountOrderDetail($Orders_IDs[$k], 'PaidCompleted');
                        $Status = (array_sum($order_count) > 0) ? 'K' : 'F';
                        $orders->where('orders_id', $Orders_IDs[$k])->update([
                            'status_booking' => $Status,
                            'updateby' => $this->auth->username,
                            'updatedate' => date('Y-m-d H:i:s'),
                        ]);
                    }
                }
            }

            Db::commit();
        } catch (ValidateException|PDOException|Exception $e) {
            Db::rollback();
            $this->error($e->getMessage());
        }
        if ($result === false) {
            $this->error(__('No rows were inserted'));
        }
        $this->success();
    }

    /**
     * 编辑
     *
     * @param $ids
     * @return string
     * @throws DbException
     * @throws \think\Exception
     */
    public function edit($ids = null)
    {
        $row = $this->model->get($ids);
        if (!$row) {
            $this->error(__('No Results were found'));
        }
        $adminIds = $this->getDataLimitAdminIds();
        if (is_array($adminIds) && !in_array($row[$this->dataLimitField], $adminIds)) {
            $this->error(__('You have no permission'));
        }
        $booking_unittype_list = Unittype::where('booking_id', $ids)->select();

        if (false === $this->request->isPost()) {
            $this->view->assign('checkin_date', format_date($row['checkin_date'], 'd/m/Y H:i:s'));
            $this->view->assign('checkout_date', format_date($row['checkout_date'], 'd/m/Y H:i:s'));
            $confirm_type = '';
            if (!empty($row['confirmation_no'])) {
                $confirmation_no_arr = explode('/', $row['confirmation_no']);
                $confirm_type = $confirmation_no_arr[1] ?? '';
            }
            $this->view->assign('confirm_type', $confirm_type);
            $this->view->assign('confirmation_no', $row['confirmation_no']);
            $this->view->assign('memberid', $row['memberid']);

            $sql = 'SELECT
			BiD.orders_code		AS	Orders_Code
		FROM binding_detail BiD
			LEFT OUTER JOIN booking_detail BD ON BD.booking_detail_id=BiD.booking_detail_id
			LEFT OUTER JOIN booking B ON B.booking_id=BD.booking_id
		WHERE B.booking_id=' . $ids;
            $list = Db::query($sql);
            $Orders_Code_Data = [];
            if (!empty($list)) {
                foreach ($list as $item) {
                    switch ($item['Orders_Code'][0]) {
                        case 'm' :
                            $Orders_Code_Data['Membership'][] = $item['Orders_Code'];
                            break;
                        case 'a' :
                            $Orders_Code_Data['Addition'][] = $item['Orders_Code'];
                            break;
                        case 'e' :
                            $Orders_Code_Data['Extra'][] = $item['Orders_Code'];
                            break;
                        case 'v' :
                            $Orders_Code_Data['Exchange'][] = $item['Orders_Code'];
                            break;
                        case 'b' :
                            $Orders_Code_Data['Bonus'][] = $item['Orders_Code'];
                            break;
                    }
                }
            }

            $resort_id = Detail::where('booking_id', $ids)
                ->where('resort_id', '<>', '')
                ->value('resort_id');
            $resort_name = \app\admin\model\Resort::where('resortid', $resort_id)->value('resortname');

            $this->view->assign('Resort', $resort_id ?: 0);
            $this->view->assign('Resort_Name', $resort_name ?: '');


            $this->view->assign('booking_unittype_list', json_encode($booking_unittype_list));

            if (!empty($Orders_Code_Data['Membership'])) {
                $sql = "SELECT MD.*, P.unittype,P.packagename FROM membership_detail MD LEFT OUTER JOIN package P ON P.packageid=MD.packageid WHERE MD.orders_code='" . $Orders_Code_Data['Membership'][0] . "' ORDER BY MD.ms_detail_year";
                $mbs_list = Db::query($sql);
                $this->view->assign('mbs_list', $mbs_list[0] ?? []);
                $this->view->assign('mbs', $mbs_list[0]['hierarchyid'] ?? '');

                $sql = "
			SELECT
				BD.booking_detail_id			AS	Booking_Detail_ID,
				BD.booking_detail_fullweek		AS	Booking_FullWeek,
				BD.booking_detail_midweek		AS	Booking_MidWeek,
				BD.booking_detail_weekend		AS	Booking_Weekend,
				BD.room						AS	Room
			FROM booking_detail BD
				LEFT OUTER JOIN booking B ON B.booking_id=BD.booking_id
				LEFT OUTER JOIN binding_detail BiD ON BiD.booking_detail_id=BD.booking_detail_id
				LEFT OUTER JOIN membership_detail MSD ON MSD.orders_code=BiD.orders_code
			WHERE B.booking_id='" . $ids . "'
				AND MSD.orders_code='" . $Orders_Code_Data['Membership'][0] . "'
		";
                $booking_detail_data = Db::query($sql);
                $this->view->assign('booking_detail_data', $booking_detail_data[0] ?? []);
            } else {
                $this->view->assign('mbs', '');
            }

            if (!empty($Orders_Code_Data['Extra'])) {
                $sql = "
			SELECT
				ODE.orders_extra_id		AS	Orders_Extra_ID,
				OD.orders_id				AS	Orders_ID,
				OD.orders_code			AS	Orders_Code,
				BD.booking_detail_id		AS	Booking_detail_ID,
				BD.booking_detail_unittype	AS	Unit_Type,
				BD.room					AS	RoomAmount,
				BD.booking_detail_extranight AS	Extra_Night
			FROM orders_extra ODE
				LEFT OUTER JOIN orders OD ON OD.orders_id=ODE.orders_id
				LEFT OUTER JOIN binding_detail BiD ON BiD.orders_code=ODE.orders_code
				LEFT OUTER JOIN booking_detail BD ON BD.booking_detail_id=BiD.booking_detail_id
			
			WHERE ODE.orders_code in ('" . implode('\',\'', $Orders_Code_Data['Extra']) . "')
			";


                $this->view->assign('extra_data', Db::query($sql));
            }

            if (!empty($Orders_Code_Data['Bonus'])) {
                $sql = "
			SELECT
			ODB.orders_bonus_id			AS	Orders_Bonus_ID,
			OD.orders_id					AS	Orders_ID,
			OD.orders_code				AS	Orders_Code,
			ODB.bonus_type				AS	Bonus_Type,
			BD.booking_detail_id			AS	Booking_detail_ID,
			BD.booking_detail_unittype		AS	Unit_Type,
			BD.booking_detail_fullweek		AS	Full_Week,
			BD.booking_detail_midweek		AS	Mid_Week,
			BD.booking_detail_weekend		AS	Weekend,
			BD.booking_detail_extranight	AS	Extra_Night,
			BD.room						AS	RoomAmount
			FROM orders_bonus ODB
				LEFT OUTER JOIN orders OD ON OD.orders_id=ODB.orders_id
				LEFT OUTER JOIN binding_detail BiD ON BiD.orders_code=ODB.orders_code
				LEFT OUTER JOIN booking_detail BD ON BD.booking_detail_id=BiD.booking_detail_id
			
			WHERE ODB.orders_code in('" . implode('\',\'', $Orders_Code_Data['Bonus']) . "')";
                $this->view->assign('bonus_data', Db::query($sql));
            }

            if (!empty($Orders_Code_Data['Exchange'])) {
                $sql = "
			SELECT
			ODX.orders_van_id			AS	Orders_Exchange_ID,
			OD.orders_id				AS	Orders_ID,
			OD.orders_code			AS	Orders_Code,
			ODX.from_contract			AS	Contract_No,
			ODX.from_year			AS	Entitlement_Year,
			ODX.from_unittype			AS	F_Unit_Type,
			ODX.from_fullweek			AS	F_Full_Week,
			ODX.from_midweek			AS	F_Mid_Week,
			ODX.from_weekend		AS	F_Weekend,
			ODX.resortid				AS	T_Resort,
			BD.booking_detail_id		AS	Booking_detail_ID,
			BD.booking_detail_unittype	AS	T_Unit_Type,
			BD.booking_detail_fullweek	AS	T_Full_Week,
			BD.booking_detail_midweek	AS	T_Mid_Week,
			BD.booking_detail_weekend	AS	T_Weekend,
			BD.room					AS	T_RoomAmount
			FROM orders_van ODX
				LEFT OUTER JOIN orders OD ON OD.orders_id=ODX.orders_id
				LEFT OUTER JOIN binding_detail BiD ON BiD.orders_code=ODX.orders_code
				LEFT OUTER JOIN booking_detail BD ON BD.booking_detail_id=BiD.booking_detail_id
			WHERE ODX.orders_code in ('" . implode('\',\'', $Orders_Code_Data['Exchange']) . "')";
                $this->view->assign('exchange_data', Db::query($sql));
            }

            if (!empty($Orders_Code_Data['Addition'])) {
                $sql = "			
			SELECT
				ODA.orders_addi_id		AS	Orders_Addition_ID,
				OD.orders_id				AS	Orders_ID,
				OD.orders_code			AS	Orders_Code,
				ODA.addi_rate_name		AS	Addition_Name,
				ODA.addi_unit				AS	Unit,
				BD.booking_detail_id		AS	Booking_detail_ID
			FROM orders_addi ODA
				LEFT OUTER JOIN orders OD ON OD.orders_id=ODA.orders_id
				LEFT OUTER JOIN binding_detail BiD ON BiD.orders_code=ODA.orders_code
				LEFT OUTER JOIN booking_detail BD ON BD.booking_detail_id=BiD.booking_detail_id
			WHERE ODA.orders_code in ('" . implode('\',\'', $Orders_Code_Data['Addition']) . "')
			";
                $this->view->assign('addition_data', Db::query($sql));
            }


            $this->view->assign('row', $row);
            return $this->view->fetch();
        }
        $params = $this->request->post('row/a');
        if (empty($params)) {
            $this->error(__('Parameter %s can not be empty', ''));
        }
        $params = $this->preExcludeFields($params);
        $result = false;
        Db::startTrans();
        try {
            //是否采用模型验证
            if ($this->modelValidate) {
                $name = str_replace("\\model\\", "\\validate\\", get_class($this->model));
                $validate = is_bool($this->modelValidate) ? ($this->modelSceneValidate ? $name . '.edit' : $name) : $this->modelValidate;
                $row->validateFailException()->validate($validate);
            }
            if (isset($params['checkin_date'])) {
                $params['checkin_date'] = format_sqldate($params['checkin_date'], 'Y-m-d H:i:s', '0000-00-00 00:00:00');
            }
            if (isset($params['checkout_date'])) {
                $params['checkout_date'] = format_sqldate($params['checkout_date'], 'Y-m-d H:i:s', '0000-00-00 00:00:00');
            }
            $params['updateby'] = $this->auth->username;
            $params['updatedate'] = date('Y-m-d H:i:s');

            $post_data = input('post.');
            $result = $row->allowField(true)->save($params);
            if ($result) {
                $booking_id = $ids;
                $booking_unittype = new Unittype();
                $confirmation_type = new Type();
                $binding_main = new Main();
                $binding_detail = new \app\admin\model\binding\Detail();
                $booking_detail = new Detail();
                $membership_detail = new \app\admin\model\membership\Detail();
                $hierarchy = new \app\admin\model\Hierarchy();
                $orders_extra = new Extra();
                $orders_bonus = new Bonus();
                $orders_van = new Van();
                $orders_addi = new Addi();
                $orders = new \app\admin\model\Orders();

                $has_booking_unittype_ids = [];
                if (!empty($booking_unittype_list)) {
                    $has_booking_unittype_ids = array_column($booking_unittype_list, 'booking_unittype_id');
                }
                $update_booking_unittype_ids = [];
                if (!empty($params['room_detail'])) {
                    $room_details = json_decode($params['room_detail'], true);
                    $tmp = [];
                    foreach ($room_details as $room_detail) {
                        if (!empty($room_detail['booking_unittype_id'])) {
                            $update_booking_unittype_ids[] = $room_detail['booking_unittype_id'];
                        }

                        if (isset($tmp[$room_detail['unittype']])) {
                            $tmp[$room_detail['unittype']] += $room_detail['room_amount'];
                        } else {
                            $tmp[$room_detail['unittype']] = $room_detail['room_amount'];
                        }
                    }
                    foreach ($tmp as $u => $n) {
                        $h = $booking_unittype->where('booking_id', $booking_id)
                            ->where('unittype', $u)
                            ->count();
                        if (empty($h)) {
                            $booking_unittype->insert([
                                'booking_id' => $booking_id,
                                'unittype' => $u,
                                'room_amount' => $n
                            ]);
                        } else {
                            $booking_unittype->where('booking_id', $booking_id)
                                ->where('unittype', $u)
                                ->setInc('room_amount', $n);
                        }
                    }
                }
                $diff_booking_unittype_ids = array_diff($has_booking_unittype_ids, $update_booking_unittype_ids);
                if (!empty($diff_booking_unittype_ids)) {
                    $booking_unittype->whereIn('booking_unittype_id', $diff_booking_unittype_ids)->delete();
                }

                if (!empty($post_data['BD_ID'])) {
                    $booking_detail->where('booking_detail_id', $post_data['BD_ID'])->update([
                        'booking_detail_fullweek' => $params['msd_full'],
                        'booking_detail_midweek' => $params['msd_mid'],
                        'booking_detail_weekend' => $params['msd_weekend'],
                        'room' => $params['room'],
                        'updateby' => $this->auth->username,
                        'updatedate' => date('Y-m-d H:i:s'),
                    ]);

                    $update_FW = (int)$params["msd_full"][0] * (int)$params["room"];
                    $update_MW = (int)$params["msd_mid"][0] * (int)$params["room"];
                    $update_WE = (int)$params["msd_weekend"][0] * (int)$params["room"];

                    $membership_detail->where('ms_detail_id', $post_data['ms_id'])
                        ->setInc('used_fullweek', $update_FW - $params['hDefaultFW']);
                    $membership_detail->where('ms_detail_id', $post_data['ms_id'])
                        ->setInc('used_midweek', $update_MW - $params['hDefaultMW']);
                    $membership_detail->where('ms_detail_id', $post_data['ms_id'])
                        ->setInc('used_weekend', $update_WE - $params['hDefaultWE']);

                    $sql = "
				SELECT
					MBSD.total_week 							AS	Week_per_Year,
					MBSD.used_fullweek 						AS	MSB_Detail_UsedFW,
					MBSD.used_midweek  						AS	MSB_Detail_UsedMW,
					MBSD.used_weekend 						AS	MSB_Detail_UsedWE,
					SUM(BD.booking_detail_fullweek*BD.room) 		AS	Booking_Full_Week,
					SUM(BD.booking_detail_midweek*BD.room) 		AS	Booking_Mid_Week,
					SUM(BD.booking_detail_weekend*BD.room) 	AS	Booking_Weekend
				FROM membership_detail MBSD
					LEFT OUTER JOIN binding_detail BiD ON BiD.orders_code=MBSD.orders_code
					LEFT OUTER JOIN booking_detail BD ON BD.booking_detail_id=BiD.booking_detail_id
				WHERE MBSD.ms_detail_id='" . $post_data['ms_id'] . "'
					AND	(BD.booking_status='N' OR ISNULL(BD.booking_status) OR BD.booking_status = '')
				GROUP BY MBSD.ms_detail_year
			";
                    $rs = Db::query($sql);
                    $Available = availableTime($rs[0] ?? []);
                    $Status = (array_sum($Available) > 0) ? 'K' : 'F';
                    $membership_detail->where('ms_detail_id', $post_data['ms_id'])
                        ->update([
                            'status_booking' => $Status,
                            'updateby' => $this->auth->username,
                            'updatedate' => date('Y-m-d H:i:s'),
                        ]);
                }

                if (!empty($post_data['Extra_BD_ID'])){
                    foreach ($post_data['Extra_BD_ID'] as $k => $booking_detail_id){
                        $booking_detail->where('booking_detail_id',$booking_detail_id)->update([
                            'booking_detail_extranight' => $post_data['Extra_Night'][$k],
                            'booking_detail_unittype' => $post_data['Extra_UnitType'][$k],
                            'room' => $post_data['Extra_RoomAmount'][$k],
                            'updateby' => $this->auth->username,
                            'updatedate' => date('Y-m-d H:i:s'),
                        ]);
                    }
                }

                if (!empty($post_data['Bonus_BD_ID'])){
                    foreach ($post_data['Bonus_BD_ID'] as $k => $booking_detail_id){
                        $booking_detail->where('booking_detail_id',$booking_detail_id)->update([
                            'booking_detail_fullweek' => $post_data['Bonus_Full'][$k],
                            'booking_detail_midweek' => $post_data['Bonus_Mid'][$k],
                            'booking_detail_weekend' => $post_data['Bonus_Weekend'][$k],
                            'booking_detail_extranight' => $post_data['Bonus_Night'][$k],
                            'booking_detail_unittype' => $post_data['Bonus_UnitType'][$k],
                            'room' => $post_data['Bonus_RoomAmount'][$k],
                            'updateby' => $this->auth->username,
                            'updatedate' => date('Y-m-d H:i:s'),
                        ]);
                    }
                }

                if (!empty($post_data['Exchange_BD_ID'])){
                    foreach ($post_data['Exchange_BD_ID'] as $k => $booking_detail_id){
                        $booking_detail->where('booking_detail_id',$booking_detail_id)->update([
                            'booking_detail_fullweek' => $post_data['To_Full'][$k],
                            'booking_detail_midweek' => $post_data['To_Mid'][$k],
                            'booking_detail_weekend' => $post_data['To_Weekend'][$k],
                            'booking_detail_unittype' => $post_data['To_UnitType'][$k],
                            'room' => $post_data['To_RoomAmount'][$k],
                            'updateby' => $this->auth->username,
                            'updatedate' => date('Y-m-d H:i:s'),
                        ]);
                    }
                }
            }
            Db::commit();
        } catch (ValidateException|PDOException|Exception $e) {
            Db::rollback();
            $this->error($e->getMessage());
        }
        if (false === $result) {
            $this->error(__('No rows were updated'));
        }
        $this->success();
    }

    /**
     * @return Json
     */
    public function check_available_week()
    {
        $ms_detail_id = input('ms_detail_id');
        $data = [];
        if (!empty($ms_detail_id)) {
            $sql = "SELECT IFNULL(P.packagename,'-') as packagename FROM membership_detail M LEFT OUTER JOIN package P ON P.packageid=M.packageid WHERE M.ms_detail_id='" . $ms_detail_id . "'";
            $rs = Db::query($sql);
            if (!empty($rs[0]['packagename'])) {
                $data['membership_type'] = $rs[0]['packagename'];
            } else {
                $data['membership_type'] = '-';
            }
            $sql = "SELECT
					MBSD.total_week 									AS	total_week,
					MBSD.used_fullweek 								AS	used_fullweek,
					MBSD.used_midweek  								AS	used_midweek,
					MBSD.used_weekend 								AS	used_weekend,
					SUM(BD.booking_detail_fullweek*BD.room)		AS	booked_fullweek,
					SUM(BD.booking_detail_midweek*BD.room)		AS	booked_midweek,
					SUM(BD.booking_detail_weekend*BD.room) 	AS	booked_weekend
				FROM membership_detail MBSD
					LEFT OUTER JOIN binding_detail BiD ON 
						BiD.orders_code=MBSD.orders_code
					LEFT OUTER JOIN booking_detail BD ON 
						BD.booking_detail_id=BiD.booking_detail_id
						AND (BD.booking_status='N' OR ISNULL(BD.booking_status))
				WHERE MBSD.ms_detail_id='" . $ms_detail_id . "'
				GROUP BY MBSD.ms_detail_year";
            $rs = Db::query($sql);
            $row = $rs[0] ?? [];
            $Total = $row['total_week'];

            $LeftMidweek = 0;
            $LeftWeekend = 0;

            $UsedFullweek = $row['used_fullweek'] + $row['booked_fullweek'];
            $UsedMidweek = $row['used_midweek'] + $row['booked_midweek'];
            $UsedWeekend = $row['used_weekend'] + $row['booked_weekend'];

            if (isset($_REQUEST['used_FW']) and ($_REQUEST['used_FW'] != ""))
                $UsedFullweek -= $_REQUEST['used_FW'];
            if (isset($_REQUEST['used_MW']) and ($_REQUEST['used_MW'] != ""))
                $UsedMidweek -= $_REQUEST['used_MW'];
            if (isset($_REQUEST['used_WE']) and ($_REQUEST['used_WE'] != ""))
                $UsedWeekend -= $_REQUEST['used_WE'];

            $Total = $Total - $UsedFullweek;
            while ($Total > 0 and ($UsedMidweek > 0 or $UsedWeekend > 0)) {
                if ($UsedWeekend > 0 and $UsedMidweek == 0) {
                    $UsedWeekend--;
                    $LeftMidweek++;
                }
                if ($UsedMidweek > 0 and $UsedWeekend == 0) {
                    $UsedMidweek--;
                    $LeftWeekend++;
                }
                if ($UsedMidweek > 0 and $UsedWeekend > 0) {
                    $UsedMidweek--;
                    $UsedWeekend--;
                }
                $Total--;
            }
            $NeedFullweek = 0;
            if (!empty($_REQUEST['Fullweek'])) {
                $NeedFullweek = $_REQUEST['Fullweek'] * $_REQUEST['RoomAmount'];
            }
            $NeedMidweek = 0;
            if (!empty($_REQUEST['Midweek'])) {
                $NeedMidweek = $_REQUEST['Midweek'] * $_REQUEST['RoomAmount'];
            }
            $NeedWeekend = 0;
            if (!empty($_REQUEST['Weekend'])) {
                $NeedWeekend = $_REQUEST['Weekend'] * $_REQUEST['RoomAmount'];
            }


            $data['ava_full'] = $Total;
            $data['ava_mid'] = $LeftMidweek;
            $data['ava_weekend'] = $LeftWeekend;

            if (($NeedFullweek <= 0 or $NeedFullweek == "") and ($NeedMidweek <= 0 or $NeedMidweek == "") and ($NeedWeekend <= 0 or $NeedWeekend == "") and ($row['used_fullweek'] <= 0 or $row['used_fullweek'] == "") and ($row['used_midweek'] <= 0 or $row['used_midweek'] == "") and ($row['used_weekend'] <= 0 or $row['used_weekend'] == "")) {
                $data['hStatusBooked'] = 'N';
            } else {
                $data['hStatusBooked'] = 'K';
            }

            if ($Total < $NeedFullweek) {
                $data['error_msg'] = __("Total week lefts less than Full week input");
                $data['msd_full'] = floor($Total / $_REQUEST['RoomAmount']);
                $data['msd_mid'] = floor($LeftMidweek / $_REQUEST['RoomAmount']);
                $data['msd_weekend'] = floor($LeftWeekend / $_REQUEST['RoomAmount']);
                $data['hStatusBooked'] = 'F';
            } else {
                $Total = $Total - $NeedFullweek;
                if ($Total <= 0) {
                    $data['hStatusBooked'] = 'F';
                }
                while ($Total > 0) {
                    $LeftMidweek++;
                    $LeftWeekend++;
                    $Total--;
                }
                if ($NeedMidweek > 0) {
                    $LeftMidweek = $LeftMidweek - $UsedMidweek;
                    if ($LeftMidweek < $NeedMidweek) {
                        $data['error_msg'] = __("Mid week lefts less than Mid week input");
                        if ($LeftMidweek >= 0) {
                            $data['msd_mid'] = floor($LeftMidweek / $_REQUEST['RoomAmount']);
                        } else {
                            $data['msd_mid'] = 0;
                        }
                    }
                }
                if ($NeedWeekend > 0) {
                    $LeftWeekend = $LeftWeekend - $UsedWeekend;
                    if ($LeftWeekend < $NeedWeekend) {
                        $data['error_msg'] = __("Weekend lefts less than Weekend input");
                        if ($LeftWeekend >= 0) {
                            $data['msd_weekend'] = floor($LeftWeekend / $_REQUEST['RoomAmount']);
                        } else {
                            $data['msd_weekend'] = 0;
                        }
                    }
                }
                if ($LeftWeekend <= $NeedWeekend and $LeftMidweek <= $NeedMidweek) {
                    $data['hStatusBooked'] = 'F';
                }
            }
        }
        return json($data);
    }
}
