<?php

namespace app\admin\controller;

use app\admin\model\membership\Detail;
use app\common\controller\Backend;
use fast\Encrypt;
use think\Db;
use think\db\exception\DataNotFoundException;
use think\db\exception\ModelNotFoundException;
use think\Exception;
use think\exception\DbException;
use think\exception\PDOException;
use think\exception\ValidateException;
use think\response\Json;

/**
 *
 *
 * @icon fa fa-circle-o
 */
class Member extends Backend
{

    /**
     * Member模型对象
     * @var \app\admin\model\Member
     */
    protected $model = null;
    protected $searchFields = ['memberid', 'username', 'login_name', 'login_surname', 'fullname2', 'fullsurname2','title'];
    protected $relationSearch = true;
    protected $modelSceneValidate = true;
    protected $modelValidate = true;
    protected $selectpageFields = "memberid,username,login_name,login_surname,fullname2,fullsurname2,title";

    public function _initialize()
    {
        parent::_initialize();
        $this->model = new \app\admin\model\Member;
        $this->view->assign("titleList", $this->model->getTitleList());
        $this->view->assign("seasonTypeList", $this->model->getSeasonTypeList());
        $this->view->assign("yearList", $this->model->getYearList());
    }


    /**
     * 查看
     *
     * @return string|Json
     * @throws \think\Exception
     * @throws DbException
     */
    public function index()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            return $this->view->fetch();
        }
        //如果发送的来源是 Selectpage，则转发到 Selectpage
        if ($this->request->request('keyField')) {
            return $this->selectpage();
        }
        [$where, $sort, $order, $offset, $limit] = $this->buildparams();
        $list = $this->model
            ->where($where)
            ->group('`member`.`memberid`')
            ->with([
                'country' => function ($query) {
                    $query->withField('country_name,countryid');
                },
                'hierarchy' => function ($query) {
                    $query->withField('membercode,partnerid,packageid,servicetype,season_type,contract_no');
                },
                'marketer' => function ($query) {
                    $query->withField('login_name');
                },
                'language' => function ($query) {
                    $query->withField('language_name');
                }
            ])
            ->join('package', 'hierarchy.packageid=package.packageid', 'left')
            ->order($sort, $order)
            ->paginate($limit);

        $rows = $list->items();
        if (!empty($rows)){
            foreach ($rows as &$row){
                if (empty($row['title'])){
                    $row['title'] = '';
                }
                if (empty($row['title2'])){
                    $row['title2'] = '';
                }
            }
        }

        $result = ['total' => $list->total(), 'rows' => $rows];
        return json($result);
    }

    /**
     * 删除
     *
     * @param $ids
     * @return void
     * @throws DbException
     * @throws DataNotFoundException
     * @throws ModelNotFoundException
     */
    public function del($ids = null)
    {
        if (false === $this->request->isPost()) {
            $this->error(__("Invalid parameters"));
        }
        $ids = $ids ?: $this->request->post("ids");
        if (empty($ids)) {
            $this->error(__('Parameter %s can not be empty', 'ids'));
        }
        $pk = $this->model->getPk();
        $adminIds = $this->getDataLimitAdminIds();
        if (is_array($adminIds)) {
            $this->model->where($this->dataLimitField, 'in', $adminIds);
        }
        $list = $this->model->where($pk, 'in', $ids)->select();

        $count = 0;
        Db::startTrans();
        try {
            foreach ($list as $item) {
                $memberid = $item[$pk];
                $sql = <<<SQL
                SELECT
						MB.memberid			AS	Member_ID,
						MSD.paid_status		AS	Paid_Status,
						MSD.ms_detail_paid	AS	Paid
						FROM member MB
							LEFT OUTER JOIN hierarchy MS ON MS.memberid=MB.memberid
							LEFT OUTER JOIN membership_detail MSD ON MSD.hierarchyid=MS.hierarchyid
						WHERE MB.memberid='{$memberid}'
							AND MSD.paid_status <> 'N'
							AND MSD.ms_detail_paid <> 'N'
SQL;
                $result = Db::query($sql);
                if (!empty($result)) {
                    throw new Exception('Unable to delete:' . $memberid);
                }

                $sql = <<<SQL
                SELECT
							COUNT(OD.orders_id)		AS	Counter
							FROM orders OD
							WHERE OD.memberid='{$memberid}'
								AND (OD.status_new<>'N'
								OR NOT ISNULL(OD.status_paid)
								OR OD.paid_completed<>'N')
SQL;
                $result = Db::query($sql);
                if (!empty($result[0]['Counter'])) {
                    throw new Exception('Unable to delete:' . $memberid);
                }

                # Delete member.
//                $sql = <<<SQL
//            	DELETE FROM member
//								WHERE memberid='{$memberid}'
//
//SQL;
//                Db::execute($sql);

                # Delete membership.
                $sql = <<<SQL
                DELETE FROM hierarchy
								WHERE memberid='{$memberid}'						
SQL;
                Db::execute($sql);

                # Delete membership detail.
                $sql = <<<SQL
                DELETE FROM membership_detail
								WHERE memberid='{$memberid}'
											
SQL;
                Db::execute($sql);

                # List orders.
                $sql = <<<SQL
                SELECT
								OD.orders_id		AS	Orders_ID
								FROM orders OD
								WHERE OD.memberid='{$memberid}'
SQL;
                $result = Db::query($sql);
                if (!empty($result)) {
                    foreach ($result as $orders_v) {
                        $orders_id = $orders_v['Orders_ID'];
                        # Delete order addition.
                        $sql = <<<SQL
                            DELETE FROM orders_addi
									WHERE orders_addi.orders_id='{$orders_id}'
SQL;
                        Db::execute($sql);

                        # Delete order bonus.
                        $sql = <<<SQL
                            DELETE FROM orders_bonus
									WHERE orders_bonus.orders_id='{$orders_id}'
SQL;
                        Db::execute($sql);

                        # Delete order extra night.
                        $sql = <<<SQL
                            DELETE FROM orders_extra
									WHERE orders_extra.orders_id='{$orders_id}'
SQL;
                        Db::execute($sql);

                        # Delete order Exchange.
                        $sql = <<<SQL
                            DELETE FROM orders_van
									WHERE orders_van.orders_id='{$orders_id}'
SQL;
                        Db::execute($sql);
                    }
                }

                $sql = <<<SQL
                DELETE FROM orders
								WHERE memberid='{$memberid}'											
SQL;
                Db::execute($sql);
                $count += $item->delete();
            }
            Db::commit();
        } catch (PDOException|Exception $e) {
            Db::rollback();
            $this->error($e->getMessage());
        }
        if ($count) {
            $this->success();
        }
        $this->error(__('No rows were deleted'));
    }


    /**
     * 隐藏
     *
     * @param $ids
     * @return void
     * @throws DbException
     * @throws DataNotFoundException
     * @throws ModelNotFoundException
     */
    public function hidden($ids = null)
    {
        if (false === $this->request->isPost()) {
            $this->error(__("Invalid parameters"));
        }
        $ids = $ids ?: $this->request->post("ids");
        if (empty($ids)) {
            $this->error(__('Parameter %s can not be empty', 'ids'));
        }
        $pk = $this->model->getPk();
        $adminIds = $this->getDataLimitAdminIds();
        if (is_array($adminIds)) {
            $this->model->where($this->dataLimitField, 'in', $adminIds);
        }
        Db::startTrans();
        try {
            foreach ($ids as $id) {
                $this->model->where($pk, $id)->update([
                    'hidden' => 1
                ]);
            }
            Db::commit();
            $this->success();
        } catch (PDOException|Exception $e) {
            Db::rollback();
            $this->error($e->getMessage());
        }
    }

    /**
     * 显示
     *
     * @param $ids
     * @return void
     * @throws DbException
     * @throws DataNotFoundException
     * @throws ModelNotFoundException
     */
    public function unhidden($ids = null)
    {
        if (false === $this->request->isPost()) {
            $this->error(__("Invalid parameters"));
        }
        $ids = $ids ?: $this->request->post("ids");
        if (empty($ids)) {
            $this->error(__('Parameter %s can not be empty', 'ids'));
        }
        $pk = $this->model->getPk();
        $adminIds = $this->getDataLimitAdminIds();
        if (is_array($adminIds)) {
            $this->model->where($this->dataLimitField, 'in', $adminIds);
        }
        Db::startTrans();
        try {
            foreach ($ids as $id) {
                $this->model->where($pk, $id)->update([
                    'hidden' => 0
                ]);
            }
            Db::commit();
            $this->success();
        } catch (PDOException|Exception $e) {
            Db::rollback();
            $this->error($e->getMessage());
        }
    }

    /**
     * 添加
     *
     * @return string
     * @throws \think\Exception
     */
    public function add()
    {
        if (false === $this->request->isPost()) {
            $member_type = input('member_type', 'M');
            $this->view->assign('member_type', $member_type);
            return $this->view->fetch();
        }
        $params = $this->request->post('row/a');
        if (empty($params)) {
            $this->error(__('Parameter %s can not be empty', ''));
        }
        $params = $this->preExcludeFields($params);

        if ($this->dataLimit && $this->dataLimitFieldAutoFill) {
            $params[$this->dataLimitField] = $this->auth->id;
        }

        $result = false;
        Db::startTrans();
        try {
            //是否采用模型验证
            if ($this->modelValidate) {
                $name = str_replace("\\model\\", "\\validate\\", get_class($this->model));
                $validate = is_bool($this->modelValidate) ? ($this->modelSceneValidate ? $name . '.add' : $name) : $this->modelValidate;
                $this->model->validateFailException()->validate($validate);
            }
            // 修改字段
            if (!empty($params['birthday'])) {
                $birthdays = explode('/', $params['birthday']);
                $params['birthday'] = $birthdays[2] . '-' . $birthdays[1] . '-' . $birthdays[0];
            } else {
                $params['birthday'] = '0000-00-00';
            }
            if (!empty($params['birthday2'])) {
                $birthdays = explode('/', $params['birthday2']);
                $params['birthday2'] = $birthdays[2] . '-' . $birthdays[1] . '-' . $birthdays[0];
            } else {
                $params['birthday2'] = '0000-00-00';
            }
            if (!empty($params['passwords'])) {
                $encrypt = new Encrypt();
                $params['passwords'] = $encrypt->encode($params['passwords']);
            }
            // 补充字段
            $params['hidden'] = 0;
            $params['user_priv'] = 'member';
            $params['updateby_member'] = 0;
            $params['createby'] = $this->auth->username;
            $params['createdate'] = date('Y-m-d H:i:s');

            $result = $this->model->allowField(true)->save($params);
            if (!$result) {
                throw new Exception(__('Add member failed'));
            }
            $memberid = $this->model->getLastInsID();
            if (!empty($params['membership'])) {
                $hierarchy = new \app\admin\model\Hierarchy();
                $package = new \app\admin\model\Package();
                $membership_detail = new Detail();
                $memberships = json_decode($params['membership'], true);
                foreach ($memberships as $membership) {
                    if (empty($membership['packageid'])) {
                        continue;
                    }
                    if (!empty($membership['contact_date'])) {
                        $birthdays = explode('/', $membership['contact_date']);
                        $membership['contact_date'] = $birthdays[2] . '-' . $birthdays[1] . '-' . $birthdays[0];
                    } else {
                        $membership['contact_date'] = '0000-00-00';
                    }
                    $membership['memberid'] = $memberid;
                    $membership['hidden'] = 0;
                    $membership['contract_status'] = 'use';
                    $membership['createby'] = $this->auth->username;
                    $membership['createdate'] = date('Y-m-d H:i:s');
                    $hierarchyid = $hierarchy->allowField(true)->insert($membership, false, true);
                    if (empty($hierarchyid)) {
                        throw new Exception(__('Add hierarchy failed'));
                    }
                    $service_type = -1;
                    switch ($membership['servicetype']) {
                        case "Full" :
                            $service_type = 2;
                            break;
                        case "Odd" :
                            $service_type = 1;
                            break;
                        case "Even" :
                            $service_type = 0;
                            break;
                    }

                    $membership['total_week'] = $package->where('packageid', $membership['packageid'])->value('weeks', 0);
                    $membership['ms_contract_status'] = 'use';
                    $membership['hierarchyid'] = $hierarchyid;
                    $membership['memberid'] = $memberid;
                    if (!empty($membership['FYO']) && !empty($membership['LYO'])) {
                        for ($i = $membership['FYO']; $i <= $membership['LYO']; $i++) {
                            if ($i % 2 == $service_type || $service_type == 2) {
                                $membership['ms_detail_year'] = $i;
                                $ms_detail_id = $membership_detail->allowField(true)->insert($membership, false, true);
                                if (empty($ms_detail_id)) {
                                    throw new Exception(__('Add membership detail failed'));
                                }
                                $membership_detail->where('ms_detail_id', $ms_detail_id)->update([
                                    'orders_code' => sprintf('m%011d', $ms_detail_id)
                                ]);
                            }
                        }
                    }
                }
            }
            Db::commit();
        } catch (ValidateException|PDOException|Exception $e) {
            Db::rollback();
            $this->error($e->getMessage());
        }
        if ($result === false) {
            $this->error(__('No rows were inserted'));
        }
        $this->success();
    }

    /**
     * 编辑
     *
     * @param $ids
     * @return string
     * @throws DbException
     * @throws \think\Exception
     */
    public function edit($ids = null)
    {
        $row = $this->model->get($ids);
        if (!$row) {
            $this->error(__('No Results were found'));
        }
        $adminIds = $this->getDataLimitAdminIds();
        if (is_array($adminIds) && !in_array($row[$this->dataLimitField], $adminIds)) {
            $this->error(__('You have no permission'));
        }
        $hierarchy = new \app\admin\model\Hierarchy();
        $row_membership = $hierarchy->field('hierarchyid,memberid,packageid,partnerid,membercode,season_type,FYO,LYO,hidden,completdue,complet_act,first_maintfee_due,contract_no,contact_date,servicetype,remarks,paid,contract_status')
            ->where('memberid', $ids)
            ->select();
        if (!empty($row_membership)) {
            foreach ($row_membership as &$item) {
                if (!empty($item->contact_date)) {
                    $birthdays = explode('-', $item->contact_date);
                    $item->contact_date = $birthdays[2] . '/' . $birthdays[1] . '/' . $birthdays[0];
                }
            }
        }
        if (false === $this->request->isPost()) {
            if (!empty($row['birthday'])) {
                $birthdays = explode('-', $row['birthday']);
                $row['birthday'] = $birthdays[2] . '/' . $birthdays[1] . '/' . $birthdays[0];
            }
            if (!empty($row['birthday2'])) {
                $birthdays = explode('-', $row['birthday2']);
                $row['birthday2'] = $birthdays[2] . '/' . $birthdays[1] . '/' . $birthdays[0];
            }
            $row['membership'] = json_encode($row_membership);

            $member_password = $row['passwords'];
            $encrypt = new Encrypt();
            $mpass = $encrypt->decode($member_password);
            if (empty($mpass)) {
                $mpass = crypt_md5($member_password);
            }
            $row['old_password'] = $mpass;
            $this->view->assign('row', $row);
            $this->view->assign('member_type', $row['member_type']);
            return $this->view->fetch();
        }
        $params = $this->request->post('row/a');
        if (empty($params)) {
            $this->error(__('Parameter %s can not be empty', ''));
        }
        $params = $this->preExcludeFields($params);
        $result = false;
        Db::startTrans();
        try {
            //是否采用模型验证
            if ($this->modelValidate) {
                $name = str_replace("\\model\\", "\\validate\\", get_class($this->model));
                $validate = is_bool($this->modelValidate) ? ($this->modelSceneValidate ? $name . '.edit' : $name) : $this->modelValidate;
                $row->validateFailException()->validate($validate);
            }
            // 修改字段
            if (!empty($params['birthday'])) {
                $birthdays = explode('/', $params['birthday']);
                $params['birthday'] = $birthdays[2] . '-' . $birthdays[1] . '-' . $birthdays[0];
            } else {
                $params['birthday'] = '0000-00-00';
            }
            if (!empty($params['birthday2'])) {
                $birthdays = explode('/', $params['birthday2']);
                $params['birthday2'] = $birthdays[2] . '-' . $birthdays[1] . '-' . $birthdays[0];
            } else {
                $params['birthday2'] = '0000-00-00';
            }
            if (!empty($params['passwords'])) {
                $encrypt = new Encrypt();
                $params['passwords'] = $encrypt->encode($params['passwords']);
            } else {
                unset($params['passwords']);
            }
            // 补充字段
//            $params['hidden'] = 0;
//            $params['user_priv'] = 'member';
            $params['updateby_member'] = 0;
            $params['updateby'] = $this->auth->username;
            $params['updatedate'] = date('Y-m-d H:i:s');

            $result = $row->allowField(true)->save($params);
            if (!$result) {
                throw new Exception(__('Update member failed'));
            }
            $memberid = $ids;
            if (!empty($params['membership'])) {
                $hierarchy = new \app\admin\model\Hierarchy();
                $package = new \app\admin\model\Package();
                $membership_detail = new Detail();
                $memberships = json_decode($params['membership'], true);
                // 删除已经删除后的Hierarchy
                if (!empty($row_membership)) {
                    $has_hierarchyids = array_column($row_membership, 'hierarchyid');
                    $update_hierarchyids = array_filter(array_column($memberships, 'hierarchyid'));
                    $delete_hierarchyids = array_diff($has_hierarchyids, $update_hierarchyids);
                    if (!empty($delete_hierarchyids)) {
                        $hierarchy->where('memberid', $memberid)
                            ->whereIn('hierarchyid', $delete_hierarchyids)
                            ->delete();
                        $membership_detail->where('memberid', $memberid)
                            ->whereIn('hierarchyid', $delete_hierarchyids)
                            ->delete();
                    }
                }
                foreach ($memberships as $membership) {
                    if (empty($membership['packageid']) || empty($membership['contract_no'])) {
                        continue;
                    }
                    // 检查contract_no是否重复
                    $contract_no_data = $hierarchy->where('contract_no', $membership['contract_no'])
                        ->where('contract_status', '<>', 'stop')
                        ->where('hierarchyid', '<>', $membership['hierarchyid'])
                        ->find();
                    if (!empty($contract_no_data)) {
                        throw new Exception(__('This "Contract No. ' . $membership['contract_no'] . '" already, please check again.'));
                    }
                    if (!empty($membership['contact_date'])) {
                        $birthdays = explode('/', $membership['contact_date']);
                        $membership['contact_date'] = $birthdays[2] . '-' . $birthdays[1] . '-' . $birthdays[0];
                    } else {
                        $membership['contact_date'] = '0000-00-00';
                    }

                    if (!empty($membership['hierarchyid'])) {
                        $hierarchyid = $membership['hierarchyid'];
                        // 编辑
                        if ($membership['contract_status'] == 'stop') {
                            continue;
                        }
                        $membership['updateby'] = $this->auth->username;
                        $membership['updatedate'] = date('Y-m-d H:i:s');
                        $sql = <<<SQL
                            SELECT
                                MSD.paid_status		AS	Paid_Status,
                                MSD.ms_detail_paid	AS	Paid
                            FROM membership_detail MSD
                            WHERE MSD.hierarchyid='{$membership["hierarchyid"]}'
                                AND (MSD.paid_status <> 'N'
                                OR MSD.ms_detail_paid <> 'N')
SQL;
                        $result = Db::query($sql);
                        if (empty($result)) {
                            // 未支付
                            $hierarchy->allowField(true)
                                ->where('hierarchyid', $membership['hierarchyid'])
                                ->update($membership);

                            $membership_detail->where('hierarchyid', $membership['hierarchyid'])->delete();
                            $service_type = -1;
                            switch ($membership['servicetype']) {
                                case "Full" :
                                    $service_type = 2;
                                    break;
                                case "Odd" :
                                    $service_type = 1;
                                    break;
                                case "Even" :
                                    $service_type = 0;
                                    break;
                            }

                            $membership['total_week'] = $package->where('packageid', $membership['packageid'])->value('weeks', 0);
                            $membership['ms_contract_status'] = 'use';
                            $membership['hierarchyid'] = $hierarchyid;
                            $membership['memberid'] = $memberid;
                            if (!empty($membership['FYO']) && !empty($membership['LYO'])) {
                                for ($i = $membership['FYO']; $i <= $membership['LYO']; $i++) {
                                    if ($i % 2 == $service_type || $service_type == 2) {
                                        $membership['ms_detail_year'] = $i;
                                        $ms_detail_id = $membership_detail->allowField(true)->insert($membership, false, true);
                                        if (empty($ms_detail_id)) {
                                            throw new Exception(__('Add membership detail failed'));
                                        }
                                        $membership_detail->where('ms_detail_id', $ms_detail_id)->update([
                                            'orders_code' => sprintf('m%011d', $ms_detail_id)
                                        ]);
                                    }
                                }
                            }
                        } else {
                            // 已支付
                            $hierarchy->allowField(true)
                                ->where('hierarchyid', $membership['hierarchyid'])
                                ->update($membership);
                        }
                    } else {
                        // 新增
                        $membership['memberid'] = $memberid;
                        $membership['hidden'] = 0;
                        $membership['contract_status'] = 'use';
                        $membership['createby'] = $this->auth->username;
                        $membership['createdate'] = date('Y-m-d H:i:s');

                        $hierarchyid = $hierarchy->allowField(true)->insert($membership, false, true);
                        if (empty($hierarchyid)) {
                            throw new Exception(__('Add hierarchy failed'));
                        }
                        $service_type = -1;
                        switch ($membership['servicetype']) {
                            case "Full" :
                                $service_type = 2;
                                break;
                            case "Odd" :
                                $service_type = 1;
                                break;
                            case "Even" :
                                $service_type = 0;
                                break;
                        }

                        $membership['total_week'] = $package->where('packageid', $membership['packageid'])->value('weeks', 0);
                        $membership['ms_contract_status'] = 'use';
                        $membership['hierarchyid'] = $hierarchyid;
                        $membership['memberid'] = $memberid;
                        if (!empty($membership['FYO']) && !empty($membership['LYO'])) {
                            for ($i = $membership['FYO']; $i <= $membership['LYO']; $i++) {
                                if ($i % 2 == $service_type || $service_type == 2) {
                                    $membership['ms_detail_year'] = $i;
                                    $ms_detail_id = $membership_detail->allowField(true)->insert($membership, false, true);
                                    if (empty($ms_detail_id)) {
                                        throw new Exception(__('Add membership detail failed'));
                                    }
                                    $membership_detail->where('ms_detail_id', $ms_detail_id)->update([
                                        'orders_code' => sprintf('m%011d', $ms_detail_id)
                                    ]);
                                }
                            }
                        }
                    }
                }
            }

            Db::commit();
        } catch (ValidateException|PDOException|Exception $e) {
            Db::rollback();
            $this->error($e->getMessage());
        }
        if (false === $result) {
            $this->error(__('No rows were updated'));
        }
        $this->success();
    }
}
