<?php

namespace app\admin\controller;

use app\admin\model\addition\Rate;
use app\admin\model\orders\Addi;
use app\admin\model\orders\Bonus;
use app\admin\model\orders\Extra;
use app\admin\model\orders\Van;
use app\admin\model\paid\Method;
use app\common\controller\Backend;
use think\Db;
use think\Exception;
use think\exception\DbException;
use think\exception\PDOException;
use think\exception\ValidateException;
use think\response\Json;

/**
 *
 *
 * @icon fa fa-circle-o
 */
class Orders extends Backend
{

    /**
     * Orders模型对象
     * @var \app\admin\model\Orders
     */
    protected $model = null;
    protected $searchFields = ['orders_id', 'memberid', 'orders_code', 'doc_no', 'orders_code', 'remark'];
    protected $relationSearch = true;
    protected $modelSceneValidate = true;
    protected $modelValidate = true;

    public function _initialize()
    {
        parent::_initialize();
        $this->model = new \app\admin\model\Orders;
        $this->view->assign("statusNewList", $this->model->getStatusNewList());
        $this->view->assign("statusPaidList", $this->model->getStatusPaidList());

    }


    public function preview_order($ids)
    {
        $orders = new \app\admin\model\Orders();
        $orders_list = $orders->where('orders_id', $ids)
            ->select();
        if (!empty($orders_list)) {
            $orders_addi = new Addi();
            $orders_bonus = new Bonus();
            $orders_extra = new Extra();
            $orders_van = new Van();
            $paid_method = new Method();
            foreach ($orders_list as &$v) {
                $sum_grandtotal = 0;
                $sum_paid_amount = 0;
                $num_total_service = 0;
                $result = $orders_addi->fieldRaw('COUNT(orders_addi_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(addi_paid_amount) AS paid_amount')
                    ->whereNull('status_renounce')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_bonus->fieldRaw('COUNT(orders_bonus_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(bonus_paid_amount) AS paid_amount')
                    ->whereNull('status_renounce')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_extra->fieldRaw('COUNT(orders_extra_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(extra_paid_amount) AS paid_amount')
                    ->whereNull('status_renounce')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_van->fieldRaw('COUNT(orders_van_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(van_paid_amount) AS paid_amount')
                    ->whereNull('status_renounce')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $v->num_total_service = $num_total_service;
                $v->sum_grandtotal = $sum_grandtotal;
                $v->sum_paid_amount = $sum_paid_amount;

                if (!empty($v->paid_method_str)) {
                    $tmp = $paid_method->whereIn('paid_method_id', $v->paid_method_str)->select();
                    if (!empty($tmp)) {
                        $v->paid_method_names = implode(',', array_column($tmp, 'paid_method_name'));
                    } else {
                        $v->paid_method_names = '-';
                    }
                } else {
                    $v->paid_method_names = '-';
                }


                $v['orders_extra_list'] = $orders_extra->field('orders_extra.*,paid_method.paid_method_name')
                    ->where('orders_extra.orders_id', $v->orders_id)
                    ->join('paid_method', 'orders_extra.paid_method_id = paid_method.paid_method_id', 'left')
                    ->select();

                $v['orders_bonus_list'] = $orders_bonus->field('orders_bonus.*,paid_method.paid_method_name,resort.resortname')
                    ->where('orders_bonus.orders_id', $v->orders_id)
                    ->join('paid_method', 'orders_bonus.paid_method_id = paid_method.paid_method_id', 'left')
                    ->join('resort', 'resort.resortid=orders_bonus.resortid', 'LEFT OUTER')
                    ->select();

                $v['orders_van_list'] = $orders_van->field('orders_van.*,paid_method.paid_method_name,resort.resortname')
                    ->where('orders_van.orders_id', $v->orders_id)
                    ->join('paid_method', 'orders_van.paid_method_id = paid_method.paid_method_id', 'left')
                    ->join('resort', 'resort.resortid=orders_van.resortid', 'LEFT OUTER')
                    ->select();

                $v['orders_eaddi_list'] = $orders_addi->field('orders_addi.*,paid_method.paid_method_name')
                    ->where('orders_addi.orders_id', $v->orders_id)
                    ->join('paid_method', 'orders_addi.paid_method_id = paid_method.paid_method_id', 'left')
                    ->select();

            }
        }
        $this->view->assign('orders_data', $orders_list[0] ?? []);
        return $this->view->fetch();
    }

    /**
     * 编辑
     *
     * @param $ids
     * @return string
     * @throws DbException
     * @throws \think\Exception
     */
    public function edit($ids = null)
    {
        session('member_order', []);
        $row = $this->model->get($ids);
        if (!$row) {
            $this->error(__('No Results were found'));
        }
        $adminIds = $this->getDataLimitAdminIds();
        if (is_array($adminIds) && !in_array($row[$this->dataLimitField], $adminIds)) {
            $this->error(__('You have no permission'));
        }
        $orders_addi = new Addi();
        $orders_bonus = new Bonus();
        $orders_extra = new Extra();
        $orders_van = new Van();

        $orders_extra_list = $orders_extra->field('orders_extra.*,paid_method.paid_method_name')
            ->where('orders_extra.orders_id', $ids)
            ->join('paid_method', 'orders_extra.paid_method_id = paid_method.paid_method_id', 'left')
            ->select();

        $orders_bonus_list = $orders_bonus->field('orders_bonus.*,paid_method.paid_method_name,resort.resortname')
            ->where('orders_bonus.orders_id', $ids)
            ->join('paid_method', 'orders_bonus.paid_method_id = paid_method.paid_method_id', 'left')
            ->join('resort', 'resort.resortid=orders_bonus.resortid', 'LEFT OUTER')
            ->select();

        $orders_van_list = $orders_van->field('orders_van.*,paid_method.paid_method_name,resort.resortname')
            ->where('orders_van.orders_id', $ids)
            ->join('paid_method', 'orders_van.paid_method_id = paid_method.paid_method_id', 'left')
            ->join('resort', 'resort.resortid=orders_van.resortid', 'LEFT OUTER')
            ->select();

        $orders_eaddi_list = $orders_addi->field('orders_addi.*,paid_method.paid_method_name')
            ->where('orders_addi.orders_id', $ids)
            ->join('paid_method', 'orders_addi.paid_method_id = paid_method.paid_method_id', 'left')
            ->select();

        if (false === $this->request->isPost()) {
            $memberid = $row['memberid'];
            $memberdata = \app\admin\model\Member::where('memberid', $memberid)->find();
            if (!empty($orders_extra_list)) {
                foreach ($orders_extra_list as &$ol) {
                    $ol['checkin_date'] = format_date($ol['checkin_date'], 'd/m/Y', '');
                    $ol['checkout_date'] = format_date($ol['checkout_date'], 'd/m/Y', '');
                }
            }
            if (!empty($orders_bonus_list)) {
                foreach ($orders_bonus_list as &$ol) {
                    $ol['checkin_date'] = format_date($ol['checkin_date'], 'd/m/Y', '');
                    $ol['checkout_date'] = format_date($ol['checkout_date'], 'd/m/Y', '');
                }
            }
            if (!empty($orders_van_list)) {
                $member_order = [];
                foreach ($orders_van_list as $k => &$ol) {
                    $member_order[$memberid]['from_contract'][$k] = $ol['from_contract'];
                    $ol['checkin_date'] = format_date($ol['checkin_date'], 'd/m/Y', '');
                    $ol['checkout_date'] = format_date($ol['checkout_date'], 'd/m/Y', '');
                }
                session('member_order', $member_order);
            }
            $row['orders_extra_list'] = !empty($orders_extra_list) ? json_encode($orders_extra_list) : json_encode([]);
            $row['orders_bonus_list'] = !empty($orders_bonus_list) ? json_encode($orders_bonus_list) : json_encode([]);
            $row['orders_van_list'] = !empty($orders_van_list) ? json_encode($orders_van_list) : json_encode([]);
            $row['orders_eaddi_list'] = !empty($orders_eaddi_list) ? json_encode($orders_eaddi_list) : json_encode([]);


            $row['due_date'] = format_date($row['due_date'], 'd/m/Y', '');
            $row['checkin_date'] = format_date($row['checkin_date'], 'd/m/Y', '');
            $row['checkout_date'] = format_date($row['checkout_date'], 'd/m/Y', '');
            $row['paid_date'] = format_date($row['paid_date'], 'd/m/Y H:i:s', '');
            $row['cancel_date'] = format_date($row['cancel_date'], 'd/m/Y H:i:s', '');

            $this->view->assign('row', $row);
            $this->view->assign('memberdata', $memberdata);
            return $this->view->fetch();
        }
        $params = $this->request->post('row/a');
        if (empty($params)) {
            $this->error(__('Parameter %s can not be empty', ''));
        }
        $params = $this->preExcludeFields($params);
        $result = false;
        Db::startTrans();
        try {
            //是否采用模型验证
            if ($this->modelValidate) {
                $name = str_replace("\\model\\", "\\validate\\", get_class($this->model));
                $validate = is_bool($this->modelValidate) ? ($this->modelSceneValidate ? $name . '.edit' : $name) : $this->modelValidate;
                $row->validateFailException()->validate($validate);
            }
            // 调整时间等参数
            if (isset($params['due_date'])) {
                $params['due_date'] = format_sqldate($params['due_date'], 'Y-m-d', '0000-00-00');
            }
            if (isset($params['checkin_date'])) {
                $params['checkin_date'] = format_sqldate($params['checkin_date'], 'Y-m-d', '0000-00-00');
            }
            if (isset($params['checkout_date'])) {
                $params['checkout_date'] = format_sqldate($params['checkout_date'], 'Y-m-d', '0000-00-00');
            }
            if (isset($params['paid_date'])) {
                $params['paid_date'] = format_sqldate($params['paid_date'], 'Y-m-d H:i:s', '0000-00-00 00:00:00');
            }
            if (isset($params['cancel_date'])) {
                $params['cancel_date'] = format_sqldate($params['cancel_date'], 'Y-m-d H:i:s', '0000-00-00 00:00:00');
            }
            $params['updateby'] = $this->auth->username;
            $params['updatedate'] = date('Y-m-d H:i:s');

            $result = $row->allowField(true)->save($params);

            $update_orders_extra_ids = [];
            if (!empty($params['orders_extra_list'])) {
                $row_orders_extra_list = json_decode($params['orders_extra_list'], true);
                foreach ($row_orders_extra_list as $v) {
                    $v['checkin_date'] = format_sqldate($v['checkin_date'], 'Y-m-d', '0000-00-00');
                    $v['checkout_date'] = format_sqldate($v['checkout_date'], 'Y-m-d', '0000-00-00');
                    if (!empty($v['orders_extra_id'])) {
                        $orders_extra_id = $v['orders_extra_id'];
                        unset($v['orders_extra_id']);
                        $update_orders_extra_ids[] = $orders_extra_id;
                        $orders_extra->where('orders_extra_id', $orders_extra_id)
                            ->update($v);
                    } else {
                        $v['orders_id'] = $ids;
                        $orders_extra->insert($v);
                    }
                }
            }
            if (!empty($orders_extra_list)) {
                $has_orders_extra_ids = array_column($orders_extra_list, 'orders_extra_id');
                $diff_ids = array_diff($has_orders_extra_ids, $update_orders_extra_ids);
                foreach ($diff_ids as $diff_id) {
                    $orders_extra->where('orders_extra_id', $diff_id)->delete();
                }
            }


            $update_orders_bonus_ids = [];
            if (!empty($params['orders_bonus_list'])) {
                $row_orders_bonus_list = json_decode($params['orders_bonus_list'], true);
                foreach ($row_orders_bonus_list as $v) {
                    $v['checkin_date'] = format_sqldate($v['checkin_date'], 'Y-m-d', '0000-00-00');
                    $v['checkout_date'] = format_sqldate($v['checkout_date'], 'Y-m-d', '0000-00-00');
                    if ($v['bonus_type'] == 'E') {
                        $v['bonus_fullweek'] = 0;
                        $v['bonus_midweek'] = 0;
                        $v['bonus_weekend'] = 0;
                    } else if ($v['bonus_type'] == 'B') {
                        $v['bonus_extranight'] = 0;
                    } else {
                        $v['bonus_fullweek'] = 0;
                        $v['bonus_midweek'] = 0;
                        $v['bonus_weekend'] = 0;
                        $v['bonus_extranight'] = 0;
                    }
                    if (!empty($v['orders_bonus_id'])) {
                        $orders_bonus_id = $v['orders_bonus_id'];
                        unset($v['orders_bonus_id']);
                        $update_orders_bonus_ids[] = $orders_bonus_id;
                        $orders_bonus->where('orders_bonus_id', $orders_bonus_id)
                            ->update($v);
                    } else {
                        $v['orders_id'] = $ids;
                        $orders_bonus->insert($v);
                    }
                }
            }
            if (!empty($orders_bonus_list)) {
                $has_orders_bonus_ids = array_column($orders_bonus_list, 'orders_bonus_id');
                $diff_ids = array_diff($has_orders_bonus_ids, $update_orders_bonus_ids);
                foreach ($diff_ids as $diff_id) {
                    $orders_bonus->where('orders_bonus_id', $diff_id)->delete();
                }
            }


            $update_orders_van_ids = [];
            if (!empty($params['orders_van_list'])) {
                $row_orders_van_list = json_decode($params['orders_van_list'], true);
                foreach ($row_orders_van_list as $v) {
                    $v['checkin_date'] = format_sqldate($v['checkin_date'], 'Y-m-d', '0000-00-00');
                    $v['checkout_date'] = format_sqldate($v['checkout_date'], 'Y-m-d', '0000-00-00');
                    if (!empty($v['orders_van_id'])) {
                        $orders_van_id = $v['orders_van_id'];
                        unset($v['orders_van_id']);
                        $update_orders_van_ids[] = $orders_van_id;
                        $orders_van->where('orders_van_id', $orders_van_id)
                            ->update($v);
                    } else {
                        $v['orders_id'] = $ids;
                        $orders_van->insert($v);
                    }
                }
            }
            if (!empty($orders_van_list)) {
                $has_orders_van_ids = array_column($orders_van_list, 'orders_van_id');
                $diff_ids = array_diff($has_orders_van_ids, $update_orders_van_ids);
                foreach ($diff_ids as $diff_id) {
                    $orders_van->where('orders_van_id', $diff_id)->delete();
                }
            }


            $update_orders_eaddi_ids = [];
            if (!empty($params['orders_eaddi_list'])) {
                $row_orders_eaddi_list = json_decode($params['orders_eaddi_list'], true);
                foreach ($row_orders_eaddi_list as $v) {
                    $v['addi_rate_name'] = Rate::where('addition_rate_id', $v['addi_rate_id'])->value('addition_rate_name', '');
                    if (!empty($v['orders_addi_id'])) {
                        $orders_eaddi_id = $v['orders_addi_id'];
                        unset($v['orders_addi_id']);
                        $update_orders_eaddi_ids[] = $orders_eaddi_id;
                        $orders_addi->where('orders_addi_id', $orders_eaddi_id)
                            ->update($v);
                    } else {
                        $v['orders_id'] = $ids;
                        $orders_addi->insert($v);
                    }
                }
            }
            if (!empty($orders_eaddi_list)) {
                $has_orders_eaddi_ids = array_column($orders_eaddi_list, 'orders_addi_id');
                $diff_ids = array_diff($has_orders_eaddi_ids, $update_orders_eaddi_ids);
                foreach ($diff_ids as $diff_id) {
                    $orders_addi->where('orders_addi_id', $diff_id)->delete();
                }
            }


            Db::commit();
        } catch (ValidateException|PDOException|Exception $e) {
            Db::rollback();
            $this->error($e->getMessage());
        }
        if (false === $result) {
            $this->error(__('No rows were updated'));
        }
        $this->success();
    }

    /**
     * 添加
     *
     * @return string
     * @throws \think\Exception
     */
    public function add()
    {
        session('member_order', []);
        $memberid = input('memberid');
        $memberdata = \app\admin\model\Member::where('memberid', $memberid)->find();
        if (false === $this->request->isPost()) {
            $this->view->assign('memberdata', $memberdata);
            return $this->view->fetch();
        }
        $params = $this->request->post('row/a');
        if (empty($params)) {
            $this->error(__('Parameter %s can not be empty', ''));
        }
        $params = $this->preExcludeFields($params);

        if ($this->dataLimit && $this->dataLimitFieldAutoFill) {
            $params[$this->dataLimitField] = $this->auth->id;
        }
        $result = false;
        Db::startTrans();
        try {
            //是否采用模型验证
            if ($this->modelValidate) {
                $name = str_replace("\\model\\", "\\validate\\", get_class($this->model));
                $validate = is_bool($this->modelValidate) ? ($this->modelSceneValidate ? $name . '.add' : $name) : $this->modelValidate;
                $this->model->validateFailException()->validate($validate);
            }


            // 调整时间等参数
            if (isset($params['due_date'])) {
                $params['due_date'] = format_sqldate($params['due_date'], 'Y-m-d', '0000-00-00');
            }

            if (isset($params['checkin_date'])) {
                $params['checkin_date'] = format_sqldate($params['checkin_date'], 'Y-m-d', '0000-00-00');
            } else {
                $params['checkin_date'] = '0000-00-00';
            }
            if (isset($params['checkout_date'])) {
                $params['checkout_date'] = format_sqldate($params['checkout_date'], 'Y-m-d', '0000-00-00');
            } else {
                $params['checkout_date'] = '0000-00-00';
            }

            $params['createby'] = $this->auth->username;
            $params['createdate'] = date('Y-m-d H:i:s');
            $params['orders_date'] = date('Y-m-d H:i:s');
            $params['memberid'] = $memberid;
            $orders_no = getOrderNumber($memberid);
            $params['orders_no'] = $orders_no;


            $result = $this->model->allowField(true)->save($params);
            $orders_addi = new Addi();
            $orders_bonus = new Bonus();
            $orders_extra = new Extra();
            $orders_van = new Van();

            if (!empty($result)) {
                $ids = $this->model->getLastInsID();
                $this->model->where('orders_id', $ids)->update([
                    'orders_code' => ORDERS_GenCode($memberdata['member_type'], $ids)
                ]);
                if (!empty($params['orders_extra_list'])) {
                    $row_orders_extra_list = json_decode($params['orders_extra_list'], true);
                    foreach ($row_orders_extra_list as $v) {
                        $v['checkin_date'] = format_sqldate($v['checkin_date'], 'Y-m-d', '0000-00-00');
                        $v['checkout_date'] = format_sqldate($v['checkout_date'], 'Y-m-d', '0000-00-00');
                        $v['orders_id'] = $ids;
                        $v['createby'] = $this->auth->username;
                        $v['createdate'] = date('Y-m-d H:i:s');
                        $orders_extra_id = $orders_extra->insert($v, false, true);
                        if (empty($orders_extra_id)) {
                            $this->error(__('Add ExtraNight for Membership fail'));
                        }
                        $orders_extra->where('orders_extra_id', $orders_extra_id)
                            ->update([
                                'orders_code' => sprintf("%011d", $orders_extra_id)
                            ]);
                    }
                }

                if (!empty($params['orders_bonus_list'])) {
                    $row_orders_bonus_list = json_decode($params['orders_bonus_list'], true);
                    foreach ($row_orders_bonus_list as $v) {
                        $v['checkin_date'] = format_sqldate($v['checkin_date'], 'Y-m-d', '0000-00-00');
                        $v['checkout_date'] = format_sqldate($v['checkout_date'], 'Y-m-d', '0000-00-00');
                        if ($v['bonus_type'] == 'E') {
                            $v['bonus_fullweek'] = 0;
                            $v['bonus_midweek'] = 0;
                            $v['bonus_weekend'] = 0;
                        } else if ($v['bonus_type'] == 'B') {
                            $v['bonus_extranight'] = 0;
                        } else {
                            $v['bonus_fullweek'] = 0;
                            $v['bonus_midweek'] = 0;
                            $v['bonus_weekend'] = 0;
                            $v['bonus_extranight'] = 0;
                        }
                        $v['createby'] = $this->auth->username;
                        $v['createdate'] = date('Y-m-d H:i:s');
                        $v['orders_id'] = $ids;
                        $orders_bonus_id = $orders_bonus->insert($v, false, true);

                        if (empty($orders_bonus_id)) {
                            $this->error(__('Add Bonus week / Extranight for bonus week fail'));
                        }
                        $orders_bonus->where('orders_bonus_id', $orders_bonus_id)
                            ->update([
                                'orders_code' => sprintf("%011d", $orders_bonus_id)
                            ]);
                    }
                }

                if (!empty($params['orders_van_list'])) {
                    $row_orders_van_list = json_decode($params['orders_van_list'], true);
                    foreach ($row_orders_van_list as $v) {
                        $v['checkin_date'] = format_sqldate($v['checkin_date'], 'Y-m-d', '0000-00-00');
                        $v['checkout_date'] = format_sqldate($v['checkout_date'], 'Y-m-d', '0000-00-00');
                        $v['orders_id'] = $ids;
                        $v['createby'] = $this->auth->username;
                        $v['createdate'] = date('Y-m-d H:i:s');
                        $orders_van_id = $orders_van->insert($v, false, true);

                        if (empty($orders_van_id)) {
                            $this->error(__('Add Exchange (HCS Club exchange to another club) fail'));
                        }
                        $orders_van->where('orders_van_id', $orders_van_id)
                            ->update([
                                'orders_code' => sprintf("%011d", $orders_van_id)
                            ]);
                    }
                }

                if (!empty($params['orders_eaddi_list'])) {
                    $row_orders_eaddi_list = json_decode($params['orders_eaddi_list'], true);
                    foreach ($row_orders_eaddi_list as $v) {
                        $v['orders_id'] = $ids;
                        $v['createby'] = $this->auth->username;
                        $v['createdate'] = date('Y-m-d H:i:s');
                        $v['addi_rate_name'] = Rate::where('addition_rate_id', $v['addi_rate_id'])->value('addition_rate_name', '');
                        $orders_addi_id = $orders_addi->insert($v, false, true);

                        if (empty($orders_addi_id)) {
                            $this->error(__('Add Addition Services fail'));
                        }
                        $orders_addi->where('orders_addi_id', $orders_addi_id)
                            ->update([
                                'orders_code' => sprintf("%011d", $orders_addi_id)
                            ]);
                    }
                }
            }
            Db::commit();
        } catch (ValidateException|PDOException|Exception $e) {
            Db::rollback();
            $this->error($e->getMessage());
        }
        if ($result === false) {
            $this->error(__('No rows were inserted'));
        }
        $this->success();
    }

    /**
     * @return Json
     */
    public function from_contract()
    {
        $memberid = input('memberid');
        $list = [];
        if (!empty($memberid)) {
            $sql_contact = "SELECT DISTINCT 
									H.hierarchyid, 
									H.contract_no,
									M.paid_status,
									M.ms_detail_used,
									M.status_used 
								FROM hierarchy H 
								INNER JOIN membership_detail M ON 
									M.hierarchyid=H.hierarchyid AND 
									M.ms_detail_used='N' AND 
									M.paid_status = 'Y' 
								WHERE H.memberid='" . $memberid . "'";
            $list = Db::query($sql_contact);
        }
        return json([
            'list' => $list,
            'total' => count($list)
        ]);
    }

    /**
     * 设置临时变量
     * @return void
     */
    public function set_session_var()
    {
        $memberid = input('memberid');
        $name = input('name');
        $index = input('index', 0);
        $value = input('val', '');
        $member_order = session('member_order');
        if (empty($member_order)) {
            $member_order = [];
        }
        $member_order[$memberid][$name][$index] = $value;
        session('member_order', $member_order);
    }

    /**
     * @return Json
     */
    public function from_year()
    {
        $memberid = input('memberid');
        $index = input('index', 0);
        $member_order = session('member_order');
        if (!empty($member_order[$memberid]['from_contract'][$index])) {
            $contract_no = $member_order[$memberid]['from_contract'][$index];
        } else {
            $contract_no = input('custom.contract_no');
        }
        $list = [];
        if (!empty($memberid) && !empty($contract_no)) {
            $sql_contact = "SELECT DISTINCT 
									H.hierarchyid, 
									H.contract_no,
									M.paid_status,
									M.ms_detail_used,
									M.status_used 
								FROM hierarchy H 
								INNER JOIN membership_detail M ON 
									M.hierarchyid=H.hierarchyid AND 
									M.ms_detail_used='N' AND 
									M.paid_status = 'Y' 
								WHERE H.memberid='" . $memberid . "'" . " AND H.contract_no='{$contract_no}'";
            $list = Db::query($sql_contact);
            if (!empty($list[0]['hierarchyid'])) {
                $hierarchyid = $list[0]['hierarchyid'];
                $sql = "SELECT
				MD.ms_detail_id
				, MD.ms_detail_year
				, P.unittype 
			FROM membership_detail MD 
			INNER JOIN package P ON 
				P.packageid=MD.packageid 
			WHERE MD.paid_status='Y' 
				AND MD.ms_detail_used!='Y' 
				AND MD.memberid='" . $memberid . "' 
				AND MD.hierarchyid='" . $hierarchyid . "' 
			ORDER BY MD.ms_detail_year";
                $list = Db::query($sql);
            }
        }
        return json([
            'list' => $list,
            'total' => count($list)
        ]);
    }

    /**
     * @return Json
     */
    public function get_from_unittype()
    {
        $memberid = input('memberid');
        $ms_detail_year = input('ms_detail_year');
        $unittype = '';
        if (!empty($memberid) && !empty($ms_detail_year)) {
            $sql = "SELECT
				MD.ms_detail_id
				, MD.ms_detail_year
				, P.unittype 
			FROM membership_detail MD 
			INNER JOIN package P ON 
				P.packageid=MD.packageid 
			WHERE MD.paid_status='Y' 
				AND MD.ms_detail_used!='Y' 
				AND MD.memberid='" . $memberid . "' 
				AND MD.ms_detail_year='" . $ms_detail_year . "' 
			ORDER BY MD.ms_detail_year";
            $list = Db::query($sql);
            if (!empty($list[0]['ms_detail_id'])) {
                $ms_detail_id = $list[0]['ms_detail_id'];
                $sql = "SELECT P.unittype FROM membership_detail MD INNER JOIN package P ON P.packageid=MD.packageid WHERE MD.ms_detail_id=" . $ms_detail_id;
                $list2 = Db::query($sql);
                if (!empty($list2[0]['unittype'])) {
                    $unittype = $list2[0]['unittype'];
                }
            }

            if (empty($unittype) && !empty($list[0]['unittype'])) {
                $unittype = $list[0]['unittype'];
            }
        }
        return json([
            'unittype' => $unittype,
        ]);
    }

    /**
     * @return Json
     */
    public function get_addi_rate_price()
    {
        $addi_rate_id = input('addi_rate_id');
        $addition_rate_price = Rate::where('addition_rate_id', $addi_rate_id)->value('addition_rate_price', '');
        return json([
            'addition_rate_price' => $addition_rate_price,
        ]);
    }

    /**
     * 查看
     *
     * @return string|Json
     * @throws \think\Exception
     * @throws DbException
     */
    public function index()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            return $this->view->fetch();
        }
        //如果发送的来源是 Selectpage，则转发到 Selectpage
        if ($this->request->request('keyField')) {
            return $this->selectpage();
        }
        [$where, $sort, $order, $offset, $limit] = $this->buildparams();
        $list = $this->model
            ->group('orders.orders_id')
            ->where($where)
            ->with([
                'member' => function ($query) {
                    $query->withField('title,login_name,login_surname,username,title2,fullname2,fullsurname2');
                }
            ])
            ->join('hierarchy H', 'orders.memberid = H.memberid')
            ->order($sort, $order)
            ->paginate($limit);
        $rows = $list->items();
        if (!empty($rows)) {
            $orders_addi = new Addi();
            $orders_bonus = new Bonus();
            $orders_extra = new Extra();
            $orders_van = new Van();
            $paid_method = new Method();
            foreach ($rows as &$row) {
                $sum_grandtotal = 0;
                $sum_paid_amount = 0;
                $num_total_service = 0;
                $result = $orders_addi->fieldRaw('COUNT(orders_addi_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(addi_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $row->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_bonus->fieldRaw('COUNT(orders_bonus_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(bonus_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $row->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_extra->fieldRaw('COUNT(orders_extra_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(extra_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $row->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_van->fieldRaw('COUNT(orders_van_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(van_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $row->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $row->num_total_service = $num_total_service;
                $row->sum_grandtotal = $sum_grandtotal;
                $row->sum_paid_amount = $sum_paid_amount;

                if (!empty($row->paid_method_str)) {
                    $tmp = $paid_method->whereIn('paid_method_id', $row->paid_method_str)->select();
                    if (!empty($tmp)) {
                        $row->paid_method_names = implode(',', array_column($tmp,'paid_method_name' ));
                    } else {
                        $row->paid_method_names = '-';
                    }
                } else {
                    $row->paid_method_names = '-';
                }
            }
        }
        $result = ['total' => $list->total(), 'rows' => $rows];
        return json($result);
    }
}
