<?php

namespace app\admin\controller;

use app\admin\model\invoice\History;
use app\admin\model\membership\Detail;
use app\common\controller\Backend;
use fast\Encrypt;
use think\Db;
use think\db\exception\DataNotFoundException;
use think\db\exception\ModelNotFoundException;
use think\Exception;
use think\exception\DbException;
use think\exception\PDOException;
use think\exception\ValidateException;
use think\response\Json;

/**
 *
 *
 * @icon fa fa-circle-o
 */
class PrintInvoices extends Backend
{

    /**
     * Member模型对象
     * @var \app\admin\model\Member
     */
    protected $model = null;
    protected $searchFields = ['memberid', 'orders_code', 'ms_detail_year', 'ms_detail_id'];
    protected $relationSearch = true;
    protected $modelSceneValidate = true;
    protected $modelValidate = true;

    public function _initialize()
    {
        parent::_initialize();
        $this->model = new Detail();
    }


    /**
     * 查看
     *
     * @return string|Json
     * @throws \think\Exception
     * @throws DbException
     */
    public function index()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            return $this->view->fetch();
        }
        //如果发送的来源是 Selectpage，则转发到 Selectpage
        if ($this->request->request('keyField')) {
            return $this->selectpage();
        }
        [$where, $sort, $order, $offset, $limit] = $this->buildparams();
        $list = $this->model
            ->where($where)
            ->group('hierarchy.hierarchyid')
            ->fieldRaw('*,country.country_name,country.countryid,package.unittype')
            ->where('member.hidden', '<>', 1)
            ->where('partner.hidden', '<>', 1)
            ->where('member.member_type', 'M')
            ->where('membership_detail.paid_status', 'N')
            ->where('hierarchy.hidden', '<>', 1)
            ->where('hierarchy.contract_status', '<>', 'stop')
            ->whereNotIn('membership_detail.booking_renounce', ['S', 'B'])
            ->with([
                'member' => function ($query) {
                    $query->withField('login_name,login_surname,title,fullname2,fullsurname2,address,province,postalcode');
                },
                'hierarchy' => function ($query) {
                    $query->withField('membercode,partnerid,packageid,servicetype,season_type,contract_no');
                },
                'partner' => function ($query) {
                    $query->withField('login_name');
                },
//                'package' => function ($query) {
//                    $query->withField('unittype');
//                }
            ])
            ->join('country', 'country.countryid=member.countryid', 'left')
            ->join('package', 'membership_detail.packageid=package.packageid', 'LEFT OUTER')
            ->order($sort, $order)
            ->paginate($limit);
        $rows = $list->items();
        if (!empty($rows)) {
            foreach ($rows as &$row) {
                $row->packageprice_prices = \app\admin\model\Packageprice::where('packageid', $row->packageid)
                    ->where('packageprice_years', $row->ms_detail_year)
                    ->value('packageprice_prices', 0);
            }
        }
        $result = ['total' => $list->total(), 'rows' => $rows];
        return json($result);
    }

    /**
     * @return void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws Exception
     * @throws ModelNotFoundException
     */
    public function gen_invoice()
    {
        $ids = input('ids/a');
        if (empty($ids)) {
            $this->error('Param error');
        }
        $deadline = input('deadline');
        if (empty($deadline)) {
            $deadline = '0000-00-00';
        } else {
            $deadline = format_sqldate($deadline, 'Y-m-d', '0000-00-00');
        }
        $list = Detail::whereIn('ms_detail_id', $ids)
            ->fieldRaw('*,country.country_name,country.countryid')
            ->with([
                'hierarchy' => function ($query) {
                    $query->withField('membercode,partnerid,packageid,servicetype,season_type,contract_no');
                },
                'member' => function ($query) {
                    $query->withField('login_name,login_surname,title,fullname2,fullsurname2,address,province,postalcode');
                }
            ])
            ->join('country', 'country.countryid=member.countryid', 'left')
            ->select();
        if (!empty($list)) {
            $invoice_history = new History();
            foreach ($list as $item) {
                $num = $invoice_history->where('ms_detail_id', $item['ms_detail_id'])->count();
                if (!empty($num)) {
                    continue;
                }
                $max_invoice_id = $invoice_history->where('entitlement_year', $item['ms_detail_year'])->max('invoice_sort');
                if (empty($max_invoice_id)) {
                    $max_invoice_id = 1;
                } else {
                    $max_invoice_id += 1;
                }
                $invoice_number = "MF-" . sprintf("%05d", $item['memberid']) . substr(date($item['ms_detail_year']), 2, 4) . sprintf("%05d", $max_invoice_id);
                $packageprice_prices = \app\admin\model\Packageprice::where('packageid', $item['packageid'])
                    ->where('packageprice_years', $item['ms_detail_year'])
                    ->value('packageprice_prices', 0);
                $debit_usd = $item['special_amount'] > 0 ? $item['special_amount'] : $packageprice_prices;
                $invoice_history->insert([
                    'member_id' => $item['memberid'],
                    'hierarchyid' => $item['hierarchyid'],
                    'ms_detail_id' => $item['ms_detail_id'],
                    'dead_line' => $deadline,
                    'print_time' => '',
                    'invoice_no' => $invoice_number,
                    'invoice_year' => date("Y"),
                    'entitlement_year' => $item['ms_detail_year'],
                    'advance_year' => $item['advance_to_year'],
                    'contract_no' => $item['hierarchy']['contract_no'],
                    'member_name' => $item['member']['login_name'] . ' ' . $item['member']['login_surname'],
                    'full_name' => $item['member']['fullname2'] . ' ' . $item['member']['fullsurname2'],
                    'address' => $item['member']['address'],
                    'province' => $item['member']['province'],
                    'postalcode' => $item['member']['postalcode'],
                    'country' => $item['country_name'],
                    'invoice_date' => date('Y-m-d'),
                    'debit_usd' => $debit_usd,
                    'invoice_sort' => sprintf("%05d", $max_invoice_id),
                ]);
            }
        }
        $this->success();
    }

    /**
     * @return void
     */
    public function renounce()
    {
        $ids = input('ids/a');
        if (empty($ids)) {
            $this->error('Param error');
        }
        Detail::whereIn('ms_detail_id', $ids)->update([
            'booking_renounce' => 'B'
        ]);
        $this->success();
    }

    public function prinfpdf()
    {

    }
}
