<?php

namespace app\admin\controller;

use app\admin\model\binding\Main;
use app\admin\model\invoice\History;
use app\admin\model\membership\Detail;
use app\admin\model\orders\Addi;
use app\admin\model\orders\Bonus;
use app\admin\model\orders\Extra;
use app\admin\model\orders\Van;
use app\admin\model\paid\Method;
use app\common\controller\Backend;
use app\common\library\Email;
use fast\Formprint;
use fast\Orderform;
use fast\PrintConfirmation;
use fast\PrintInvoice;
use fast\Printpdf;
use think\Db;
use think\db\exception\DataNotFoundException;
use think\db\exception\ModelNotFoundException;
use think\Exception;
use think\exception\DbException;
use think\response\Json;

/**
 *
 *
 * @icon fa fa-circle-o
 */
class ServiceCenter extends Backend
{

    /**
     * Member模型对象
     * @var \app\admin\model\Member
     */
    protected $model = null;
    protected $searchFields = ['memberid', 'username', 'login_name', 'login_surname', 'fullname2', 'fullsurname2'];
    protected $relationSearch = true;
    protected $modelSceneValidate = true;
    protected $modelValidate = true;

    public function _initialize()
    {
        parent::_initialize();
        $this->model = new \app\admin\model\Member;
        $this->view->assign("titleList", $this->model->getTitleList());
        $this->view->assign("seasonTypeList", $this->model->getSeasonTypeList());
        $this->view->assign("yearList", $this->model->getYearList());
    }


    /**
     * 查看
     *
     * @return string|Json
     * @throws \think\Exception
     * @throws DbException
     */
    public function index()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            return $this->view->fetch();
        }
        //如果发送的来源是 Selectpage，则转发到 Selectpage
        if ($this->request->request('keyField')) {
            return $this->selectpage();
        }
        [$where, $sort, $order, $offset, $limit] = $this->buildparams();


        $list = $this->model
            ->where($where)
            ->group('`member`.`memberid`')
            ->with([
                'country' => function ($query) {
                    $query->withField('country_name,countryid');
                },
                'hierarchy' => function ($query) {
                    $query->withField('membercode,partnerid,packageid,servicetype,season_type,contract_no');
                },
                'marketer' => function ($query) {
                    $query->withField('login_name');
                },
                'language' => function ($query) {
                    $query->withField('language_name');
                }
            ])
            ->join('package', 'hierarchy.packageid=package.packageid', 'left')
            ->join('invoice_bank', 'invoice_bank.memberid=member.memberid', 'left')
            ->order($sort, $order)
            ->paginate($limit);

        $rows = $list->items();
        if (!empty($rows)){
            foreach ($rows as &$row){
                if (empty($row['title'])){
                    $row['title'] = '';
                }
                if (empty($row['title2'])){
                    $row['title2'] = '';
                }
            }
        }

        $result = ['total' => $list->total(), 'rows' => $rows];
        return json($result);
    }

    /**
     * 初始化顶部tab
     * @param int $current_tab
     * @param int $memberid
     * @return array
     * @throws DbException
     * @throws DataNotFoundException
     * @throws ModelNotFoundException
     */
    private function init_service_center($current_tab = 0, $memberid = 0)
    {
        $service_center_tabs = [
            [
                'name' => __('MS. All'),
                'url' => url('admin/service_center/view_invoice', ['ids' => $memberid]),
                'active' => $current_tab == 0
            ],
            [
                'name' => __('Unpaid'),
                'url' => url('admin/service_center/view_unpaid', ['ids' => $memberid]),
                'active' => $current_tab == 1
            ],
            [
                'name' => __('Paid'),
                'url' => url('admin/service_center/view_paid', ['ids' => $memberid]),
                'active' => $current_tab == 2
            ],
            [
                'name' => __('All Order'),
                'url' => url('admin/service_center/view_all_order', ['ids' => $memberid]),
                'active' => $current_tab == 3
            ],
            [
                'name' => __('New Order'),
                'url' => url('admin/service_center/view_new_order', ['ids' => $memberid]),
                'active' => $current_tab == 4
            ],
            [
                'name' => __('All Booking'),
                'url' => url('admin/service_center/view_all_booking', ['ids' => $memberid]),
                'active' => $current_tab == 5
            ],
            [
                'name' => __('New Booking'),
                'url' => url('admin/service_center/view_new_booking', ['ids' => $memberid]),
                'active' => $current_tab == 6
            ],
            [
                'name' => __('Un Used'),
                'url' => url('admin/service_center/view_un_used', ['ids' => $memberid]),
                'active' => $current_tab == 7
            ],
            [
                'name' => __('Used'),
                'url' => url('admin/service_center/view_used', ['ids' => $memberid]),
                'active' => $current_tab == 8
            ]
        ];

        $this->view->assign('service_center_tabs', $service_center_tabs);
        $this->view->assign('service_center_current_tab', $current_tab);

        $member_data = \app\admin\model\Member::where('memberid', $memberid)
            ->with([
                'country' => function ($query) {
                    $query->withField('country_name,countryid');
                },
                'marketer' => function ($query) {
                    $query->withField('login_name');
                }
            ])
            ->find();

        $this->view->assign('member_data', $member_data);
        return $member_data;
    }

    /**
     * 初始化Membership
     * @param $ids
     * @return bool|\PDOStatement|string|\think\Collection
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    private function init_hierarchy($ids)
    {
        $hierarchy = new \app\admin\model\Hierarchy();
        $hierarchy_list = $hierarchy->where('hierarchy.memberid', $ids)
            ->with([
                'package' => function ($query) {
                    $query->withField('packagename');
                },
                'partner' => function ($query) {
                    $query->withField('login_name');
                }
            ])
            ->orderRaw("FIELD(hierarchy.contract_status, '', 'use', 'stop')")
            ->select();
        if (!empty($hierarchy_list)) {
            $membership_detail = new Detail();
            foreach ($hierarchy_list as &$item) {
                $membership_detail_list = $membership_detail->alias('MBSD')
                    ->fieldRaw("MBSD.ms_detail_id AS  MSB_Detail_ID
		,  PK.packagename	 AS	MSB_Detail_Type
		,  MBSD.total_week AS    Week_per_Year
		,  MBSD.ms_detail_year AS	MSB_Detail_Year
		,  MBSD.ms_detail_paid	AS	MSB_Detail_Paid
		,  MBSD.ms_detail_used AS	MSB_Detail_Used
		,  MBSD.ms_detail_paid_date	AS	MSB_Detail_Paid_Date
		,  MBSD.paid_amount  AS	MSB_Detail_Paid_Amount
		,  PM.paid_method_name AS	MSB_Detail_Paid_Method
		,  MBSD.paid_status AS	MSB_Detail_Paid_Status
		,  MBSD.ms_detail_remark	    	AS	MSB_Detail_Paid_Remark
		,  MBSD.used_fullweek		  		AS	MSB_Detail_UsedFW
		,  MBSD.used_midweek		  		AS	MSB_Detail_UsedMW
		,  MBSD.used_weekend		  		AS	MSB_Detail_UsedWE
		/*
		,  MBSD.special_amount		  		AS	Maintenance_Fee_Special
		,  PKS.packageprice_prices	  		AS	Maintenance_Fee
		*/
		,  booking.booking_id					AS	Booking_ID
		,  BKD.booking_detail_fullweek		AS	Booking_Full_Week
		,  BKD.booking_detail_midweek	AS	Booking_Mid_Week
		,  BKD.booking_detail_weekend	AS	Booking_Weekend

		,  PRC.paid_method AS paid_method 
		,  PRC.paid_amount AS paid_amount
		,  PRC.servicetype AS servicetype
		,  PRC.packageid AS package_id
		,  PRC.packagename  AS package_name
		,  PRC.packagepriceid
		,  PRC.packageprice_years
		,  PRC.packageprice_prices AS package_price
		, CASE MBSD.paid_status
			WHEN 'N' THEN PKS.packageprice_prices	
			WHEN 'Y' AND PRC.packageprice_prices THEN PRC.packageprice_prices
			ELSE PKS.packageprice_prices
		END AS Maintenance_Fee
		, IF(PRC.special_prices, PRC.special_prices, MBSD.special_amount) AS Maintenance_Fee_Special")
                    ->join('payment_record PRC', "PRC.ms_detail_id = MBSD.ms_detail_id AND PRC.paid_status = 'Y'", 'left')
                    ->join('package PK', "PK.packageid = MBSD.packageid", 'left')
                    ->join('paid_method PM', "PM.paid_method_id = MBSD.paid_method", 'left')
                    ->join('packageprice PKS', "PKS.packageid = MBSD.packageid AND PKS.packageprice_years  = MBSD.ms_detail_year", 'left')
                    ->join('booking', "booking.hierarchyid = MBSD.hierarchyid", 'left')
                    ->join('booking_detail BKD', "BKD.booking_id=booking.booking_id", 'left')
                    ->where('MBSD.hierarchyid', $item->hierarchyid)
                    ->where('MBSD.ms_detail_year', '>=', date('Y') - 2)
                    ->order('MBSD.ms_detail_year', 'asc')
                    ->select();
                $tmp = [];
                foreach ($membership_detail_list as $v2) {
                    $v2_arr = $v2->toArray();
                    $v2_arr['Available'] = availableTime($v2_arr);
                    $tmp[] = $v2_arr;
                }
                $item->membership_detail_list = $tmp;
            }
        }
        $this->view->assign('hierarchy_list', $hierarchy_list);
        return $hierarchy_list;
    }

    /**
     * 初始化book
     * @param $ids
     * @return bool|\PDOStatement|string|\think\Collection
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    private function init_book($ids)
    {
        $booking = new \app\admin\model\Booking();
        $booking_list = $booking->where('memberid', $ids)->select();
        $this->view->assign('booking_list', $booking_list);
    }


    /**
     * 初始化order
     * @param $ids
     * @return bool|\PDOStatement|string|\think\Collection
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    private function init_order($ids)
    {
        $orders = new \app\admin\model\Orders();
        $orders_list = $orders->where('memberid', $ids)->select();
        if (!empty($orders_list)) {
            $orders_addi = new Addi();
            $orders_bonus = new Bonus();
            $orders_extra = new Extra();
            $orders_van = new Van();
            $paid_method = new Method();
            foreach ($orders_list as &$v) {
                $sum_grandtotal = 0;
                $sum_paid_amount = 0;
                $num_total_service = 0;
                $result = $orders_addi->fieldRaw('COUNT(orders_addi_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(addi_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_bonus->fieldRaw('COUNT(orders_bonus_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(bonus_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_extra->fieldRaw('COUNT(orders_extra_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(extra_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_van->fieldRaw('COUNT(orders_van_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(van_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $v->num_total_service = $num_total_service;
                $v->sum_grandtotal = $sum_grandtotal;
                $v->sum_paid_amount = $sum_paid_amount;

                if (!empty($v->paid_method_str)) {
                    $tmp = $paid_method->whereIn('paid_method_id', $v->paid_method_str)->select();
                    if (!empty($tmp)) {
                        $v->paid_method_names = implode(',', array_column($tmp,'paid_method_name'));
                    } else {
                        $v->paid_method_names = '-';
                    }
                } else {
                    $v->paid_method_names = '-';
                }
            }
        }
        $this->view->assign('orders_list', $orders_list);
    }

    /**
     * view invoice
     * @return string|void
     * @throws \think\Exception
     */
    public function view_invoice()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            $ids = input('ids');
            $this->init_service_center(0, $ids);
            $this->init_hierarchy($ids);
            $this->init_book($ids);
            $this->init_order($ids);

            return $this->view->fetch();
        }
    }

    public function view_unpaid()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            $ids = input('ids');
            $this->init_service_center(1, $ids);
            $this->init_unpaidhierarchy($ids);
            $this->init_paid_method();
//            $this->init_book($ids);
            $this->init_unpaidorder($ids);

            return $this->view->fetch();
        }
        $data = input('post.');
        $unpaid_action = $data['unpaid_action'] ?? '';
        if ('save' == $unpaid_action) {
            if (empty($data['ms_detail_id'])) {
                $this->error(__('Pleases check for save.'));
            }
            $detail = new Detail();
            foreach ($data['ms_detail_id'] as $i => $v) {
                foreach ($v as $j => $val) {
                    $update_data = [];
                    if (!empty($data['special_amount'][$i][$j])) {
                        $update_data['special_amount'] = $data['special_amount'][$i][$j];
                    }
                    if (!empty($data['paid_remark'][$i][$j])) {
                        $update_data['paid_remark'] = $data['paid_remark'][$i][$j];
                    }
                    $update_data['updateby'] = $this->auth->username;
                    $update_data['updatedate'] = date('Y-m-d H:i:s');
                    $detail->allowField(true)
                        ->where('ms_detail_id', $val)
                        ->update($update_data);
                }
            }
            $this->success();
        } else if ('payment' == $unpaid_action) {
            if (empty($data['ms_detail_id'])) {
                $this->error(__('Pleases check for payment.'));
            }
            $detail = new Detail();
            foreach ($data['ms_detail_id'] as $i => $v) {
                foreach ($v as $j => $val) {
                    if (!empty($data['paid_amount'][$i][$j])) {
                        $amount = $data['paid_amount'][$i][$j];
                        if (!empty($data['special_amount'][$i][$j])) {
                            $amount = $data['special_amount'][$i][$j];
                            if ($data['paid_amount'][$i][$j] > $data['special_amount'][$i][$j]) {
                                $this->error(__('(No.' . $data['unpaid_number'][$i][$j] . ') Pay amount over MF price(special).'));
                            } else {
                                if (empty($data['paid_remark'][$i][$j])) {
                                    $this->error(__('(No.' . $data['unpaid_number'][$i][$j] . ') The payment amount does not match with the price, please fill out the reason in remarks box.'));
                                }
                            }
                        } else {
                            if (!empty($data['package_price'][$i][$j])) {
                                if ($data['paid_amount'][$i][$j] > $data['package_price'][$i][$j]) {
                                    $this->error(__('(No.' . $data['unpaid_number'][$i][$j] . ') Pay amount over MF price.'));
                                } else {
                                    if (empty($data['paid_remark'][$i][$j])) {
                                        $this->error(__('(No.' . $data['unpaid_number'][$i][$j] . ') The payment amount does not match with the price, please fill out the reason in remarks box.'));
                                    }
                                }
                            }
                        }
                    } else {
                        $amount = 0;
                    }

                    if (empty($data['paid_date'][$i][$j])) {
                        $this->error(__('(No.' . $data['unpaid_number'][$i][$j] . ') Pleases enter payment date.'));
                    }

                    if (empty($data['paid_method'][$i][$j])) {
                        $this->error(__('(No.' . $data['unpaid_number'][$i][$j] . ') Pleases enter payment method.'));
                    }

                    if (($data['paid_method'][$i][$j] != 8 && $data['paid_method'][$i][$j] != 9) && empty($data['paid_amount'][$i][$j])) {
                        $this->error(__('(No.' . $data['unpaid_number'][$i][$j] . ') Please enter pay amount not equal to zero.'));
                    }

                    if (empty($data['paid_status'][$i][$j])) {
                        $this->error(__('(No.' . $data['unpaid_number'][$i][$j] . ') Pleases enter payment status.'));
                    }

                    $update_data = [];
                    $update_data['ms_detail_paid'] = 'N';
                    if (!empty($data['paid_amount'][$i][$j])) {
                        if ($data['paid_amount'][$i][$j] == $amount) {
                            $update_data['ms_detail_paid'] = 'P';
                        } else if ($data['paid_amount'][$i][$j] < $amount) {
                            $update_data['ms_detail_paid'] = 'W';
                        }
                    }
                    if (!empty($data['special_amount'][$i][$j])) {
                        $update_data['special_amount'] = $data['special_amount'][$i][$j];
                    }
                    if (!empty($data['paid_date'][$i][$j])) {
                        $update_data['ms_detail_paid_date'] = convertdate2db($data['paid_date'][$i][$j]);
                    }
                    if (!empty($data['paid_method'][$i][$j])) {
                        $update_data['paid_method'] = $data['paid_method'][$i][$j];
                    }
                    if (!empty($data['paid_status'][$i][$j])) {
                        $update_data['paid_status'] = $data['paid_status'][$i][$j];
                    }
                    if (!empty($data['paid_amount'][$i][$j])) {
                        $update_data['paid_amount'] = $data['paid_amount'][$i][$j];
                    }
                    if (!empty($data['paid_remark'][$i][$j])) {
                        $update_data['paid_remark'] = $data['paid_remark'][$i][$j];
                    }
                    $update_data['updateby'] = $this->auth->username;
                    $update_data['updatedate'] = date('Y-m-d H:i:s');
                    $detail->allowField(true)
                        ->where('ms_detail_id', $val)
                        ->update($update_data);
                    PaymentRecorde($val, $data['paid_amount'][$i][$j], $data['paid_method'][$i][$j], 'MF');
                }
            }
            $this->success();
        } else if ('duplicate' == $unpaid_action) {
            if (empty($data['orders_id'])) {
                $this->error(__('Pleases check for duplicate.'));
            }
            if (DuplicateOrder($data['orders_id'])) {
                $this->success();
            } else {
                $this->error(__('Error'));
            }
        } else if ('delete' == $unpaid_action) {
            if (empty($data['orders_ids'])) {
                $this->error(__('Please choose one or more records!!!'));
            }
            $data['orders_ids'] = explode(',', $data['orders_ids']);
            foreach ($data['orders_ids'] as $orders_id) {
                DeleteOrder($orders_id);
            }
            $this->success();
        } else if ('cancel' == $unpaid_action) {
            if (empty($data['orders_ids'])) {
                $this->error(__('Please choose one or more records!!!'));
            }
            $data['orders_ids'] = explode(',', $data['orders_ids']);
            foreach ($data['orders_ids'] as $orders_id) {
                CancelOrder($orders_id);
            }
            $this->success();
        } else {
            $this->error(__('Error'));
        }
    }

    /**
     * 初始化Membership
     * @param $ids
     * @return bool|\PDOStatement|string|\think\Collection
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    private function init_unpaidhierarchy($ids)
    {
        $hierarchy = new \app\admin\model\Hierarchy();
        $hierarchy_list = $hierarchy->where('hierarchy.memberid', $ids)
            ->where('hierarchy.contract_status', '<>', 'stop')
            ->with([
                'package' => function ($query) {
                    $query->withField('packagename');
                },
                'partner' => function ($query) {
                    $query->withField('login_name');
                }
            ])
            ->select();
        if (!empty($hierarchy_list)) {
            $history = new History();
            foreach ($hierarchy_list as &$item) {
                $membership_detail_list = $hierarchy->alias('H')
                    ->fieldRaw("MBSD.ms_detail_id AS   ms_detail_id
					,  MBSD.total_week AS  week_per_year
					,  MBSD.ms_detail_year AS entitlement_year
					,  MBSD.special_amount
					,  MBSD.ms_detail_paid AS ms_detail_paid
					,  MBSD.ms_detail_used AS ms_detail_used
					,  MBSD.hierarchyid AS membership_id
					,  H.hierarchyid
					,  H.servicetype AS servicetype
					,  H.contract_no AS contract_no
					,  DATE_FORMAT(MBSD.ms_detail_paid_date,'%d/%m/%Y') AS 	paid_date
					,  DATE_FORMAT(MBSD.ms_detail_paid_date,'%H:%i') AS paid_time
					,  MBSD.paid_method AS paid_method
					,  MBSD.paid_amount AS paid_amount
					,  MBSD.paid_status AS paid_status
					,  MBSD.paid_remark AS paid_remark
					,  PK.packagename  AS package_name
					,  PK.packageid AS package_id

					,  PKP.packageprice_prices AS package_price

					,  PKP.packageprice_amount1 AS amount1
					,  PKP.packageprice_prices1 AS price1
					,  PKP.packageprice_amount2 AS amount2
					,  PKP.packageprice_prices2 AS price2
					,  PKP.packageprice_amount3 AS amount3
					,  PKP.packageprice_prices3 AS price3
					,  PKP.packageprice_amount4 AS amount4
					,  PKP.packageprice_prices4 AS price4
					,  PKP.packageprice_amount5 AS amount5
					,  PKP.packageprice_prices5 AS price5")
                    ->join('membership_detail MBSD', "MBSD.hierarchyid = H.hierarchyid", 'left')
                    ->join('package PK', "PK.packageid = MBSD.packageid", 'left')
                    ->join('packageprice PKP', "PKP.packageid = MBSD.packageid  AND PKP.packageprice_years = MBSD.ms_detail_year")
                    ->where('MBSD.hierarchyid', $item->hierarchyid)
                    ->whereRaw("MBSD.paid_status = 'N' OR MBSD.paid_status='' OR ISNULL(MBSD.paid_status)")
                    ->whereRaw("MBSD.ms_detail_paid = 'W' OR MBSD.ms_detail_paid = 'N' OR MBSD.ms_detail_paid='P'")
                    ->order('MBSD.ms_detail_year', 'asc')
                    ->select();
                $tmp = [];
                foreach ($membership_detail_list as $v2) {
                    $v2_arr = $v2->toArray();
                    $history_tmp = $history->where('hierarchyid', $v2_arr['membership_id'])
                        ->where('member_id', $ids)
                        ->where('entitlement_year', $v2_arr['entitlement_year'])
                        ->select();
                    if (!empty($history_tmp)) {
                        $v2_arr['invoice_historys'] = $history_tmp;
                        $v2_arr['invoice_historys_num'] = count($history_tmp);
                    } else {
                        $v2_arr['invoice_historys'] = [];
                        $v2_arr['invoice_historys_num'] = 0;
                    }
                    $tmp[] = $v2_arr;
                }
                $item->membership_detail_list = $tmp;
            }
        }
        $this->view->assign('hierarchy_list', $hierarchy_list);
        return $hierarchy_list;
    }

    /**
     * 分配支付方式
     * @return void
     * @throws DbException
     */
    private function init_paid_method()
    {
        $list = Method::all();
        $this->view->assign('paid_method_list', $list);
    }

    /**
     * 打印
     * @return void
     */
    public function print_invoice()
    {
        PrintInvoice::print_invoice();
    }

    /**
     * @return void
     */
    public function formprint()
    {
        Formprint::formprint();
    }

    /**
     * @return void
     */
    public function printpdf()
    {
        Printpdf::printpdf();
    }

    /**
     * @param $ids
     * @return void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    public function init_unpaidorder($ids)
    {
        $orders = new \app\admin\model\Orders();
        $orders_list = $orders->where('memberid', $ids)
            ->where('paid_completed', 'N')
            ->whereRaw("status_new='N' OR status_new='E'")
            ->select();
        if (!empty($orders_list)) {
            $orders_addi = new Addi();
            $orders_bonus = new Bonus();
            $orders_extra = new Extra();
            $orders_van = new Van();
            $paid_method = new Method();
            foreach ($orders_list as &$v) {
                $sum_grandtotal = 0;
                $sum_paid_amount = 0;
                $num_total_service = 0;
                $result = $orders_addi->fieldRaw('COUNT(orders_addi_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(addi_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_bonus->fieldRaw('COUNT(orders_bonus_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(bonus_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_extra->fieldRaw('COUNT(orders_extra_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(extra_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_van->fieldRaw('COUNT(orders_van_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(van_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $v->num_total_service = $num_total_service;
                $v->sum_grandtotal = $sum_grandtotal;
                $v->sum_paid_amount = $sum_paid_amount;

                if (!empty($v->paid_method_str)) {
                    $tmp = $paid_method->whereIn('paid_method_id', $v->paid_method_str)->select();
                    if (!empty($tmp)) {
                        $v->paid_method_names = implode(',', array_column($tmp,'paid_method_name' ));
                    } else {
                        $v->paid_method_names = '-';
                    }
                } else {
                    $v->paid_method_names = '-';
                }
            }
        }
        $this->view->assign('orders_list', $orders_list);
    }

    /**
     * 发送电子邮件
     * @return void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    public function send_email()
    {
        $orders_id = input('ids');
        if (empty($orders_id)) {
            $this->error(__('Parameter error'));
        }
        $orders = new \app\admin\model\Orders();
        $orders_data = $orders->where('orders.orders_id', $orders_id)
            ->field('orders.*,member.email')
            ->join('member', 'member.memberid=orders.memberid')
            ->find();
        if (empty($orders_data)) {
            $this->error(__('Order does not exist'));
        }
        if (empty($orders_data->email)) {
            $this->error(__('Email not found!! or this member does not inform his/her email.\\nPlease contact the member.'));
        }
        $mail_to = $orders_data->email;
        $due_date = $orders_data->due_date;
        $invoice_no = $orders_data->invoice_no;

        if (empty($orders_data->invoice_no)) {
            $sql_sn = "SELECT IFNULL(MAX(invoice_sn)+1,'00001') AS invoice_sn FROM orders WHERE invoice_year='" . date("Y") . "'";
            $rs_sn = Db::query($sql_sn);
            if (!empty($rs_sn[0]['invoice_sn'])) {
                $SN = $rs_sn[0]['invoice_sn'];
                $Year = substr(date("Y"), 2, 2);
                $invoice_no = sprintf("ORD-%05d%02d%05d", $orders_data->memberid, $Year, $SN);
                $sql = "UPDATE orders SET 
						invoice_no = '" . $invoice_no . "'
						, invoice_year = '" . date("Y") . "'
						, invoice_sn = '" . sprintf("%05d", $SN) . "'
					WHERE orders_id='" . $_GET['OrderID'] . "'";
                Db::execute($sql);
            }
        }

        $msg = "
Dear member,<br><br><br>

Thank you very much for using our services.  Your invoice number is <font color='#6666FF' style='font-weight:bold'>" . $invoice_no . "</font>. We hope that<br>
we have fulfilled your needs and satisfaction for the past year.<br><br>

We would like to remind you that the payment deadline is <font color='#FF6666'><u>" . $due_date . "</u></font>, please kindly find <br>
the payment method at <a href=\"https://www.hutch-ap.com/payment\">www.hutch-ap.com</a> and use the provided login name and password to enter<br>
the payment online page.<br><br>

The failure of making payment before the deadline will result in repossession of your membership, and the<br>
further use of your membership will require a reinstate fee. If you feel in anyways that we could serve you<br>
better, please feel free to let us know.<br><br><br>

Sincerely yours,<br><br>
Hutchinson & Co Services<br><br><br>";

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";
        $res = @mail($mail_to, __('Order invoice from Hutchinson & Co Services'), $msg, $headers);
        if ($res) {
            $orders->where('orders_id', $orders_id)->update([
                'send_email' => 'Y'
            ]);
            $this->success(__('Sending invoice completed'));
        } else {
            $this->error(__('Email was not be sent'));
        }
    }

    public function orderform()
    {
        $order_main_id = input('orders_id');
        $attn_name = input('attn_name');
        if (empty($order_main_id) || empty($attn_name)) {
            $this->error(__('Parameter error'));
        }
        Orderform::orderform($order_main_id, $attn_name);
    }

    public function view_paid()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            $ids = input('ids');
            $this->init_service_center(2, $ids);
            $this->init_paidhierarchy($ids);
            $this->init_paidorder($ids);

            return $this->view->fetch();
        }
        $data = input('post.');
        $paid_action = $data['paid_action'] ?? '';
        if ('save' == $paid_action) {
            if (empty($data['ms_detail_id'])) {
                $this->error(__('Pleases check for save.'));
            }
            $detail = new Detail();
            foreach ($data['ms_detail_id'] as $i => $v) {
                foreach ($v as $j => $val) {
                    $update_data = [];
                    if (!empty($data['paid_status'][$i][$j])) {
                        $update_data['ms_detail_paid'] = 'N';
                        $update_data['paid_status'] = 'N';
                        $update_data['ms_detail_paid_date'] = '0000-00-00 00:00:00';
                        $update_data['paid_method'] = '';
                        $update_data['paid_amount'] = '';
                        $update_data['paid_remark'] = '';
                    } else {
                        if (!empty($data['paid_remark'][$i][$j])) {
                            $update_data['paid_remark'] = $data['paid_remark'][$i][$j];
                        }
                    }
                    $update_data['updateby'] = $this->auth->username;
                    $update_data['updatedate'] = date('Y-m-d H:i:s');
                    $detail->allowField(true)
                        ->where('ms_detail_id', $val)
                        ->update($update_data);
                }
            }
            $this->success();
        } else if ('renounce' == $paid_action) {
            if (empty($data['ms_detail_id'])) {
                $this->error(__('Pleases check for renounce.'));
            }
            $detail = new Detail();
            foreach ($data['ms_detail_id'] as $i => $v) {
                foreach ($v as $j => $val) {
                    $update_data = [];
                    if (!empty($data['renounce'][$i][$j])) {
                        $update_data['paid_status'] = 'N';
                    }
                    $update_data['updateby'] = $this->auth->username;
                    $update_data['updatedate'] = date('Y-m-d H:i:s');
                    $detail->allowField(true)
                        ->where('ms_detail_id', $val)
                        ->update($update_data);
                }
            }
            $this->success();
        } else if ('ac_approve' == $paid_action) {
            if (empty($data['orders_ids'])) {
                $this->error(__('Please choose one or more records!!!'));
            }
            $data['orders_ids'] = explode(',', $data['orders_ids']);
            foreach ($data['orders_ids'] as $orders_id) {
                ConfirmAccount($orders_id);
            }
            $this->success();
        } else if ('ac_renounce' == $paid_action) {
            if (empty($data['orders_ids'])) {
                $this->error(__('Please choose one or more records!!!'));
            }
            $data['orders_ids'] = explode(',', $data['orders_ids']);
            foreach ($data['orders_ids'] as $orders_id) {
                RenounceOrder($orders_id);
            }
            $this->success();
        } else {
            $this->error(__('Error'));
        }
    }

    /**
     * 初始化Membership
     * @param $ids
     * @return bool|\PDOStatement|string|\think\Collection
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    private function init_paidhierarchy($ids)
    {
        $hierarchy = new \app\admin\model\Hierarchy();
        $hierarchy_list = $hierarchy->where('hierarchy.memberid', $ids)
            ->with([
                'package' => function ($query) {
                    $query->withField('packagename');
                },
                'partner' => function ($query) {
                    $query->withField('login_name');
                }
            ])
            ->orderRaw("FIELD(hierarchy.contract_status, '', 'use', 'stop')")
            ->select();
        if (!empty($hierarchy_list)) {
            $paid_method = new Method();
            foreach ($hierarchy_list as &$item) {
                $membership_detail_list = $hierarchy->alias('H')
                    ->fieldRaw("MBSD.ms_detail_id AS   ms_detail_id
					,  MBSD.total_week AS  week_per_year
					,  MBSD.ms_detail_year AS entitlement_year
					,  MBSD.special_amount
					,  MBSD.ms_detail_paid AS ms_detail_paid
					,  MBSD.ms_detail_used AS ms_detail_used
					,  MBSD.hierarchyid AS membership_id
					,  H.hierarchyid
					,  H.servicetype AS servicetype
					,  H.contract_no AS contract_no
					,  DATE_FORMAT(MBSD.ms_detail_paid_date,'%d/%m/%Y') AS 	paid_date
					,  DATE_FORMAT(MBSD.ms_detail_paid_date,'%H:%i') AS paid_time
					,  MBSD.paid_method AS paid_method
					,  MBSD.paid_amount AS paid_amount
					,  MBSD.paid_status AS paid_status
					,  MBSD.paid_remark AS paid_remark
					,  PK.packagename  AS package_name
					,  PK.packageid AS package_id

					,  PKP.packageprice_prices AS package_price

					,  PKP.packageprice_amount1 AS amount1
					,  PKP.packageprice_prices1 AS price1
					,  PKP.packageprice_amount2 AS amount2
					,  PKP.packageprice_prices2 AS price2
					,  PKP.packageprice_amount3 AS amount3
					,  PKP.packageprice_prices3 AS price3
					,  PKP.packageprice_amount4 AS amount4
					,  PKP.packageprice_prices4 AS price4
					,  PKP.packageprice_amount5 AS amount5
					,  PKP.packageprice_prices5 AS price5")
                    ->join('membership_detail MBSD', "MBSD.hierarchyid = H.hierarchyid", 'left')
                    ->join('package PK', "PK.packageid = MBSD.packageid", 'left')
                    ->join('packageprice PKP', "PKP.packageid = MBSD.packageid  AND PKP.packageprice_years = MBSD.ms_detail_year")
                    ->where('MBSD.hierarchyid', $item->hierarchyid)
                    ->whereRaw("MBSD.paid_status = 'Y'")
                    ->whereRaw("MBSD.ms_detail_paid = 'W' OR MBSD.ms_detail_paid = 'P'")
                    ->order('MBSD.ms_detail_year', 'asc')
                    ->select();
                $tmp = [];
                foreach ($membership_detail_list as $v2) {
                    $v2_arr = $v2->toArray();
                    $paid_method_name = $paid_method->where('paid_method_id', $v2_arr['paid_method'])
                        ->value('paid_method_name');
                    if (!empty($paid_method_name)) {
                        $v2_arr['paid_method_name'] = $paid_method_name;
                    } else {
                        $v2_arr['paid_method_name'] = '';
                    }
                    $tmp[] = $v2_arr;
                }
                $item->membership_detail_list = $tmp;
            }
        }
        $this->view->assign('hierarchy_list', $hierarchy_list);
        return $hierarchy_list;
    }

    /**
     * @param $ids
     * @return void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    public function init_paidorder($ids)
    {
        $orders = new \app\admin\model\Orders();
        $orders_list = $orders->where('memberid', $ids)
            ->where('paid_completed', 'Y')
            ->whereRaw("status_new='N' OR status_new='E'")
            ->whereRaw("orders_renounce='O' OR orders_renounce='' OR ISNULL(orders_renounce)")
            ->whereRaw("booking_renounce='S' OR booking_renounce='' OR ISNULL(booking_renounce)")
            ->select();
        if (!empty($orders_list)) {
            $orders_addi = new Addi();
            $orders_bonus = new Bonus();
            $orders_extra = new Extra();
            $orders_van = new Van();
            $paid_method = new Method();
            foreach ($orders_list as &$v) {
                $sum_grandtotal = 0;
                $sum_paid_amount = 0;
                $num_total_service = 0;
                $result = $orders_addi->fieldRaw('COUNT(orders_addi_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(addi_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_bonus->fieldRaw('COUNT(orders_bonus_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(bonus_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_extra->fieldRaw('COUNT(orders_extra_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(extra_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_van->fieldRaw('COUNT(orders_van_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(van_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $v->num_total_service = $num_total_service;
                $v->sum_grandtotal = $sum_grandtotal;
                $v->sum_paid_amount = $sum_paid_amount;

                if (!empty($v->paid_method_str)) {
                    $tmp = $paid_method->whereIn('paid_method_id', $v->paid_method_str)->select();
                    if (!empty($tmp)) {
                        $v->paid_method_names = implode(',', array_column($tmp,'paid_method_name' ));
                    } else {
                        $v->paid_method_names = '-';
                    }
                } else {
                    $v->paid_method_names = '-';
                }
            }
        }
        $this->view->assign('orders_list', $orders_list);
    }

    /**
     * @return void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     * @throws Exception
     */
    public function view_all_order()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            $ids = input('ids');
            $this->init_service_center(3, $ids);
//            $this->init_hierarchy($ids);
            $this->init_order($ids);

            return $this->view->fetch();
        }
    }

    /**
     * @return string|void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws Exception
     * @throws ModelNotFoundException
     */
    public function view_new_order()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            $ids = input('ids');
            $this->init_service_center(4, $ids);
            $this->init_hierarchy($ids);

            return $this->view->fetch();
        }
    }

    /**
     * @return string|void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws Exception
     * @throws ModelNotFoundException
     */
    public function view_all_booking()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            $ids = input('ids');
            $this->init_service_center(5, $ids);
            $this->init_book($ids);

            return $this->view->fetch();
        }

        $data = input('post.');
        $booking_action = $data['booking_action'] ?? '';
        switch ($booking_action) {
            case 'delete':
                if (empty($data['booking_ids'])) {
                    $this->error(__('Please choose one or more records!!!'));
                }
                $data['booking_ids'] = explode(',', $data['booking_ids']);
                foreach ($data['booking_ids'] as $booking_id) {
                    DeleteBook($booking_id);
                }
                $this->success();
            case 'cancel':
                if (empty($data['booking_ids'])) {
                    $this->error(__('Please choose one or more records!!!'));
                }
                $data['booking_ids'] = explode(',', $data['booking_ids']);
                foreach ($data['booking_ids'] as $booking_id) {
                    ReturnDetailStatus($booking_id);
                }
                $this->success();
            case 'duplicate':
                if (empty($data['booking_id'])) {
                    $this->error(__('Pleases check for duplicate.'));
                }
                DuplicateBooking($data['booking_id']);
                $this->success();
            case 'renounce':
                if (empty($data['booking_ids'])) {
                    $this->error(__('Please choose one or more records!!!'));
                }
                $data['booking_ids'] = explode(',', $data['booking_ids']);
                foreach ($data['booking_ids'] as $booking_id) {
                    RenounceBooking($booking_id);
                }
                $this->success();
        }

        $this->error(__('Error'));
    }

    /**
     * print confirmation
     * @return void
     */
    public function print_confirmation()
    {
        $booking_id = input('booking_id');
        if (empty($booking_id)) {
            $this->error(__('Pleases check for print confirmation.'));
        }
        PrintConfirmation::print_confirmation($booking_id);
    }

    /**
     * @return string|void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws Exception
     * @throws ModelNotFoundException
     */
    public function view_new_booking()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            $ids = input('ids');
            $this->init_service_center(6, $ids);
            $this->init_booking_hierarchy($ids);
            $this->init_booking_orders($ids);
            $this->init_confirmation_type();
            return $this->view->fetch();
        }
    }

    /**
     * @return void
     */
    private function init_confirmation_type()
    {
        $sql ="
		SELECT
			CT.confirmation_type		AS	Confirmation_Type
		FROM confirmation_type CT
	";
        $this->assign('confirmation_type_list',Db::query($sql));
    }

    /**
     * 初始化Membership
     * @param $ids
     * @return bool|\PDOStatement|string|\think\Collection
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    private function init_booking_hierarchy($ids)
    {
        $hierarchy = new \app\admin\model\Hierarchy();
        $hierarchy_list = $hierarchy->where('hierarchy.memberid', $ids)
            ->distinct(true)
            ->with([
                'package' => function ($query) {
                    $query->withField('packagename');
                },
                'partner' => function ($query) {
                    $query->withField('login_name');
                }
            ])
            ->join('membership_detail', 'membership_detail.hierarchyid=hierarchy.hierarchyid', 'LEFT OUTER')
            ->where('membership_detail.paid_status', 'Y')
            ->where('membership_detail.status_booking', '<>', 'F')
            ->where('membership_detail.status_used', '<>', 'Y')
            ->select();
        if (!empty($hierarchy_list)) {
            $package = new \app\admin\model\Package();
            foreach ($hierarchy_list as &$item) {
                $membership_detail_list = $package->alias('PK')
                    ->fieldRaw("MBSD.ms_detail_id AS   ms_detail_id
					,  MBSD.total_week AS  Week_per_Year
					,  MBSD.ms_detail_year AS	entitlement_year 
					,  MBSD.paid_status AS paid_status
					,  MBSD.used_fullweek AS MSB_Detail_UsedFW
					,  MBSD.used_midweek  AS MSB_Detail_UsedMW
					,  MBSD.used_weekend AS MSB_Detail_UsedWE
					,  MBSD.ms_detail_remark AS remark
					,  PK.packagename  AS membership_type_name
					,  PK.packageid AS membership_type_id")
                    ->join('membership_detail MBSD', "PK.packageid = MBSD.packageid", 'LEFT OUTER')
                    ->where('MBSD.hierarchyid', $item->hierarchyid)
                    ->where('MBSD.paid_status', 'Y')
                    ->where('MBSD.status_used', '<>', 'Y')
                    ->where('MBSD.status_booking', '<>', 'F')
                    ->order('MBSD.ms_detail_year', 'asc')
                    ->select();
                $tmp = [];
                foreach ($membership_detail_list as $v2) {
                    $v2_arr = $v2->toArray();

                    $sql = "
										SELECT
											MBSD.total_week 							AS	Week_per_Year,
											MBSD.used_fullweek 						AS	MSB_Detail_UsedFW,
											MBSD.used_midweek  						AS	MSB_Detail_UsedMW,
											MBSD.used_weekend 						AS	MSB_Detail_UsedWE,
											SUM(IFNULL(BD.booking_detail_fullweek*BD.room,0)) 		AS	Booking_Full_Week,
											SUM(IFNULL(BD.booking_detail_midweek*BD.room,0)) 		AS	Booking_Mid_Week,
											SUM(IFNULL(BD.booking_detail_weekend*BD.room,0)) 	AS	Booking_Weekend
										FROM membership_detail MBSD
											LEFT OUTER JOIN binding_detail BiD ON
												BiD.orders_code=MBSD.orders_code
											LEFT OUTER JOIN booking_detail BD ON
												BD.booking_detail_id=BiD.booking_detail_id
												AND (BD.booking_status='N' OR ISNULL(BD.booking_status) OR BD.booking_status = '')
										WHERE MBSD.hierarchyid='" . $item->hierarchyid . "'
											AND MBSD.ms_detail_year='" . $v2["entitlement_year"] . "'
										GROUP BY MBSD.ms_detail_year
									";
                    $bookingTime = Db::query($sql);
                    $v2_arr['Available'] = availableTime($bookingTime[0] ?? []);
                    $tmp[] = $v2_arr;
                }
                $item->membership_detail_list = $tmp;
            }
        }
        $this->view->assign('hierarchy_list', $hierarchy_list);
        return $hierarchy_list;
    }

    private function init_booking_orders($ids)
    {
        $sql ="
		SELECT
			OE.orders_extra_id		AS	Extra_ID,
			OD.orders_no		AS	Order_No,
			DATE_FORMAT(IFNULL(OD.orders_date,'0000-00-00'),'%d/%m/%Y') AS Orders_Date,
			DATE_FORMAT(IFNULL(OE.checkin_date,'0000-00-00'),'%d/%m/%Y') AS ci_date,
			DATE_FORMAT(IFNULL(OE.checkout_date,'0000-00-00'),'%d/%m/%Y') AS co_date,
			OE.extra_unittype		AS	Unit_Type,
			OE.extra_price		AS	Price,
			OE.extranight			AS	Night,
			OE.room_amount,
			OE.grand_total,
			OE.remark			AS	Remark
		FROM orders_extra OE
			LEFT OUTER JOIN orders OD ON OD.orders_id=OE.orders_id
		WHERE OD.memberid='".$ids."'
			AND OE.extra_paid='Y' AND OE.status_booking = '' AND OE.status_renounce = ''
		ORDER BY OE.orders_extra_id
		";
        $this->assign('orders_extra_list',Db::query($sql));

        $sql = "
		SELECT
			OB.orders_bonus_id		AS	Bonus_ID,
			OD.orders_no			AS	Order_No,
			DATE_FORMAT(IFNULL(OD.orders_date,'0000-00-00'),'%d/%m/%Y') AS Orders_Date,
			DATE_FORMAT(IFNULL(OB.checkin_date,'0000-00-00'),'%d/%m/%Y') AS ci_date,
			DATE_FORMAT(IFNULL(OB.checkout_date,'0000-00-00'),'%d/%m/%Y') AS co_date,
			RS.resortid				AS	Resort_ID,
			RS.resortname			AS	Resort_Name,
			OB.bonus_type			AS	Bonus_Type,
			OB.bonus_unittype			AS	UnitType,
			OB.bonus_extranight		AS	Extra_Night,
			OB.bonus_weekend		AS	Weekend,
			OB.bonus_midweek			AS	Mid_Week,
			OB.bonus_fullweek			AS	Full_Week,
			OB.bonus_price			AS	Prices,
			OB.room_amount,
			OB.grand_total,
			OB.bonus_paid_amount		AS	Paid_Amount,
			PM.paid_method_name		AS	Paid_Method,
			OB.bonus_paid_date		AS	Paid_Date,
			OB.bonus_paid			AS	Paid_Completed,
			OB.remark				AS	Remark
		FROM orders_bonus OB
			LEFT OUTER JOIN resort RS ON RS.resortid=OB.resortid
			LEFT OUTER JOIN orders OD ON OD.orders_id=OB.orders_id
			LEFT OUTER JOIN paid_method PM ON PM.paid_method_id=OB.paid_method_id
		WHERE OD.memberid='".$ids."'
			AND OB.bonus_paid='Y'
			AND	OB.status_booking = ''
			AND	OB.status_renounce = ''
		ORDER BY OB.orders_bonus_id
		";
        $this->assign('orders_bonus_list',Db::query($sql));

        $sql="
		SELECT
			OX.orders_van_id		AS	Exchange_ID,
			OD.orders_no		AS	Order_No,
			DATE_FORMAT(IFNULL(OD.orders_date,'0000-00-00'),'%d/%m/%Y') AS Orders_Date,
			DATE_FORMAT(IFNULL(OX.checkin_date,'0000-00-00'),'%d/%m/%Y') AS ci_date,
			DATE_FORMAT(IFNULL(OX.checkout_date,'0000-00-00'),'%d/%m/%Y') AS co_date,
			OX.from_contract		AS	Contract_No,
			OX.from_unittype		AS	F_Unit_Type,
			OX.from_fullweek		AS	F_Full_Week,
			OX.from_midweek		AS	F_Mid_Week,
			OX.from_weekend		AS	F_Weekend,
			OX.resortid			AS	Resort,
			RS.resortname		AS	Resort_Name,
			OX.to_unittype		AS	T_Unit_Type,
			OX.to_fullweek		AS	T_Full_Week,
			OX.to_midweek		AS	T_Mid_Week,
			OX.to_weekend		AS	T_Weekend,
			OX.van_fee			AS	Price,
			OX.room_amount,
			OX.grand_total,
			OX.remark			AS	Remark
		FROM orders_van OX
			LEFT OUTER JOIN orders OD ON OD.orders_id=OX.orders_id
			LEFT OUTER JOIN resort RS ON RS.resortid=OX.resortid
		WHERE OD.memberid='".$ids."'
			AND OX.van_paid='Y' AND OX.status_booking = '' AND OX.status_renounce = ''
		ORDER BY OX.orders_van_id
		";

        $this->assign('orders_van_list',Db::query($sql));

        $sql ="
		SELECT
			OA.orders_addi_id		AS	Addition_ID,
			OD.orders_no		AS	Order_No,
			DATE_FORMAT(IFNULL(OD.orders_date,'0000-00-00'),'%d/%m/%Y') AS Orders_Date,
			OA.addi_rate_name	AS	Addition_Name,
			OA.addi_rate_price	AS	Price,
			OA.addi_unit			AS	Unit,
			OA.grand_total,
			OA.remark			AS	Remark
		FROM orders_addi OA
			LEFT OUTER JOIN orders OD ON OD.orders_id=OA.orders_id
		WHERE OD.memberid='".$ids."'
			AND OA.addi_paid='Y' AND OA.status_booking='' AND OA.status_renounce=''
		ORDER BY OA.orders_addi_id
		";
        $this->assign('orders_addi_list',Db::query($sql));
    }

    /**
     * @return string|void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws Exception
     * @throws ModelNotFoundException
     */
    public function view_un_used()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            $ids = input('ids');
            $this->init_service_center(7, $ids);
            $this->init_unusebook($ids);

            return $this->view->fetch();
        }
        $this->error(__('Error'));
    }

    /**
     * @return string|void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws Exception
     * @throws ModelNotFoundException
     */
    public function view_used()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            $ids = input('ids');
            $this->init_service_center(8, $ids);
            $this->init_usebook($ids);
            $this->init_usedorder($ids);

            return $this->view->fetch();
        }
        $this->error(__('Error'));
    }

    /**
     * 初始化book
     * @param $ids
     * @return bool|\PDOStatement|string|\think\Collection
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    private function init_unusebook($ids)
    {
        $booking = new \app\admin\model\Booking();
        $booking_list = $booking->where('memberid', $ids)
            ->where('booking_status','N')
            ->select();
        $this->view->assign('booking_list', $booking_list);
    }

    /**
     * 初始化book
     * @param $ids
     * @return bool|\PDOStatement|string|\think\Collection
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    private function init_usebook($ids)
    {
        $booking = new \app\admin\model\Booking();
        $booking_list = $booking->where('memberid', $ids)
            ->where('booking_status','U')
            ->select();
        $this->view->assign('booking_list', $booking_list);
    }

    /**
     * @return void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws Exception
     * @throws ModelNotFoundException
     */
    public function edit_booking_status()
    {
        $booking_status= input('booking_status');
        $booking_id= input('booking_id');
        if (empty($booking_id)){
            $this->error(__('Param error'));
        }
        if ($booking_status != 'U'){
            \app\admin\model\Booking::where('booking_id',$booking_id)->update([
                'booking_status' => 'U'
            ]);
            $rs = Main::where('booking_id',$booking_id)->select();
            $aModuleCode = [];
            if (!empty($rs)){
                $aModuleCode = array_column($rs,'module_code');
            }

            $rs_select = \app\admin\model\booking\Detail::where('booking_id',$booking_id)->select();
            foreach ($rs_select as $row){
                \app\admin\model\booking\Detail::where('booking_detail_id',$row['booking_detail_id'])->update([
                    'booking_status' => 'U'
                ]);
                $rs_select2 = \app\admin\model\binding\Detail::where('booking_detail_id',$row['booking_detail_id'])->select();
                foreach ($rs_select2 as $row2){
                    switch ($row2['orders_code'][0]){
                        case "b":
                            Bonus::where('orders_code',$row2['orders_code'])->update([
                                'status_booking' => 'U'
                            ]);
                            break;
                        case "e":
                            Extra::where('orders_code',$row2['orders_code'])->update([
                                'status_booking' => 'U'
                            ]);
                            break;
                        case "v":
                            Van::where('orders_code',$row2['orders_code'])->update([
                                'status_booking' => 'U'
                            ]);
                            break;
                        case "a":
                            Addi::where('orders_code',$row2['orders_code'])->update([
                                'status_booking' => 'U'
                            ]);
                            break;
                        case "m":
                            $return_FW = $row['booking_detail_fullweek']?:0;
                            $return_MW = $row['booking_detail_midweek']?:0;
                            $return_WE = $row['booking_detail_weekend']?:0;
                            Detail::where('orders_code',$row2['orders_code'])->setInc('used_fullweek',$return_FW);
                            Detail::where('orders_code',$row2['orders_code'])->setInc('used_midweek',$return_MW);
                            Detail::where('orders_code',$row2['orders_code'])->setInc('used_weekend',$return_WE);
                            break;
                    }
                }
            }
        } else {
            \app\admin\model\Booking::where('booking_id',$booking_id)->update([
                'booking_status' => 'N'
            ]);
            $rs = Main::where('booking_id',$booking_id)->select();
            $aModuleCode = [];
            if (!empty($rs)){
                $aModuleCode = array_column($rs,'module_code');
            }

            $rs_select = \app\admin\model\booking\Detail::where('booking_id',$booking_id)->select();
            foreach ($rs_select as $row){
                \app\admin\model\booking\Detail::where('booking_detail_id',$row['booking_detail_id'])->update([
                    'booking_status' => 'N'
                ]);
                $rs_select2 = \app\admin\model\binding\Detail::where('booking_detail_id',$row['booking_detail_id'])->select();
                foreach ($rs_select2 as $row2){
                    switch ($row2['orders_code'][0]){
                        case "b":
                            Bonus::where('orders_code',$row2['orders_code'])->update([
                                'status_booking' => 'F'
                            ]);
                            break;
                        case "e":
                            Extra::where('orders_code',$row2['orders_code'])->update([
                                'status_booking' => 'F'
                            ]);
                            break;
                        case "v":
                            Van::where('orders_code',$row2['orders_code'])->update([
                                'status_booking' => 'F'
                            ]);
                            break;
                        case "a":
                            Addi::where('orders_code',$row2['orders_code'])->update([
                                'status_booking' => 'F'
                            ]);
                            break;
                        case "m":
                            $return_FW = $row['booking_detail_fullweek']?:0;
                            $return_MW = $row['booking_detail_midweek']?:0;
                            $return_WE = $row['booking_detail_weekend']?:0;
                            Detail::where('orders_code',$row2['orders_code'])->setDec('used_fullweek',$return_FW);
                            Detail::where('orders_code',$row2['orders_code'])->setDec('used_midweek',$return_MW);
                            Detail::where('orders_code',$row2['orders_code'])->setDec('used_weekend',$return_WE);
                            break;
                    }
                }
            }
        }
        if (!empty($aModuleCode)){
            $list = \app\admin\model\Orders::whereIn('orders_code',$aModuleCode)->select();
            foreach ($list as $item){
                $OrderId = $item['orders_id'];
                $countPaid = CountOrderDetail($OrderId,'PaidCompleted');
                $countBooked = CountOrderDetail($OrderId,'Booked');
                if(array_sum($countPaid)==0 && array_sum($countBooked)==0){
                    $status_used = "U";
                } else {
                    $status_used = "I";
                }
                \app\admin\model\Orders::where('orders_id',$item['orders_id'])->update([
                    'status_used' => $status_used
                ]);
            }
        }
        $this->success();
    }

    /**
     * @param $ids
     * @return void
     * @throws DataNotFoundException
     * @throws DbException
     * @throws ModelNotFoundException
     */
    public function init_usedorder($ids)
    {
        $orders = new \app\admin\model\Orders();
        $orders_list = $orders->where('memberid', $ids)
            ->whereRaw("status_used='I' OR status_used='U'")
            ->whereRaw("status_booking='K' OR status_booking='F'")
            ->select();
        if (!empty($orders_list)) {
            $orders_addi = new Addi();
            $orders_bonus = new Bonus();
            $orders_extra = new Extra();
            $orders_van = new Van();
            $paid_method = new Method();
            foreach ($orders_list as &$v) {
                $sum_grandtotal = 0;
                $sum_paid_amount = 0;
                $num_total_service = 0;
                $result = $orders_addi->fieldRaw('COUNT(orders_addi_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(addi_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_bonus->fieldRaw('COUNT(orders_bonus_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(bonus_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_extra->fieldRaw('COUNT(orders_extra_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(extra_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $result = $orders_van->fieldRaw('COUNT(orders_van_id) AS num_total_service, 
							SUM(grand_total) AS grand_total, 
							SUM(van_paid_amount) AS paid_amount')
//                    ->whereNull('status_renounce')
                    ->whereRaw('status_renounce = ""')
                    ->where('orders_id', $v->orders_id)
                    ->find();
                if (!empty($result->num_total_service)) {
                    $num_total_service += $result->num_total_service;
                }
                if (!empty($result->grand_total)) {
                    $sum_grandtotal += $result->grand_total;
                }
                if (!empty($result->paid_amount)) {
                    $sum_paid_amount += $result->paid_amount;
                }

                $v->num_total_service = $num_total_service;
                $v->sum_grandtotal = $sum_grandtotal;
                $v->sum_paid_amount = $sum_paid_amount;

                if (!empty($v->paid_method_str)) {
                    $tmp = $paid_method->whereIn('paid_method_id', $v->paid_method_str)->select();
                    if (!empty($tmp)) {
                        $v->paid_method_names = implode(',', array_column($tmp,'paid_method_name' ));
                    } else {
                        $v->paid_method_names = '-';
                    }
                } else {
                    $v->paid_method_names = '-';
                }
            }
        }
        $this->view->assign('orders_list', $orders_list);
    }
}
