<?php

namespace app\admin\controller\invoice;

use app\common\controller\Backend;
use think\exception\DbException;
use think\response\Json;

/**
 *
 *
 * @icon fa fa-circle-o
 */
class Response extends Backend
{

    /**
     * Response模型对象
     * @var \app\admin\model\invoice\Response
     */
    protected $model = null;
    protected $searchFields = ['response_id', 'invoice', 'remark'];
    public function _initialize()
    {
        parent::_initialize();
        $this->model = new \app\admin\model\invoice\Response;

    }


    /**
     * 查看
     *
     * @return string|Json
     * @throws \think\Exception
     * @throws DbException
     */
    public function index()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            return $this->view->fetch();
        }
        //如果发送的来源是 Selectpage，则转发到 Selectpage
        if ($this->request->request('keyField')) {
            return $this->selectpage();
        }
        [$where, $sort, $order, $offset, $limit] = $this->buildparams();

        $list = $this->model
            ->where($where)
            ->where('invoice', '<>', '')
            ->order($sort, $order)
            ->paginate($limit);


        $rows = $list->items();

        if (!empty($rows)) {
            foreach ($rows as &$row) {

            }
        }
        $result = ['total' => $list->total(), 'rows' => $rows];
        return json($result);
    }

}
