<?php

namespace app\admin\controller\invoice\bank;

use app\admin\model\invoice\Response;
use app\common\controller\Backend;
use think\exception\DbException;
use think\response\Json;

/**
 *
 *
 * @icon fa fa-circle-o
 */
class Transaction extends Backend
{

    /**
     * Order模型对象
     * @var \app\admin\model\invoice\bank\Order
     */
    protected $model = null;
    protected $searchFields = ['transaction_id', 'bank_invoice_no', 'member_id'];
    protected $relationSearch = true;

    public function _initialize()
    {
        parent::_initialize();
        $this->model = new \app\admin\model\invoice\bank\Transaction();

    }



    /**
     * 查看
     *
     * @return string|Json
     * @throws \think\Exception
     * @throws DbException
     */
    public function index()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            return $this->view->fetch();
        }
        //如果发送的来源是 Selectpage，则转发到 Selectpage
        if ($this->request->request('keyField')) {
            return $this->selectpage();
        }
        [$where, $sort, $order, $offset, $limit] = $this->buildparams();
        $list = $this->model
            ->where($where)
            ->where('invoice_bank_transaction.send_to_bank','<>','N')
            ->with([
                'member' => function ($query) {
                    $query->withField('login_name,login_surname,username');
                },
//                'membershipdetail' => function ($query) {
//                    $query->withField('packageid,partnerid,ms_detail_year');
//                }
            ])
            ->order($sort, $order)
            ->paginate($limit);


        $rows = $list->items();
        if (!empty($rows)) {
            foreach ($rows as &$row) {
                if (!empty($row->ms_detail_paid_date)){
                    $row->ms_detail_paid_date = format_date($row->ms_detail_paid_date,'d/m/Y H:i:s');
                } else {
                    $row->ms_detail_paid_date = '-';
                }
                if (!empty($row->responce_time)){
                    $row->responce_time = format_date($row->responce_time,'d/m/Y H:i:s');
                } else {
                    $row->responce_time = '-';
                }

                $num = Response::where('invoice',$row->bank_invoice_no)->count();
                if ($num > 0){
                    $row->bank_responce = 'Y';
                } else {
                    $row->bank_responce = 'N';
                }
            }
        }
        $result = ['total' => $list->total(), 'rows' => $rows];
        return json($result);
    }

}
