<?php

namespace app\admin\controller\membership;

use app\admin\model\invoice\History;
use app\common\controller\Backend;
use think\exception\DbException;
use think\response\Json;
use function fast\e;

/**
 *
 *
 * @icon fa fa-circle-o
 */
class Detail extends Backend
{

    /**
     * Detail模型对象
     * @var \app\admin\model\membership\Detail
     */
    protected $model = null;
    protected $searchFields = ['M.memberid', 'MB.ms_detail_year', 'M.login_name', 'M.login_surname',  'M.fullname2', 'M.fullsurname2','H.contract_no'];
    protected $relationSearch = false;
    public function _initialize()
    {
        parent::_initialize();
        $this->model = new \app\admin\model\membership\Detail;

    }


    /**
     * 查看
     *
     * @return string|Json
     * @throws \think\Exception
     * @throws DbException
     */
    public function index()
    {
        //设置过滤方法
        $this->request->filter(['strip_tags', 'trim']);
        if (false === $this->request->isAjax()) {
            return $this->view->fetch();
        }
        //如果发送的来源是 Selectpage，则转发到 Selectpage
        if ($this->request->request('keyField')) {
            return $this->selectpage();
        }

        [$where, $sort, $order, $offset, $limit] = $this->buildparams();
        $map = '';
        $paid_status = '';
        $filter = input('filter');
        if (!empty($filter)) {
            $filter_arr = json_decode($filter, true);
            if (!empty($filter_arr['paid_status'])) {
                $paid_status = $filter_arr['paid_status'];
            }
        }
        if (empty($paid_status)) {
            $paid_status = input('paid_status');
            if (!empty($paid_status)){
                $paid_status = str_ireplace('?addtabs=1','',trim($paid_status));
            }
        }
        if ($paid_status == 'Y') {
            $map = "(MB.paid_status = 'Y' AND ( MB.ms_detail_paid = 'W' OR MB.ms_detail_paid = 'P' ))";
        } else if ($paid_status == 'N') {
            $map = "(M.hidden='0' AND ( MB.paid_status = 'N' OR MB.paid_status='' OR ISNULL(MB.paid_status) ) AND ( MB.ms_detail_paid = 'W' OR MB.ms_detail_paid = 'N' OR MB.ms_detail_paid='P' ) AND H.contract_status != 'stop')";
        } else {
            $map = '1=1';
        }
        $list = $this->model->alias('MB')
            ->group('H.contract_no, MB.ms_detail_year')
            ->fieldRaw("CONCAT(M.login_name, ' ', M.login_surname) as FirstCus
				, CONCAT(M.fullname2, ' ', M.fullsurname2) as SecondCus
				, M.memberid
				, M.remark
				, H.contract_no as ContractNo
				, H.contract_status
				, H.remarks
				, MB.ms_detail_id
				, MB.bank_invoice_no as PaymentNo
				, MB.ms_detail_year as Year
				, MB.memberid
				, MB.hierarchyid
				, PKP.packageprice_prices AS package_price
				, MB.special_amount
				, MB.paid_amount
				, UNIX_TIMESTAMP(MB.ms_detail_paid_date) as PaidDate
				, MB.paid_status as PaidStatus
				, PM.paid_method_name as PaidMethod")
            ->where($where)
            ->whereRaw($map)
            ->join('hierarchy H', 'MB.hierarchyid = H.hierarchyid')
            ->join('paid_method PM', 'MB.paid_method = PM.paid_method_id', 'LEFT')
            ->join('member M', 'MB.memberid = M.memberid', 'LEFT')
            ->join('packageprice PKP', 'PKP.packageid = MB.packageid  AND PKP.packageprice_years = MB.ms_detail_year', 'LEFT')
            ->order($sort, $order)
            ->paginate($limit);

        $rows = $list->items();
        if (!empty($rows)) {
            foreach ($rows as &$row) {
                $row->InvoiceNo = History::where('member_id', $row->memberid)
                    ->where('entitlement_year', $row->Year)
                    ->where('hierarchyid', $row->hierarchyid)
                    ->value('invoice_no', '-');
                if (!empty($row->package_price)) {
                    $row->package_price = money($row->package_price);
                } else {
                    $row->package_price = '-';
                }
                if (!empty($row->special_amount)) {
                    $row->special_amount = money($row->special_amount);
                } else {
                    $row->special_amount = '-';
                }
                if (!empty($row->paid_amount)) {
                    $row->paid_amount = money($row->paid_amount);
                } else {
                    $row->paid_amount = '-';
                }
                if (!empty($row->PaidDate)){
                    $row->PaidDate = stamp2date($row->PaidDate);
                } else {
                    $row->PaidDate = '-';
                }
            }
        }
        $result = ['total' => $list->total(), 'rows' => $rows];
        return json($result);
    }

}
