<?php

namespace app\admin\model;

use think\Model;


class Member extends Model
{


    // 表名
    protected $table = 'member';

    // 自动写入时间戳字段
    protected $autoWriteTimestamp = false;

    // 定义时间戳字段名
    protected $createTime = false;
    protected $updateTime = false;
    protected $deleteTime = false;

    // 追加属性
    protected $append = [
        'updatedate_text',
        'updateby_text',
        'clubname_text',
        'package_text',
        'package_unittype_text',
        'servicetype_text',
        'seasontype_text',
    ];

    public function getSeasontypeTextAttr($value, $data)
    {
        if (empty($data['memberid'])){
            return '';
        }

        $hierarchy = new Hierarchy();
        $result = $hierarchy->field('season_type')
            ->where('hierarchy.memberid',$data['memberid'])
            ->select();
        if (empty($result)){
            return '';
        }
        return implode(',',array_unique(array_column($result,'season_type')));
    }

    public function getServicetypeTextAttr($value, $data)
    {
        if (empty($data['memberid'])){
            return '';
        }

        $hierarchy = new Hierarchy();
        $result = $hierarchy->field('servicetype')
            ->where('hierarchy.memberid',$data['memberid'])
            ->select();
        if (empty($result)){
            return '';
        }
        return implode(',',array_unique(array_column($result,'servicetype')));
    }

    public function getPackageUnittypeTextAttr($value, $data)
    {
        if (empty($data['memberid'])){
            return '';
        }

        $hierarchy = new Hierarchy();
        $result = $hierarchy->field('package.unittype')->where('hierarchy.memberid',$data['memberid'])
            ->join('package','hierarchy.packageid=package.packageid','left')
            ->select();
        if (empty($result)){
            return '';
        }
        return implode(',',array_unique(array_column($result,'unittype')));
    }

    public function getPackageTextAttr($value, $data)
    {
        if (empty($data['memberid'])){
            return '';
        }

        $hierarchy = new Hierarchy();
        $result = $hierarchy->field('package.packagename')->where('hierarchy.memberid',$data['memberid'])
            ->join('package','hierarchy.packageid=package.packageid','left')
            ->select();
        if (empty($result)){
            return '';
        }
        return implode(',',array_unique(array_column($result,'packagename')));
    }

    public function getClubnameTextAttr($value, $data)
    {
        if (empty($data['memberid'])){
            return '';
        }
        $hierarchy = new Hierarchy();
        $result = $hierarchy->field('partner.login_name')->where('hierarchy.memberid',$data['memberid'])
            ->join('partner','hierarchy.partnerid=partner.partnerid','left')
            ->select();
        if (empty($result)){
            return '';
        }
        return implode(',',array_unique(array_column($result,'login_name')));
    }


    public function getUpdatebyTextAttr($value, $data)
    {
        $value = $value ? $value : ($data['updateby'] ?? "");
        if (empty($value) || empty($data['updateby_member'])) {
            return $value;
        }
        if ($data['updateby_member'] == 1) {
            return $data['title'] . $data['login_name'] . ' ' . $data['login_surname'];
        }
        return $value;
    }

    public function getUpdatedateTextAttr($value, $data)
    {
        $value = $value ? $value : ($data['updatedate'] ?? "");
        if (empty($value) || $value == '0000-00-00 00:00:00') {
            return '-';
        }
        $time = strtotime($value);
        return date('F j, Y', $time);
    }


    public function country()
    {
        return $this->belongsTo(Country::class, 'countryid', 'countryid', [], 'left')->setEagerlyType(0);
    }

    public function hierarchy()
    {
        return $this->belongsTo(Hierarchy::class, 'memberid', 'memberid', [], 'left')->setEagerlyType(0);
    }

    public function marketer()
    {
        return $this->belongsTo(Marketer::class, 'marketerid', 'marketerid', [], 'left')->setEagerlyType(0);
    }

    public function language()
    {
        return $this->belongsTo(Language::class, 'languageid', 'languageid', [], 'left')->setEagerlyType(0);
    }

    public function getTitleList()
    {
        return [
            'Mr.' => __('Mr'),
            'Miss.' => __('Miss'),
            'Mrs.' => __('Mrs'),
            'Ms.' => __('Ms'),
        ];
    }

    public function getSeasonTypeList()
    {
        return [
            'Red' => __('Red'),
            'White' => __('White'),
            'Blue' => __('Blue'),
            'Green' => __('Green'),
            'Yellow' => __('Yellow'),
        ];
    }

    public function getYearList()
    {
        $startYear = 1996;
        $endYear = $startYear + 100;
        $years = [];
        for ($i = $startYear;$i <= $endYear;$i++){
            $years[] = $i;
        }
        return $years;
    }
}
