<?php

namespace app\admin\model;

use think\Model;


class Orders extends Model
{

    

    

    // 表名
    protected $table = 'orders';
    
    // 自动写入时间戳字段
    protected $autoWriteTimestamp = false;

    // 定义时间戳字段名
    protected $createTime = false;
    protected $updateTime = false;
    protected $deleteTime = false;

    // 追加属性
    protected $append = [
        'contractno_text',
    ];



    public function getContractnoTextAttr($value, $data)
    {
        if (empty($data['memberid'])){
            return '';
        }

        $hierarchy = new Hierarchy();
        $result = $hierarchy->field('contract_no')
            ->where('hierarchy.memberid',$data['memberid'])
            ->select();
        if (empty($result)){
            return '';
        }
        return implode(',',array_unique(array_column($result,'contract_no')));
    }



    public function getStatusNewList()
    {
        return [
            'C' => __('Canceled'),
            'D' => __('Duplicated'),
            'E' => __('Processing'),
            'N' => __('New')
        ];
    }

    public function getStatusPaidList()
    {
        return [
            '' => __('Unpaid'),
            'W' => __('Paid (Not completed)'),
            'P' => __('Paid (Completed)'),
            'R' => __('Refund')
        ];
    }

    public function member()
    {
        return $this->belongsTo(Member::class, 'memberid', 'memberid', [], 'left')->setEagerlyType(0);
    }
}
