<?php

namespace app\admin\model\membership;

use app\admin\model\Booking;
use app\admin\model\Hierarchy;
use app\admin\model\Member;
use app\admin\model\Package;
use app\admin\model\Packageprice;
use app\admin\model\paid\Method;
use app\admin\model\Partner;
use app\admin\model\payment\Record;
use think\Model;


class Detail extends Model
{

    

    

    // 表名
    protected $table = 'membership_detail';
    
    // 自动写入时间戳字段
    protected $autoWriteTimestamp = false;

    // 定义时间戳字段名
    protected $createTime = false;
    protected $updateTime = false;
    protected $deleteTime = false;

    // 追加属性
    protected $append = [
        'clubname_text',
    ];


    public function member()
    {
        return $this->belongsTo(Member::class, 'memberid', 'memberid', [], 'left')->setEagerlyType(0);
    }



    public function paymentrecord()
    {
        return $this->belongsTo(Record::class, 'ms_detail_id', 'ms_detail_id', [], 'left')->setEagerlyType(0);
    }

    public function package()
    {
        return $this->belongsTo(Package::class, 'packageid', 'packageid', [], 'left')->setEagerlyType(0);
    }

    public function partner()
    {
        return $this->belongsTo(Partner::class, 'partnerid', 'partnerid', [], 'left')->setEagerlyType(0);
    }

    public function paidmethod()
    {
        return $this->belongsTo(Method::class, 'paid_method', 'paid_method_id', [], 'left')->setEagerlyType(0);
    }

    public function packageprice()
    {
        return $this->belongsTo(Packageprice::class, 'packageid', 'packageid', [], 'left')->setEagerlyType(0);
    }

    public function booking()
    {
        return $this->belongsTo(Booking::class, 'hierarchyid', 'hierarchyid', [], 'left')->setEagerlyType(0);
    }


    public function hierarchy()
    {
        return $this->belongsTo(Hierarchy::class, 'hierarchyid', 'hierarchyid', [], 'left')->setEagerlyType(0);
    }

    public function getClubnameTextAttr($value, $data)
    {
        if (empty($data['memberid'])){
            return '';
        }
        $hierarchy = new Hierarchy();
        $result = $hierarchy->field('partner.login_name')->where('hierarchy.memberid',$data['memberid'])
            ->join('partner','hierarchy.partnerid=partner.partnerid','left')
            ->select();
        if (empty($result)){
            return '';
        }
        return implode(',',array_unique(array_column($result,'login_name')));
    }
}
