<?php

namespace app\admin\validate;

use think\Validate;

class Marketer extends Validate
{
    /**
     * 验证规则
     */
    protected $rule = [
        'login_name' => 'require|unique:marketer',
        'username' => 'require|unique:marketer',
    ];
    /**
     * 提示消息
     */
    protected $message = [
    ];
    /**
     * 验证场景
     */
    protected $scene = [
        'add'  => ['login_name','username'],
        'edit' => ['login_name','username'],
    ];

    public function __construct(array $rules = [], $message = [], $field = [])
    {
        $this->field = [
            'login_name' => __('Marketer Name'),
            'username' => __('Login Name'),
        ];
        $ids = input('ids');
        if (!empty($ids)){
            $this->rule['login_name'] = 'require|unique:marketer,login_name,'.input('ids');
            $this->rule['username'] = 'require|unique:marketer,username,'.input('ids');
        }
        parent::__construct($rules, $message, $field);
    }
}
